/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Singleton;
import com.google.inject.internal.InjectorBuilder;
import com.google.inject.internal.InjectorImpl;
import com.google.inject.internal.LinkedBindingImpl;
import com.google.inject.spi.BindingScopingVisitor;
import java.lang.annotation.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scopes {
    private static final Object NULL = new Object();
    public static final Scope SINGLETON = new Scope(){

        @Override
        public <T> Provider<T> scope(Key<T> key, final Provider<T> creator) {
            return new Provider<T>(){
                private volatile Object instance;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public T get() {
                    Object localInstance;
                    if (this.instance == null) {
                        Class<InjectorBuilder> clazz = InjectorBuilder.class;
                        // MONITORENTER : com.google.inject.internal.InjectorBuilder.class
                        if (this.instance == null) {
                            Object nullableInstance = creator.get();
                            this.instance = nullableInstance != null ? nullableInstance : NULL;
                        }
                        // MONITOREXIT : clazz
                    }
                    Object returnedInstance = (localInstance = this.instance) != NULL ? localInstance : null;
                    return returnedInstance;
                }

                public String toString() {
                    return String.format("%s[%s]", creator, SINGLETON);
                }
            };
        }

        @Override
        public String toString() {
            return "Scopes.SINGLETON";
        }
    };
    public static final Scope NO_SCOPE = new Scope(){

        @Override
        public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
            return unscoped;
        }

        @Override
        public String toString() {
            return "Scopes.NO_SCOPE";
        }
    };

    private Scopes() {
    }

    public static boolean isSingleton(Binding<?> binding) {
        while (true) {
            LinkedBindingImpl linkedBinding;
            InjectorImpl injector;
            boolean singleton;
            if (singleton = binding.acceptScopingVisitor(new BindingScopingVisitor<Boolean>(){

                @Override
                public Boolean visitNoScoping() {
                    return false;
                }

                @Override
                public Boolean visitScopeAnnotation(Class<? extends Annotation> scopeAnnotation) {
                    return Singleton.class == scopeAnnotation;
                }

                @Override
                public Boolean visitScope(Scope scope) {
                    return scope == SINGLETON;
                }

                @Override
                public Boolean visitEagerSingleton() {
                    return true;
                }
            }).booleanValue()) {
                return true;
            }
            if (!(binding instanceof LinkedBindingImpl) || (injector = (linkedBinding = (LinkedBindingImpl)binding).getInjector()) == null) break;
            binding = injector.getBinding(linkedBinding.getLinkedKey());
        }
        return false;
    }
}

