/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.music;

import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.Album;
import com.pugh.sockso.music.Artist;
import com.pugh.sockso.music.MusicItem;
import com.pugh.sockso.music.Playlist;
import com.pugh.sockso.web.BadRequestException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Track
extends MusicItem {
    private static final Logger log = Logger.getLogger(Track.class);
    private final Artist artist;
    private final Album album;
    private final String path;
    private final int number;
    private final Date dateAdded;
    private int playCount = 0;

    public Track(Artist artist, Album album, int id, String name, String path, int number, Date dateAdded) {
        super("track", id, name);
        this.artist = artist;
        this.album = album;
        this.path = path;
        this.number = number;
        this.dateAdded = dateAdded;
    }

    public Artist getArtist() {
        return this.artist;
    }

    public Album getAlbum() {
        return this.album;
    }

    public String getPath() {
        return this.path;
    }

    public int getNumber() {
        return this.number;
    }

    public int getPlayCount() {
        return this.playCount;
    }

    public Date getDateAdded() {
        return this.dateAdded;
    }

    public void setPlayCount(int playCount) {
        this.playCount = playCount;
    }

    public static Track createFromResultSet(ResultSet rs) throws SQLException {
        Artist artist = new Artist(rs.getInt("artistId"), rs.getString("artistName"));
        return new Track(artist, new Album(artist, rs.getInt("albumId"), rs.getString("albumName")), rs.getInt("trackId"), rs.getString("trackName"), rs.getString("trackPath"), rs.getInt("trackNo"), rs.getDate("dateAdded"));
    }

    public static Vector<Track> createVectorFromResultSet(ResultSet rs) throws SQLException {
        Vector<Track> tracks = new Vector<Track>();
        while (rs.next()) {
            tracks.addElement(Track.createFromResultSet(rs));
        }
        return tracks;
    }

    public static String getSelectSql() {
        return " select ar.id as artistId, ar.name as artistName,  al.id as albumId, al.name as albumName,  t.id as trackId, t.name as trackName, t.path as trackPath,  t.track_no as trackNo, t.date_added as dateAdded ";
    }

    public static String getSelectFromSql() {
        return Track.getSelectSql() + " from tracks t " + " inner join artists ar " + " on ar.id = t.artist_id " + " inner join albums al " + " on al.id = t.album_id ";
    }

    private static String getPlaylistSql(String type, int id, String orderBySql) throws BadRequestException {
        String selectSql = Track.getSelectFromSql();
        if (type.equals("tr")) {
            return selectSql + " where t.id = '" + id + "' " + orderBySql;
        }
        if (type.equals("al")) {
            return selectSql + " where t.album_id = '" + id + "' " + (orderBySql.equals("") ? " order by t.track_no asc " : orderBySql);
        }
        if (type.equals("ar")) {
            return selectSql + " where t.artist_id = '" + id + "' " + (orderBySql.equals("") ? " order by al.name asc, t.track_no asc " : orderBySql);
        }
        if (type.equals("pl")) {
            return Playlist.getSelectTracksSql(id, orderBySql.equals("") ? " order by pt.id asc " : orderBySql);
        }
        throw new BadRequestException("unknown play type: " + type, 400);
    }

    public static Vector<Track> getTracks(Database db, String type, int id) throws SQLException, BadRequestException {
        return Track.getTracks(db, type, id, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<Track> getTracks(Database db, String type, int id, String orderBySql) throws SQLException, BadRequestException {
        Vector<Track> vector;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            String sql = Track.getPlaylistSql(type, id, orderBySql);
            Vector<Track> songs = new Vector<Track>();
            st = db.prepare(sql);
            rs = st.executeQuery();
            while (rs.next()) {
                songs.add(Track.createFromResultSet(rs));
            }
            vector = songs;
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return vector;
    }

    public static Vector<Track> getTracksFromPlayArgs(Database db, String[] args) throws SQLException, BadRequestException {
        return Track.getTracksFromPlayArgs(db, args, "");
    }

    public static Vector<Track> getTracksFromPlayArgs(Database db, String[] args, String orderBySql) throws SQLException, BadRequestException {
        Vector<Track> tracks = new Vector<Track>();
        for (String arg : args) {
            String type = arg.substring(0, 2);
            int id = Integer.parseInt(arg.substring(2, arg.length()));
            tracks.addAll(Track.getTracks(db, type, id, orderBySql));
        }
        return tracks;
    }
}

