/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.status;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.status.VersioningPanel;
import org.netbeans.modules.subversion.util.Context;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class SvnVersioningTopComponent
extends TopComponent
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private VersioningPanel syncPanel;
    private Context context;
    private String contentTitle;
    private String branchTitle;
    private long lastUpdateTimestamp;
    private static SvnVersioningTopComponent instance;

    public SvnVersioningTopComponent() {
        this.putClientProperty("SlidingName", NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.setName(NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/subversion/resources/icons/versioning-view.png"));
        this.setLayout(new BorderLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.syncPanel = new VersioningPanel(this);
        this.add(this.syncPanel);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    protected void componentActivated() {
        this.updateTitle();
        this.syncPanel.focus();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.context);
        objectOutput.writeObject(this.contentTitle);
        objectOutput.writeLong(this.lastUpdateTimestamp);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.context = (Context)objectInput.readObject();
        this.contentTitle = (String)objectInput.readObject();
        this.lastUpdateTimestamp = objectInput.readLong();
        this.syncPanel.deserialize();
    }

    protected void componentOpened() {
        super.componentOpened();
        this.refreshContent();
    }

    protected void componentClosed() {
        super.componentClosed();
    }

    private void refreshContent() {
        if (this.syncPanel == null) {
            return;
        }
        this.updateTitle();
        this.syncPanel.setContext(this.context);
    }

    public void setContentTitle(String string) {
        this.contentTitle = string;
        this.updateTitle();
    }

    void setBranchTitle(String string) {
        this.branchTitle = string;
        this.updateTitle();
    }

    public void contentRefreshed() {
        this.lastUpdateTimestamp = System.currentTimeMillis();
        this.updateTitle();
    }

    private void updateTitle() {
        final String string = this.computeAge(System.currentTimeMillis() - this.lastUpdateTimestamp);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (SvnVersioningTopComponent.this.contentTitle == null) {
                    SvnVersioningTopComponent.this.setName(NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
                } else if (SvnVersioningTopComponent.this.branchTitle == null) {
                    SvnVersioningTopComponent.this.setName(NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_MultiTitle", (Object)SvnVersioningTopComponent.this.contentTitle, (Object)string));
                } else {
                    SvnVersioningTopComponent.this.setName(NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title_ContentBranch", (Object)SvnVersioningTopComponent.this.contentTitle, (Object)SvnVersioningTopComponent.this.branchTitle, (Object)string));
                }
            }
        });
    }

    String getContentTitle() {
        return this.contentTitle;
    }

    private String computeAge(long l) {
        if (this.lastUpdateTimestamp == 0L) {
            return NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_AgeUnknown");
        }
        if (l < 1000L) {
            return NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_AgeCurrent");
        }
        if (l < 2000L) {
            return NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_AgeOneSecond");
        }
        if (l < 60000L) {
            return NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_AgeSeconds", (Object)Long.toString(l / 1000L));
        }
        if (l < 120000L) {
            return NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_AgeOneMinute");
        }
        if (l < 3600000L) {
            return NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_AgeMinutes", (Object)Long.toString(l / 60000L));
        }
        if (l < 0x6DDD00L) {
            return NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_AgeOneHour");
        }
        if (l < 86400000L) {
            return NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_AgeHours", (Object)Long.toString(l / 3600000L));
        }
        if (l < 172800000L) {
            return NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_AgeOneDay");
        }
        return NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_AgeDays", (Object)Long.toString(l / 86400000L));
    }

    public static synchronized SvnVersioningTopComponent getInstance() {
        if (instance == null && (instance = (SvnVersioningTopComponent)WindowManager.getDefault().findTopComponent("svnversioning")) == null) {
            Subversion.LOG.log(Level.INFO, null, new IllegalStateException("Can not find Versioning component"));
            instance = new SvnVersioningTopComponent();
        }
        return instance;
    }

    public Object readResolve() {
        return SvnVersioningTopComponent.getInstance();
    }

    public void performRefreshAction() {
        this.syncPanel.performRefreshAction();
    }

    public void setContext(Context context) {
        this.syncPanel.cancelRefresh();
        if (context == null) {
            this.setName(NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"MSG_Preparing"));
            this.setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setEnabled(true);
            this.setCursor(Cursor.getDefaultCursor());
            this.context = context;
            this.setBranchTitle(null);
            this.refreshContent();
        }
        this.setToolTipText(this.getContextFilesList(context, NbBundle.getMessage(SvnVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title")));
    }

    private String getContextFilesList(Context context, String string) {
        if (context == null || context.getFiles().length == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("<html>");
        for (File file : context.getFiles()) {
            stringBuffer.append(file.getAbsolutePath());
            stringBuffer.append("<br>");
        }
        stringBuffer.delete(stringBuffer.length() - 4, Integer.MAX_VALUE);
        return stringBuffer.toString();
    }

    public boolean hasContext() {
        return this.context != null && this.context.getFiles().length > 0;
    }

    protected String preferredID() {
        return "synchronize";
    }

    public int getPersistenceType() {
        return 0;
    }
}

