/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.MissingResourceException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ActionUtils;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public abstract class ContextAction
extends NodeAction {
    protected ContextAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected abstract String getBaseName(Node[] var1);

    protected boolean enable(Node[] nodeArray) {
        File[] fileArray = this.getCachedContext(nodeArray).getRootFiles();
        return fileArray.length > 0 && SvnUtils.isManaged(fileArray[0]);
    }

    protected void performAction(Node[] nodeArray) {
        LifecycleManager.getDefault().saveAll();
        Utils.logVCSActionEvent((String)"SVN");
        this.performContextAction(nodeArray);
    }

    protected SVNUrl getSvnUrl(Node[] nodeArray) throws SVNClientException {
        return ContextAction.getSvnUrl(this.getContext(nodeArray));
    }

    public static SVNUrl getSvnUrl(Context context) throws SVNClientException {
        File[] fileArray = context.getRootFiles();
        return SvnUtils.getRepositoryRootUrl(fileArray[0]);
    }

    protected abstract void performContextAction(Node[] var1);

    public final boolean isEnabled() {
        return super.isEnabled();
    }

    public final void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
    }

    public final void performAction() {
        super.performAction();
    }

    public String getRunningName(Node[] nodeArray) {
        return this.getName("Running", nodeArray);
    }

    public String getName() {
        return this.getName("", TopComponent.getRegistry().getActivatedNodes());
    }

    public String getName(String string, Node[] nodeArray) {
        Project project;
        Node node;
        String string2 = this.getBaseName(nodeArray) + string;
        if (!this.isEnabled()) {
            return NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(string2);
        }
        File[] fileArray = this.getCachedContext(nodeArray).getFiles();
        int n = fileArray.length;
        boolean bl = true;
        for (int i = 0; i < nodeArray.length; ++i) {
            node = nodeArray[i];
            project = (Project)node.getLookup().lookup(Project.class);
            if (project != null) continue;
            bl = false;
            break;
        }
        if (bl) {
            n = nodeArray.length;
        }
        if (n == 0) {
            return NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(string2);
        }
        if (n == 1) {
            String string3;
            if (bl) {
                String string4 = ProjectUtils.getInformation((Project)((Project)nodeArray[0].getLookup().lookup(Project.class))).getDisplayName();
                return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)(string2 + "_Context"), (Object)string4);
            }
            node = (FileObject)nodeArray[0].getLookup().lookup(FileObject.class);
            if (node != null) {
                string3 = node.getNameExt();
            } else {
                project = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
                if (project instanceof DataShadow) {
                    project = ((DataShadow)project).getOriginal();
                }
                string3 = project != null ? project.getPrimaryFile().getNameExt() : nodeArray[0].getDisplayName();
            }
            return MessageFormat.format(NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(string2 + "_Context"), string3);
        }
        if (bl) {
            try {
                return MessageFormat.format(NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(string2 + "_Projects"), new Integer(n));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return MessageFormat.format(NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(string2 + "_Context_Multiple"), new Integer(n));
    }

    public String getContextDisplayName(Node[] nodeArray) {
        Node node;
        File[] fileArray = this.getCachedContext(nodeArray).getFiles();
        int n = fileArray.length;
        boolean bl = true;
        for (int i = 0; i < nodeArray.length; ++i) {
            node = nodeArray[i];
            Project project = (Project)node.getLookup().lookup(Project.class);
            if (project != null) continue;
            bl = false;
            break;
        }
        if (bl) {
            n = nodeArray.length;
        }
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            if (bl) {
                return ProjectUtils.getInformation((Project)((Project)nodeArray[0].getLookup().lookup(Project.class))).getDisplayName();
            }
            FileObject fileObject = (FileObject)nodeArray[0].getLookup().lookup(FileObject.class);
            if (fileObject != null) {
                return fileObject.getNameExt();
            }
            node = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
            if (node instanceof DataShadow) {
                node = ((DataShadow)node).getOriginal();
            }
            if (node != null) {
                return node.getPrimaryFile().getNameExt();
            }
            return nodeArray[0].getDisplayName();
        }
        if (bl) {
            try {
                return MessageFormat.format(NbBundle.getBundle(ContextAction.class).getString("MSG_ActionContext_MultipleProjects"), new Integer(n));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return MessageFormat.format(NbBundle.getBundle(ContextAction.class).getString("MSG_ActionContext_MultipleFiles"), new Integer(n));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    protected Context getCachedContext(Node[] nodeArray) {
        return SvnUtils.getCurrentContext(nodeArray, this.getFileEnabledStatus(), this.getDirectoryEnabledStatus(), true);
    }

    protected Context getContext(Node[] nodeArray) {
        return SvnUtils.getCurrentContext(nodeArray, this.getFileEnabledStatus(), this.getDirectoryEnabledStatus(), false);
    }

    protected int getFileEnabledStatus() {
        return -1;
    }

    protected int getDirectoryEnabledStatus() {
        return -4;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected RequestProcessor createRequestProcessor(Node[] nodeArray) {
        SVNUrl sVNUrl = null;
        try {
            sVNUrl = this.getSvnUrl(nodeArray);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
        }
        return Subversion.getInstance().getRequestProcessor(sVNUrl);
    }

    protected static abstract class ProgressSupport
    extends SvnProgressSupport {
        private final ContextAction action;
        private final Node[] nodes;
        private long progressStamp;
        private String runningName;

        public ProgressSupport(ContextAction contextAction, Node[] nodeArray) {
            this.action = contextAction;
            this.nodes = nodeArray;
        }

        public RequestProcessor.Task start(RequestProcessor requestProcessor) {
            this.runningName = ActionUtils.cutAmpersand(this.action.getRunningName(this.nodes));
            SVNUrl sVNUrl = null;
            try {
                sVNUrl = ContextAction.getSvnUrl(this.action.getContext(this.nodes));
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            }
            return this.start(requestProcessor, sVNUrl, this.runningName);
        }

        public abstract void perform();

        protected void startProgress() {
            this.getLogger().logCommandLine("==[IDE]== " + DateFormat.getDateTimeInstance().format(new Date()) + " " + this.runningName);
            ProgressHandle progressHandle = this.getProgressHandle();
            progressHandle.setInitialDelay(500);
            this.progressStamp = System.currentTimeMillis() + 500L;
            progressHandle.start();
        }

        protected void finnishProgress() {
            if (this.isCanceled()) {
                this.getLogger().logCommandLine("==[IDE]== " + DateFormat.getDateTimeInstance().format(new Date()) + " " + this.runningName + " " + NbBundle.getMessage(ContextAction.class, (String)"MSG_Progress_Canceled"));
            } else {
                final ProgressHandle progressHandle = this.getProgressHandle();
                progressHandle.switchToDeterminate(100);
                progressHandle.progress(NbBundle.getMessage(ContextAction.class, (String)"MSG_Progress_Done"), 100);
                if (System.currentTimeMillis() > this.progressStamp) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            progressHandle.finish();
                        }
                    }, 15000);
                } else {
                    progressHandle.finish();
                }
                this.getLogger().logCommandLine("==[IDE]== " + DateFormat.getDateTimeInstance().format(new Date()) + " " + this.runningName + " " + NbBundle.getMessage(ContextAction.class, (String)"MSG_Progress_Finished"));
            }
        }
    }
}

