/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.options;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.options.AnnotationExpression;
import org.netbeans.modules.subversion.options.AnnotationSettingsPanel;
import org.netbeans.modules.subversion.options.EditAnnotationPanel;
import org.netbeans.modules.subversion.options.SvnOptionsController;
import org.netbeans.modules.subversion.ui.wizards.URLPatternWizard;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationSettings
implements ActionListener,
TableModelListener,
ListSelectionListener {
    private final AnnotationSettingsPanel panel = new AnnotationSettingsPanel();
    private DialogDescriptor dialogDescriptor;
    private boolean valid;

    public AnnotationSettings() {
        this.getModel().addTableModelListener(this);
        this.getSelectionModel().addListSelectionListener(this);
        this.panel.upButton.setEnabled(false);
        this.panel.downButton.setEnabled(false);
        this.panel.removeButton.setEnabled(false);
        this.panel.editButton.setEnabled(false);
        this.panel.upButton.addActionListener(this);
        this.panel.downButton.addActionListener(this);
        this.panel.newButton.addActionListener(this);
        this.panel.removeButton.addActionListener(this);
        this.panel.editButton.addActionListener(this);
        this.panel.resetButton.addActionListener(this);
        this.panel.wizardButton.addActionListener(this);
        this.panel.warningLabel.setVisible(false);
    }

    private void setValid(boolean bl) {
        if (!bl) {
            this.panel.warningLabel.setText(NbBundle.getMessage(AnnotationSettings.class, (String)"MSG_MissingFolderVariable"));
        }
        this.panel.warningLabel.setVisible(!bl);
        this.panel.upButton.setVisible(bl);
        this.panel.downButton.setVisible(bl);
        this.panel.newButton.setVisible(bl);
        this.panel.removeButton.setVisible(bl);
        this.panel.editButton.setVisible(bl);
        this.panel.resetButton.setVisible(bl);
        this.panel.wizardButton.setVisible(bl);
        this.panel.expresionsTable.setVisible(bl);
        this.panel.expressionsPane.setVisible(bl);
        this.panel.tableLabel.setVisible(bl);
    }

    JPanel getPanel() {
        return this.panel;
    }

    void show(boolean bl) {
        this.setValid(bl);
        String string = NbBundle.getMessage(SvnOptionsController.class, (String)"CTL_ManageLabels");
        String string2 = NbBundle.getMessage(SvnOptionsController.class, (String)"ACSD_ManageLabels");
        HelpCtx helpCtx = new HelpCtx(AnnotationSettings.class);
        this.dialogDescriptor = new DialogDescriptor((Object)this.panel, string);
        this.dialogDescriptor.setModal(true);
        this.dialogDescriptor.setHelpCtx(helpCtx);
        this.dialogDescriptor.setValid(bl);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(string2);
        dialog.setAlwaysOnTop(false);
        dialog.setVisible(true);
    }

    void update() {
        this.reset(SvnModuleConfig.getDefault().getAnnotationExpresions());
    }

    boolean isChanged() {
        List<AnnotationExpression> list;
        List<AnnotationExpression> list2 = SvnModuleConfig.getDefault().getAnnotationExpresions();
        return !SvnUtils.equals(list2, list = this.getAnnotationExpressions());
    }

    void applyChanges() {
        List<AnnotationExpression> list = this.getAnnotationExpressions();
        SvnModuleConfig.getDefault().setAnnotationExpresions(list);
    }

    private List<AnnotationExpression> getAnnotationExpressions() {
        TableModel tableModel = this.panel.expresionsTable.getModel();
        ArrayList<AnnotationExpression> arrayList = new ArrayList<AnnotationExpression>(tableModel.getRowCount());
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            String string = (String)tableModel.getValueAt(i, 0);
            if (string.trim().equals("")) continue;
            String string2 = (String)tableModel.getValueAt(i, 1);
            arrayList.add(new AnnotationExpression(string, string2));
        }
        return arrayList;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.panel.upButton) {
            this.onUpClick();
        } else if (actionEvent.getSource() == this.panel.downButton) {
            this.onDownClick();
        } else if (actionEvent.getSource() == this.panel.newButton) {
            this.onNewClick();
        } else if (actionEvent.getSource() == this.panel.removeButton) {
            this.onRemoveClick();
        } else if (actionEvent.getSource() == this.panel.editButton) {
            this.onEditClick();
        } else if (actionEvent.getSource() == this.panel.resetButton) {
            this.onResetClick();
        } else if (actionEvent.getSource() == this.panel.wizardButton) {
            this.onWizardClick();
        }
    }

    private void onUpClick() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        if (n > 0) {
            DefaultTableModel defaultTableModel = this.getModel();
            int n2 = n - 1;
            defaultTableModel.moveRow(n, n, n2);
            listSelectionModel.setSelectionInterval(n2, n2);
        }
    }

    private void onDownClick() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        DefaultTableModel defaultTableModel = this.getModel();
        if (n > -1 && n < defaultTableModel.getRowCount() - 1) {
            int n2 = n + 1;
            defaultTableModel.moveRow(n, n, n2);
            listSelectionModel.setSelectionInterval(n2, n2);
        }
    }

    private void onNewClick() {
        EditAnnotationPanel editAnnotationPanel = new EditAnnotationPanel();
        String string = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettings.new.title");
        if (this.showEdit(editAnnotationPanel, string)) {
            this.addRow(editAnnotationPanel.patternTextField.getText(), editAnnotationPanel.folderTextField.getText());
        }
    }

    private void addRow(String string, String string2) {
        int n = this.getSelectionModel().getMinSelectionIndex();
        if (n < 0) {
            this.getModel().addRow(new String[]{string, string2});
        } else {
            this.getModel().insertRow(n, new String[]{string, string2});
        }
    }

    private void onRemoveClick() {
        int n;
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        int n2 = listSelectionModel.getMinSelectionIndex();
        if (n2 > -1) {
            this.getModel().removeRow(n2);
        }
        if ((n = this.getModel().getRowCount()) > 0) {
            if (n2 > n - 1) {
                n2 = n - 1;
            }
            listSelectionModel.setSelectionInterval(n2, n2);
        }
    }

    private void onEditClick() {
        String string;
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        if (n < 0) {
            return;
        }
        String string2 = (String)this.getModel().getValueAt(n, 0);
        String string3 = (String)this.getModel().getValueAt(n, 1);
        EditAnnotationPanel editAnnotationPanel = new EditAnnotationPanel();
        if (string2 != null) {
            editAnnotationPanel.patternTextField.setText(string2);
        }
        if (string3 != null) {
            editAnnotationPanel.folderTextField.setText(string3);
        }
        if (this.showEdit(editAnnotationPanel, string = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettings.edit.title"))) {
            this.getModel().setValueAt(editAnnotationPanel.patternTextField.getText(), n, 0);
            this.getModel().setValueAt(editAnnotationPanel.folderTextField.getText(), n, 1);
        }
    }

    private void onResetClick() {
        this.reset(SvnModuleConfig.getDefault().getDefaultAnnotationExpresions());
    }

    private void onWizardClick() {
        URLPatternWizard uRLPatternWizard = new URLPatternWizard();
        if (!uRLPatternWizard.show()) {
            return;
        }
        String string = uRLPatternWizard.getPattern();
        String string2 = uRLPatternWizard.useName() ? uRLPatternWizard.getRepositoryFolder() : "\\1";
        this.addRow(string, string2);
    }

    private void reset(List<AnnotationExpression> list) {
        this.getSelectionModel().setSelectionMode(0);
        DefaultTableModel defaultTableModel = this.getModel();
        defaultTableModel.setColumnCount(2);
        defaultTableModel.setRowCount(list.size());
        int n = -1;
        for (AnnotationExpression annotationExpression : list) {
            defaultTableModel.setValueAt(annotationExpression.getUrlExp(), ++n, 0);
            defaultTableModel.setValueAt(annotationExpression.getAnnotationExp(), n, 1);
        }
    }

    private DefaultTableModel getModel() {
        return (DefaultTableModel)this.panel.expresionsTable.getModel();
    }

    private ListSelectionModel getSelectionModel() {
        return this.panel.expresionsTable.getSelectionModel();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0) {
            this.validateTable(tableModelEvent.getFirstRow(), tableModelEvent.getColumn());
        }
    }

    private void validateTable(int n, int n2) {
        if (n < 0 || n2 != 0) {
            return;
        }
        this.valid = true;
        String string = (String)this.getModel().getValueAt(n, n2);
        try {
            Pattern.compile(string);
        }
        catch (Exception exception) {
            this.valid = false;
        }
        if (this.valid) {
            this.panel.warningLabel.setVisible(false);
        } else {
            String string2 = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettingsPanel.warningLabel.text", (Object)string);
            this.panel.warningLabel.setText(string2);
            this.panel.warningLabel.setVisible(true);
        }
        if (this.dialogDescriptor != null) {
            this.dialogDescriptor.setValid(this.valid);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        this.panel.upButton.setEnabled(n > 0);
        this.panel.downButton.setEnabled(n > -1 && n < this.getModel().getRowCount() - 1);
        this.panel.removeButton.setEnabled(n > -1);
        this.panel.editButton.setEnabled(n > -1);
    }

    private boolean showEdit(final EditAnnotationPanel editAnnotationPanel, String string) {
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)editAnnotationPanel, string);
        dialogDescriptor.setModal(true);
        dialogDescriptor.setValid(this.isValid(editAnnotationPanel));
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.validate();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.validate();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.validate();
            }

            private void validate() {
                dialogDescriptor.setValid(AnnotationSettings.this.isValid(editAnnotationPanel));
            }
        };
        editAnnotationPanel.patternTextField.getDocument().addDocumentListener(documentListener);
        editAnnotationPanel.folderTextField.getDocument().addDocumentListener(documentListener);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        return dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION;
    }

    private boolean isValid(EditAnnotationPanel editAnnotationPanel) {
        return !editAnnotationPanel.patternTextField.getText().trim().equals("") && !editAnnotationPanel.folderTextField.getText().trim().equals("");
    }
}

