/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.notifications;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.kenai.SvnKenaiSupport;
import org.netbeans.modules.subversion.ui.diff.DiffAction;
import org.netbeans.modules.subversion.ui.history.SearchHistoryAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.VCSNotificationDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class NotificationsManager {
    private static NotificationsManager instance;
    private static final Logger LOG;
    private static final Set<File> alreadySeen;
    private static final String CMD_DIFF = "cmd.diff";
    private final HashSet<File> files;
    private final RequestProcessor rp;
    private final RequestProcessor.Task notificationTask;
    private final FileStatusCache cache;
    private final SvnKenaiSupport supp;
    private Boolean enabled;
    private Map<File, Long> notifiedFiles = Collections.synchronizedMap(new HashMap());

    private NotificationsManager() {
        this.files = new HashSet();
        this.rp = new RequestProcessor("SubversionNotifications", 1, true);
        this.notificationTask = this.rp.create((Runnable)new NotificationTask());
        this.cache = Subversion.getInstance().getStatusCache();
        this.supp = SvnKenaiSupport.getInstance();
    }

    public static synchronized NotificationsManager getInstance() {
        if (instance == null) {
            instance = new NotificationsManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleFor(File file) {
        if (!this.isEnabled() || this.isSeen(file) || !this.isUpToDate(file)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("File " + file.getAbsolutePath() + " is " + (this.isUpToDate(file) ? "" : "not ") + " up to date, notifications enabled: " + this.isEnabled());
            }
            return;
        }
        boolean bl = false;
        HashSet<File> hashSet = this.files;
        synchronized (hashSet) {
            int n = this.files.size();
            this.files.add(file);
            bl = this.files.size() != n;
        }
        if (bl) {
            this.notificationTask.schedule(1000);
        }
    }

    public void notfied(File[] fileArray, Long l) {
        for (File file : fileArray) {
            this.notifiedFiles.put(file, l);
        }
    }

    public void setupPane(JTextPane jTextPane, final File[] fileArray, String string, final File file, final String string2, final String string3) {
        String string4 = string3 == null ? NbBundle.getMessage(NotificationsManager.class, (String)"MSG_NotificationBubble_DeleteDescription", (Object)string, (Object)CMD_DIFF) : NbBundle.getMessage(NotificationsManager.class, (String)"MSG_NotificationBubble_Description", (Object)string, (Object)string2, (Object)CMD_DIFF);
        jTextPane.setText(string4);
        jTextPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    if (NotificationsManager.CMD_DIFF.equals(hyperlinkEvent.getDescription())) {
                        Context context = new Context(fileArray);
                        DiffAction.diff(context, 1, NbBundle.getMessage(NotificationsManager.class, (String)"LBL_Remote_Changes", (Object)file.getName()));
                    } else if (string3 != null) {
                        try {
                            SearchHistoryAction.openSearch(new SVNUrl(string2), file, Long.parseLong(string3));
                        }
                        catch (MalformedURLException malformedURLException) {
                            LOG.log(Level.WARNING, null, malformedURLException);
                        }
                    }
                }
            }
        });
    }

    private boolean isEnabled() {
        if (this.enabled == null) {
            this.enabled = new Boolean(!"false".equals(System.getProperty("subversion.notificationsEnabled", "true")));
        }
        return this.enabled != false && this.supp.isLogged();
    }

    private boolean isUpToDate(File file) {
        boolean bl = false;
        FileInformation fileInformation = this.cache.getCachedStatus(file);
        if (fileInformation == null || (fileInformation.getStatus() & 8) != 0 && !fileInformation.isDirectory()) {
            bl = true;
        }
        return bl;
    }

    private boolean isSeen(File file) {
        return alreadySeen.contains(file) || this.notifiedFiles.containsKey(file);
    }

    static {
        LOG = Logger.getLogger(NotificationsManager.class.getName());
        alreadySeen = Collections.synchronizedSet(new WeakSet());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NotificationTask
    extends VCSNotificationDisplayer
    implements Runnable {
        private NotificationTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet<File> hashSet;
            HashSet hashSet2 = NotificationsManager.this.files;
            synchronized (hashSet2) {
                hashSet = new HashSet<File>(NotificationsManager.this.files);
                NotificationsManager.this.files.clear();
            }
            this.removeDirectories(hashSet);
            this.removeSeenFiles(hashSet);
            if (hashSet.size() != 0) {
                this.scanFiles(hashSet);
            }
        }

        protected void setupPane(JTextPane jTextPane, File[] fileArray, File file, String string, String string2) {
            NotificationsManager.this.setupPane(jTextPane, fileArray, this.getFileNames(fileArray), file, string, string2);
        }

        private void removeDirectories(Collection<File> collection) {
            Iterator<File> iterator = collection.iterator();
            while (iterator.hasNext()) {
                File file = iterator.next();
                if (file.isFile()) continue;
                iterator.remove();
            }
        }

        private void removeSeenFiles(Collection<File> collection) {
            Iterator<File> iterator = collection.iterator();
            while (iterator.hasNext()) {
                File file = iterator.next();
                if (!NotificationsManager.this.isSeen(file)) continue;
                iterator.remove();
            }
        }

        private void scanFiles(Collection<File> collection) {
            HashMap<SVNUrl, HashSet<File>> hashMap = this.sortByRepository(collection);
            for (Map.Entry<SVNUrl, HashSet<File>> entry : hashMap.entrySet()) {
                HashMap<Long, Notification> hashMap2;
                SVNUrl sVNUrl;
                block6: {
                    sVNUrl = entry.getKey();
                    hashMap2 = new HashMap<Long, Notification>();
                    try {
                        ISVNStatus[] iSVNStatusArray;
                        SvnClient svnClient = Subversion.getInstance().getClient(sVNUrl);
                        if (svnClient == null) break block6;
                        HashSet<File> hashSet = entry.getValue();
                        for (ISVNStatus iSVNStatus : iSVNStatusArray = svnClient.getStatus(hashSet.toArray(new File[hashSet.size()]))) {
                            Long l;
                            if (SVNStatusKind.UNVERSIONED.equals((Object)iSVNStatus.getTextStatus()) || SVNStatusKind.IGNORED.equals((Object)iSVNStatus.getTextStatus())) continue;
                            File file = iSVNStatus.getFile();
                            SVNRevision.Number number = iSVNStatus.getRevision();
                            ISVNInfo iSVNInfo = null;
                            boolean bl = false;
                            try {
                                iSVNInfo = svnClient.getInfo(iSVNStatus.getUrl(), SVNRevision.HEAD, (SVNRevision)number);
                            }
                            catch (SVNClientException sVNClientException) {
                                LOG.log(Level.FINE, null, sVNClientException);
                                bl = SvnClientExceptionHandler.isFileNotFoundInRevision(sVNClientException.getMessage());
                            }
                            if (iSVNInfo == null && !bl) continue;
                            Long l2 = l = bl ? null : Long.valueOf(iSVNInfo.getLastChangedRevision().getNumber());
                            if (!this.isModifiedInRepository(number.getNumber(), l)) continue;
                            this.addToMap(hashMap2, file, l);
                            NotificationsManager.this.cache.refresh(file, iSVNStatus);
                        }
                        alreadySeen.addAll(hashSet);
                    }
                    catch (SVNClientException sVNClientException) {
                        LOG.log(Level.FINE, null, sVNClientException);
                    }
                }
                this.notifyChanges(hashMap2, sVNUrl);
            }
        }

        private boolean isModifiedInRepository(long l, Long l2) {
            return l2 == null || l < l2;
        }

        private void addToMap(HashMap<Long, Notification> hashMap, File file, Long l) {
            Notification notification = hashMap.get(l);
            if (notification == null) {
                notification = new Notification(l);
                hashMap.put(l, notification);
            }
            notification.addFile(file);
        }

        private HashMap<SVNUrl, HashSet<File>> sortByRepository(Collection<File> collection) {
            HashMap<SVNUrl, HashSet<File>> hashMap = new HashMap<SVNUrl, HashSet<File>>();
            for (File file : collection) {
                SVNUrl sVNUrl = this.getRepositoryRoot(file);
                if (sVNUrl == null) continue;
                HashSet<File> hashSet = hashMap.get(sVNUrl);
                if (hashSet == null) {
                    hashSet = new HashSet();
                    hashMap.put(sVNUrl, hashSet);
                }
                hashSet.add(file);
            }
            return hashMap;
        }

        private void notifyChanges(HashMap<Long, Notification> hashMap, SVNUrl sVNUrl) {
            for (Map.Entry<Long, Notification> entry : hashMap.entrySet()) {
                Notification notification = entry.getValue();
                File[] fileArray = notification.getFiles();
                Long l = notification.getRevision();
                this.notifyFileChange(fileArray, fileArray[0].getParentFile(), sVNUrl.toString(), l == null ? null : l.toString());
            }
        }

        private SVNUrl getRepositoryRoot(File file) {
            SVNUrl sVNUrl = null;
            SVNUrl sVNUrl2 = this.getRepositoryUrl(file);
            if (sVNUrl2 != null && NotificationsManager.this.supp.isKenai(sVNUrl2.toString())) {
                sVNUrl = sVNUrl2;
            }
            return sVNUrl;
        }

        private SVNUrl getRepositoryUrl(File file) {
            SVNUrl sVNUrl = null;
            try {
                sVNUrl = SvnUtils.getRepositoryRootUrl(file);
            }
            catch (SVNClientException sVNClientException) {
                LOG.log(Level.FINE, "getRepositoryUrl: No repository root url found for managed file : [" + file + "]", sVNClientException);
                try {
                    sVNUrl = SvnUtils.getRepositoryUrl(file);
                }
                catch (SVNClientException sVNClientException2) {
                    LOG.log(Level.FINE, "getRepositoryUrl: No repository url found for managed file : [" + file + "]", sVNClientException2);
                }
            }
            return sVNUrl;
        }

        private class Notification {
            private final Set<File> files = new HashSet<File>();
            private final Long revision;

            Notification(Long l) {
                this.revision = l;
            }

            void addFile(File file) {
                this.files.add(file);
            }

            File[] getFiles() {
                return this.files.toArray(new File[this.files.size()]);
            }

            Long getRevision() {
                return this.revision;
            }
        }
    }
}

