/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.parser;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.netbeans.modules.subversion.util.SvnUtils;

public class SvnWcUtils {
    private static final String ENTRIES = "entries";
    private static final String PROPS = "props";
    private static final String PROPS_BASE = "prop-base";

    public static File getSvnFile(File file, String string) {
        File file2 = new File(file, SvnUtils.SVN_ADMIN_DIR + "/" + string);
        if (file2.canRead()) {
            return file2;
        }
        return null;
    }

    public static File getPropertiesFile(File file, boolean bl) {
        if (file.isFile()) {
            if (bl) {
                return SvnWcUtils.getSvnFile(file.getParentFile(), "prop-base/" + file.getName() + SvnWcUtils.getPropFileNameSuffix(bl));
            }
            return SvnWcUtils.getSvnFile(file.getParentFile(), "props/" + file.getName() + SvnWcUtils.getPropFileNameSuffix(bl));
        }
        return SvnWcUtils.getSvnFile(file, bl ? "/dir-prop-base" : "/dir-props");
    }

    private static String getPropFileNameSuffix(boolean bl) {
        if (bl) {
            return ".svn-base";
        }
        return ".svn-work";
    }

    public static File getTextBaseFile(File file) throws IOException {
        return SvnWcUtils.getSvnFile(file.getParentFile(), "text-base/" + file.getName() + ".svn-base");
    }

    public static Date parseSvnDate(String string) throws ParseException {
        Date date = null;
        if (string != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            int n = string.lastIndexOf(".");
            if (n > 0) {
                n = n + 4 > string.length() ? string.length() : n + 4;
                string = string.substring(0, n) + "Z";
            }
            date = simpleDateFormat.parse(string);
        }
        return date;
    }

    static File getEntriesFile(File file) throws IOException {
        return SvnWcUtils.getSvnFile(!file.isDirectory() ? file.getParentFile() : file, ENTRIES);
    }
}

