/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.subversion.client.cli.Parser;
import org.netbeans.modules.subversion.client.cli.SvnCommand;

public class CommitCommand
extends SvnCommand {
    private final boolean keepLocks;
    private final boolean recursive;
    private final String message;
    private File[] files;
    private long revision = -1L;

    public CommitCommand(File[] fileArray, boolean bl, boolean bl2, String string) {
        this.keepLocks = bl;
        this.recursive = bl2;
        this.message = string;
        this.files = fileArray;
    }

    protected int getCommand() {
        return 3;
    }

    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("commit");
        if (this.keepLocks) {
            arguments.add("--no-unlock");
        }
        if (!this.recursive) {
            arguments.add("-N");
        }
        arguments.addMessage(this.message);
        arguments.addFileArguments(this.files);
        this.setCommandWorkingDirectory(this.files);
    }

    public long getRevision() {
        return this.revision;
    }

    protected void notify(Parser.Line line) {
        if (line.getRevision() != -1L) {
            this.revision = line.getRevision();
        }
    }
}

