/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.security.InvalidKeyException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLKeyException;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientDescriptor;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.config.SvnConfigFiles;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.IndexingBridge;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.Cancellable;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnClientInvocationHandler
implements InvocationHandler {
    private static final Logger LOG = Logger.getLogger(SvnClientInvocationHandler.class.getName());
    protected static final String GET_SINGLE_STATUS = "getSingleStatus";
    protected static final String GET_STATUS = "getStatus";
    protected static final String GET_INFO_FROM_WORKING_COPY = "getInfoFromWorkingCopy";
    protected static final String CANCEL_OPERATION = "cancel";
    private static final Object semaphor = new Object();
    private final ISVNClientAdapter adapter;
    private final SvnClientDescriptor desc;
    private Cancellable cancellable;
    private SvnProgressSupport support;
    private final int handledExceptions;
    private static boolean metricsAlreadyLogged = false;

    public SvnClientInvocationHandler(ISVNClientAdapter iSVNClientAdapter, SvnClientDescriptor svnClientDescriptor, int n) {
        assert (iSVNClientAdapter != null);
        assert (svnClientDescriptor != null);
        this.adapter = iSVNClientAdapter;
        this.desc = svnClientDescriptor;
        this.handledExceptions = n;
    }

    public SvnClientInvocationHandler(ISVNClientAdapter iSVNClientAdapter, SvnClientDescriptor svnClientDescriptor, SvnProgressSupport svnProgressSupport, int n) {
        assert (iSVNClientAdapter != null);
        assert (svnClientDescriptor != null);
        this.adapter = iSVNClientAdapter;
        this.desc = svnClientDescriptor;
        this.support = svnProgressSupport;
        this.handledExceptions = n;
        this.cancellable = new Cancellable(){

            public boolean cancel() {
                try {
                    SvnClientInvocationHandler.this.adapter.cancelOperation();
                }
                catch (SVNClientException sVNClientException) {
                    Subversion.LOG.log(Level.SEVERE, null, sVNClientException);
                    return false;
                }
                return true;
            }
        };
    }

    private static String print(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return "no parameters";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objectArray) {
            stringBuilder.append("\n  ");
            if (object == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(object.toString());
                stringBuilder.append(" : ");
                stringBuilder.append(object.getClass().getName());
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public Object invoke(Object object, final Method method, final Object[] objectArray) throws Throwable {
        List<File> list;
        boolean bl = this.isFSWrittingCommand(method);
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("~~~ SVN: invoking '" + method.getName() + "' with " + SvnClientInvocationHandler.print(objectArray));
            }
            Callable<Object> callable = new Callable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object call() throws Exception {
                    if (SvnClientInvocationHandler.this.parallelizable(method, objectArray)) {
                        return SvnClientInvocationHandler.this.invokeMethod(method, objectArray);
                    }
                    Object object = semaphor;
                    synchronized (object) {
                        return SvnClientInvocationHandler.this.invokeMethod(method, objectArray);
                    }
                }
            };
            if (bl) {
                Object v = callable.call();
                return v;
            }
            list = this.getFileParameters(objectArray);
            if (list.size() > 0) {
                Object object2 = IndexingBridge.getInstance().runWithoutIndexing((Callable)callable, list.toArray(new File[list.size()]));
                return object2;
            }
            Object v = callable.call();
            return v;
        }
        catch (Exception exception) {
            block26: {
                if (!this.handleException((SvnClient)object, exception)) break block26;
                list = this.invoke(object, method, objectArray);
                return list;
            }
            try {
                throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SVNClientException) {
                    throw throwable;
                }
                throw invocationTargetException;
            }
            catch (SSLKeyException sSLKeyException) {
                if (sSLKeyException.getCause() instanceof InvalidKeyException) {
                    InvalidKeyException invalidKeyException = (InvalidKeyException)sSLKeyException.getCause();
                    if (invalidKeyException.getMessage().toLowerCase().equals("illegal key size or default parameters")) {
                        SvnClientExceptionHandler.handleInvalidKeyException(invalidKeyException);
                    }
                    Object var8_17 = null;
                    return var8_17;
                }
                throw sSLKeyException;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (throwable instanceof InterruptedException) {
                    throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
                }
                if (throwable instanceof SVNClientException && (throwable2 = throwable.getCause()) instanceof IOException && (throwable2 = throwable2.getCause()) instanceof InterruptedException) {
                    throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
                }
                throwable2 = throwable.getCause();
                if (throwable2 != null) {
                    String string = throwable2.getMessage();
                    if (throwable2 instanceof InterruptedException || string != null && SvnClientExceptionHandler.isOperationCancelled(string)) {
                        throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
                    }
                }
                if (this.support != null && this.support.isCanceled()) {
                    Subversion.LOG.log(Level.INFO, null, throwable);
                    throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
                }
                throw throwable;
            }
        }
        finally {
            if (bl) {
                Subversion.getInstance().getRefreshHandler().refresh();
            }
        }
    }

    private List<File> getFileParameters(Object[] objectArray) {
        LinkedList<File> linkedList = new LinkedList<File>();
        if (objectArray != null && objectArray.length > 0) {
            for (Object object : objectArray) {
                File[] fileArray;
                if (object instanceof File) {
                    linkedList.add((File)object);
                    continue;
                }
                if (!(object instanceof File[])) continue;
                for (File file : fileArray = (File[])object) {
                    linkedList.add(file);
                }
            }
        }
        return linkedList;
    }

    private boolean isFSWrittingCommand(Method method) {
        return !method.getName().equals("update") && !method.getName().equals("revert") && !method.getName().equals("switchToUrl") && !method.getName().equals("commit") && !method.getName().equals("commitAcrossWC") && !method.getName().equals("remove") && !method.getName().equals("mkdir") && !method.getName().equals("checkout") && !method.getName().equals("copy") && !method.getName().equals("move") && !method.getName().equals("merge");
    }

    private void logClientInvoked() {
        if (metricsAlreadyLogged) {
            return;
        }
        try {
            SvnClientFactory.checkClientAvailable();
        }
        catch (SVNClientException sVNClientException) {
            return;
        }
        String string = null;
        if (SvnClientFactory.isCLI()) {
            string = "CLI";
        } else if (SvnClientFactory.isJavaHl()) {
            string = "JAVAHL";
        } else if (SvnClientFactory.isSvnKit()) {
            string = "SVNKIT";
        } else {
            Subversion.LOG.warning("Unknown client type!");
        }
        if (string != null) {
            Utils.logVCSClientEvent((String)"SVN", (String)string);
        }
        metricsAlreadyLogged = true;
    }

    private boolean parallelizable(Method method, Object[] objectArray) {
        return this.isLocalReadCommand(method, objectArray) || this.isCancelCommand(method, objectArray);
    }

    protected boolean isLocalReadCommand(Method method, Object[] objectArray) {
        String string = method.getName();
        return string.equals(GET_SINGLE_STATUS) || string.equals(GET_INFO_FROM_WORKING_COPY) || method.getName().equals(GET_STATUS) && method.getParameterTypes().length == 3;
    }

    protected boolean isCancelCommand(Method method, Object[] objectArray) {
        String string = method.getName();
        return Cancellable.class.isAssignableFrom(method.getDeclaringClass()) && string.equals(CANCEL_OPERATION);
    }

    protected Object invokeMethod(Method method, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.handle(method, objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object handle(Method method, Object[] objectArray) throws SecurityException, InvocationTargetException, IllegalAccessException, NoSuchMethodException, IllegalArgumentException {
        Class<?>[] classArray = method.getParameterTypes();
        Class<?> clazz = method.getDeclaringClass();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object == null || !(object instanceof SVNUrl)) continue;
                try {
                    objectArray[i] = SvnUtils.decodeAndEncodeUrl((SVNUrl)object);
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    Subversion.LOG.log(Level.INFO, "Url: " + object, malformedURLException);
                }
            }
        }
        if (ISVNClientAdapter.class.isAssignableFrom(clazz)) {
            if (this.support != null) {
                this.support.setCancellableDelegate(this.cancellable);
            }
            if (this.desc != null && this.desc.getSvnUrl() != null) {
                SvnConfigFiles.getInstance().storeSvnServersSettings(this.desc.getSvnUrl());
            }
        } else {
            if (Cancellable.class.isAssignableFrom(clazz)) {
                return this.cancellable.getClass().getMethod(method.getName(), classArray).invoke((Object)this.cancellable, objectArray);
            }
            if (!SvnClientDescriptor.class.isAssignableFrom(clazz)) return this.adapter.getClass().getMethod(method.getName(), classArray).invoke((Object)this.adapter, objectArray);
            if (this.desc == null) throw new NoSuchMethodException(method.getName());
            return this.desc.getClass().getMethod(method.getName(), classArray).invoke((Object)this.desc, objectArray);
        }
        this.logClientInvoked();
        Object object = this.adapter.getClass().getMethod(method.getName(), classArray).invoke((Object)this.adapter, objectArray);
        if (this.support == null) return object;
        this.support.setCancellableDelegate(null);
        return object;
    }

    private boolean handleException(SvnClient svnClient, Throwable throwable) throws Throwable {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getCause();
        }
        if (!(throwable instanceof SVNClientException)) {
            throw throwable;
        }
        SvnClientExceptionHandler svnClientExceptionHandler = new SvnClientExceptionHandler((SVNClientException)throwable, this.adapter, svnClient, this.desc, this.handledExceptions, this.isCommandLine());
        return svnClientExceptionHandler.handleException();
    }

    protected boolean isCommandLine() {
        return false;
    }
}

