/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.awt.Dialog;
import java.net.PasswordAuthentication;
import javax.swing.JButton;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.AcceptCertificatePanel;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.kenai.SvnKenaiSupport;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SvnClientCallback
implements ISVNPromptUserPassword {
    private final SVNUrl url;
    private final int handledExceptions;
    private String username = null;
    private String password = null;
    private final boolean prompt;

    public SvnClientCallback(SVNUrl sVNUrl, int n) {
        this.url = sVNUrl;
        this.handledExceptions = n;
        this.prompt = (4 & n) == 4;
    }

    public boolean askYesNo(String string, String string2, boolean bl) {
        return false;
    }

    public String getUsername() {
        this.getAuthData();
        return this.username;
    }

    public String getPassword() {
        this.getAuthData();
        return this.password;
    }

    public int askTrustSSLServer(String string, boolean bl) {
        if ((8 & this.handledExceptions) != 8) {
            return -1;
        }
        AcceptCertificatePanel acceptCertificatePanel = new AcceptCertificatePanel();
        acceptCertificatePanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Error_CertFailed"));
        acceptCertificatePanel.certificatePane.setText(string);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)acceptCertificatePanel, NbBundle.getMessage(SvnClientCallback.class, (String)"CTL_Error_CertFailed"));
        JButton jButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_AcceptPermanently"));
        JButton jButton2 = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_AcceptTemp"));
        JButton jButton3 = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_Reject"));
        dialogDescriptor.setOptions(new Object[]{jButton, jButton2, jButton3});
        dialogDescriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.subversion.serverCertificateVerification"));
        this.showDialog(dialogDescriptor);
        if (dialogDescriptor.getValue() == jButton) {
            return 2;
        }
        if (dialogDescriptor.getValue() == jButton2) {
            return 1;
        }
        return 0;
    }

    public boolean prompt(String string, String string2, boolean bl) {
        return true;
    }

    public String askQuestion(String string, String string2, boolean bl, boolean bl2) {
        return null;
    }

    public boolean userAllowedSave() {
        return false;
    }

    public boolean promptSSH(String string, String string2, int n, boolean bl) {
        return false;
    }

    public String getSSHPrivateKeyPath() {
        return null;
    }

    public String getSSHPrivateKeyPassphrase() {
        return null;
    }

    public int getSSHPort() {
        return -1;
    }

    public boolean promptSSL(String string, boolean bl) {
        return false;
    }

    public String getSSLClientCertPassword() {
        return null;
    }

    public String getSSLClientCertPath() {
        return null;
    }

    private void getKenaiAuthData(SvnKenaiSupport svnKenaiSupport) {
        String string = this.url.toString();
        PasswordAuthentication passwordAuthentication = svnKenaiSupport.getPasswordAuthentication(true);
        if (passwordAuthentication == null) {
            throw new RuntimeException(new InterruptedException(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_ActionCanceledByUser")));
        }
        String string2 = passwordAuthentication.getUserName();
        char[] cArray = passwordAuthentication.getPassword();
        this.username = string2 != null ? string2 : "";
        this.password = cArray != null ? new String(cArray) : "";
    }

    private void showDialog(DialogDescriptor dialogDescriptor) {
        dialogDescriptor.setModal(true);
        dialogDescriptor.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    private void getAuthData() {
        SvnKenaiSupport svnKenaiSupport = SvnKenaiSupport.getInstance();
        if (svnKenaiSupport != null && svnKenaiSupport.isKenai(this.url.toString())) {
            this.getKenaiAuthData(svnKenaiSupport);
        } else {
            RepositoryConnection repositoryConnection = SvnModuleConfig.getDefault().getRepositoryConnection(this.url.toString());
            if (repositoryConnection != null) {
                this.username = repositoryConnection.getUsername();
                this.password = repositoryConnection.getPassword();
            }
        }
    }

    public boolean promptUser(String string, String string2, boolean bl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

