/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.collector.stdout.spi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.AttachableTarget;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.collector.stdout.CLIODCConfiguration;
import org.netbeans.modules.dlight.collector.stdout.CLIOParser;
import org.netbeans.modules.dlight.collector.stdout.impl.CLIODCConfigurationAccessor;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CLIODataCollector
extends IndicatorDataProvider<CLIODCConfiguration>
implements DataCollector<CLIODCConfiguration>,
DLightTarget.ExecutionEnvVariablesProvider {
    private static final Logger log = DLightLogger.getLogger(CLIODataCollector.class);
    private String command;
    private final Map<String, String> envs;
    private String argsTemplate;
    private DataStorage storage;
    private String displayedName;
    private Future<Integer> collectorTask;
    private CLIOParser parser;
    private List<DataTableMetadata> dataTablesMetadata;
    private ValidationStatus validationStatus = ValidationStatus.initialStatus();
    private List<ValidationListener> validationListeners = Collections.synchronizedList(new ArrayList());

    CLIODataCollector(CLIODCConfiguration cLIODCConfiguration) {
        CLIODCConfigurationAccessor cLIODCConfigurationAccessor = CLIODCConfigurationAccessor.getDefault();
        this.command = cLIODCConfigurationAccessor.getCommand(cLIODCConfiguration);
        this.argsTemplate = cLIODCConfigurationAccessor.getArguments(cLIODCConfiguration);
        this.parser = cLIODCConfigurationAccessor.getParser(cLIODCConfiguration);
        this.dataTablesMetadata = cLIODCConfigurationAccessor.getDataTablesMetadata(cLIODCConfiguration);
        this.envs = cLIODCConfigurationAccessor.getDLightTargetExecutionEnv(cLIODCConfiguration);
        this.displayedName = cLIODCConfigurationAccessor.getName(cLIODCConfiguration);
        if (this.displayedName == null) {
            int n = this.command.lastIndexOf(File.separator);
            this.displayedName = n == -1 || n == this.command.length() - 1 ? this.command : this.command.substring(n, this.command.length());
        }
    }

    public String getName() {
        return this.displayedName;
    }

    public Collection<DataStorageType> getRequiredDataStorageTypes() {
        DataStorageTypeFactory dataStorageTypeFactory = DataStorageTypeFactory.getInstance();
        return Arrays.asList(dataStorageTypeFactory.getDataStorageType("db:sql"));
    }

    public void init(Map<DataStorageType, DataStorage> map, DLightTarget dLightTarget) {
        DataStorageTypeFactory dataStorageTypeFactory = DataStorageTypeFactory.getInstance();
        this.storage = map.get(dataStorageTypeFactory.getDataStorageType("db:sql"));
        log.fine("Do INIT for " + this.storage.toString());
    }

    protected void processLine(String string) {
        DataRow dataRow = this.parser.process(string);
        if (dataRow != null) {
            if (this.dataTablesMetadata != null && !this.dataTablesMetadata.isEmpty() && this.storage != null) {
                this.storage.addData(this.dataTablesMetadata.iterator().next().getName(), Arrays.asList(dataRow));
            }
            this.notifyIndicators(Arrays.asList(dataRow));
        }
    }

    private void targetStarted(DLightTarget dLightTarget) {
        AttachableTarget attachableTarget;
        log.fine("Starting CLIODataCollector: " + this.command);
        this.resetIndicators();
        String string = this.command + " ";
        if (dLightTarget instanceof AttachableTarget) {
            attachableTarget = (AttachableTarget)dLightTarget;
            string = string + this.argsTemplate.replaceAll("@PID", "" + attachableTarget.getPID());
        } else {
            string = string + this.argsTemplate;
        }
        log.fine("Starting CLIODataCollector cmd: " + string);
        attachableTarget = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)dLightTarget.getExecEnv());
        attachableTarget.setCommandLine(string);
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().inputOutput(InputOutput.NULL).outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new CLIOInputProcessorFactory());
        ExecutionService executionService = ExecutionService.newService((Callable)attachableTarget, (ExecutionDescriptor)executionDescriptor, (String)("CLIODataCollector " + string));
        this.collectorTask = executionService.run();
    }

    private void targetFinished(DLightTarget dLightTarget) {
        if (this.collectorTask != null && !this.collectorTask.isDone()) {
            log.fine("Stopping CLIODataCollector: " + this.collectorTask.toString());
            this.collectorTask.cancel(true);
            this.collectorTask = null;
        }
    }

    public List<DataTableMetadata> getDataTablesMetadata() {
        return this.dataTablesMetadata;
    }

    public boolean isAttachable() {
        return true;
    }

    public String getCmd() {
        return this.command;
    }

    public String[] getArgs() {
        return null;
    }

    public void addValidationListener(ValidationListener validationListener) {
        if (!this.validationListeners.contains(validationListener)) {
            this.validationListeners.add(validationListener);
        }
    }

    public void removeValidationListener(ValidationListener validationListener) {
        this.validationListeners.remove(validationListener);
    }

    protected void notifyStatusChanged(ValidationStatus validationStatus, ValidationStatus validationStatus2) {
        if (validationStatus.equals((Object)validationStatus2)) {
            return;
        }
        for (ValidationListener validationListener : this.validationListeners) {
            validationListener.validationStateChanged((Validateable)this, validationStatus, validationStatus2);
        }
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(CLIODataCollector.class, (String)string, (Object[])stringArray);
    }

    public ValidationStatus validate(DLightTarget dLightTarget) {
        if (this.validationStatus.isValid()) {
            return this.validationStatus;
        }
        ValidationStatus validationStatus = this.validationStatus;
        ValidationStatus validationStatus2 = this.doValidation(dLightTarget);
        this.notifyStatusChanged(validationStatus, validationStatus2);
        this.validationStatus = validationStatus2;
        return validationStatus2;
    }

    public void invalidate() {
        this.validationStatus = ValidationStatus.initialStatus();
    }

    private ValidationStatus doValidation(DLightTarget dLightTarget) {
        DLightLogger.assertNonUiThread();
        ValidationStatus validationStatus = null;
        boolean bl = false;
        boolean bl2 = true;
        ExecutionEnvironment executionEnvironment = dLightTarget.getExecEnv();
        String string = "";
        try {
            bl = HostInfoUtils.fileExists((ExecutionEnvironment)executionEnvironment, (String)this.command);
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
            bl2 = false;
        }
        if (bl2) {
            validationStatus = bl ? ValidationStatus.validStatus() : ValidationStatus.invalidStatus((String)CLIODataCollector.loc("ValidationStatus.CommandNotFound", this.command));
        } else {
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            Runnable runnable = new Runnable(){

                public void run() {
                    DLightManager.getDefault().revalidateSessions();
                }
            };
            AsynchronousAction asynchronousAction = connectionManager.getConnectToAction(executionEnvironment, runnable);
            validationStatus = ValidationStatus.unknownStatus((String)CLIODataCollector.loc("ValidationStatus.ErrorWhileValidation", string), (AsynchronousAction)asynchronousAction);
        }
        return validationStatus;
    }

    public ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    public void targetStateChanged(DLightTargetChangeEvent dLightTargetChangeEvent) {
        switch (dLightTargetChangeEvent.state) {
            case RUNNING: {
                this.targetStarted(dLightTargetChangeEvent.target);
                break;
            }
            case FAILED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                break;
            }
            case TERMINATED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                break;
            }
            case DONE: {
                this.targetFinished(dLightTargetChangeEvent.target);
                break;
            }
            case STOPPED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
        }
    }

    public void setupEnvironment(DLightTarget dLightTarget, MacroMap macroMap) {
        macroMap.putAll(this.envs);
    }

    public void dataFiltersChanged(List<DataFilter> list, boolean bl) {
    }

    private class CLIOInputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory {
        private CLIOInputProcessorFactory() {
        }

        public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
            return InputProcessors.bridge((LineProcessor)new LineProcessor(){

                public void processLine(String string) {
                    CLIODataCollector.this.processLine(string);
                }

                public void reset() {
                }

                public void close() {
                }
            });
        }
    }
}

