/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Event;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.DLightSessionListener;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class DLightSessionsViewPanel
extends JPanel
implements DLightSessionListener,
ValidationListener {
    private static final String stateColumnID = "State";
    private DLightSession currentSession = null;
    private Models.CompoundModel model;
    private Vector<ModelListener> listeners = new Vector();
    private static final Comparator<DLightTool> toolsComparator = new Comparator<DLightTool>(){

        @Override
        public int compare(DLightTool dLightTool, DLightTool dLightTool2) {
            return dLightTool.getName().compareTo(dLightTool2.getName());
        }
    };
    private boolean isEmpty = true;
    private JComponent treeTableView = null;

    public void activeSessionChanged(DLightSession dLightSession, DLightSession dLightSession2) {
        if (dLightSession2 == null) {
            this.setEmptyContent();
        } else {
            if (dLightSession2 == this.currentSession) {
                return;
            }
            this.updateContent(dLightSession2);
        }
    }

    public void sessionStateChanged(DLightSession dLightSession, DLightSession.SessionState sessionState, DLightSession.SessionState sessionState2) {
        this.updateContent(dLightSession);
    }

    public void sessionAdded(DLightSession dLightSession) {
    }

    public void sessionRemoved(DLightSession dLightSession) {
    }

    void startup() {
        DLightManager.getDefault().addDLightSessionListener((DLightSessionListener)this);
        this.model = this.initModel();
        this.treeTableView = Models.createView((Models.CompoundModel)this.model);
        this.setTreeViewContent();
    }

    private Models.CompoundModel initModel() {
        List<ColumnModelImpl> list = Arrays.asList(new ColumnModelImpl(stateColumnID, DLightSessionsViewPanel.loc("DLightSessionsViewPanel.stateColumn.name"), String.class));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new TreeModelImpl());
        arrayList.add(new TableModelImpl());
        arrayList.add(new NodeModelImpl());
        arrayList.add(new NodeActionsProviderImpl());
        arrayList.addAll(list);
        return Models.createCompoundModel(arrayList);
    }

    private void setEmptyContent() {
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        JLabel jLabel = new JLabel(DLightSessionsViewPanel.loc("DLightSessionsViewPanel.emptyContent.text"));
        jLabel.setAlignmentX(0.5f);
        this.add(jLabel);
        this.revalidate();
        this.repaint();
        this.isEmpty = true;
    }

    private void setTreeViewContent() {
        UIThread.invoke((Runnable)new Runnable(){

            public void run() {
                DLightSessionsViewPanel.this.removeAll();
                DLightSessionsViewPanel.this.setLayout(new BorderLayout());
                if (DLightSessionsViewPanel.this.treeTableView != null) {
                    DLightSessionsViewPanel.this.add((Component)DLightSessionsViewPanel.this.treeTableView, "Center");
                    DLightSessionsViewPanel.this.isEmpty = false;
                }
                DLightSessionsViewPanel.this.revalidate();
                DLightSessionsViewPanel.this.repaint();
            }
        });
    }

    private static String loc(String string) {
        return NbBundle.getMessage(DLightSessionsViewPanel.class, (String)string);
    }

    protected void updateContent(Object object) {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.TreeChanged(object == null ? this.model.getRoot() : object));
        }
        if (this.isEmpty) {
            this.setTreeViewContent();
        }
    }

    public void validationStateChanged(Validateable validateable, ValidationStatus validationStatus, ValidationStatus validationStatus2) {
        this.updateContent(validateable);
    }

    static class ColumnModelImpl
    extends ColumnModel {
        private String id;
        private String displayName;
        private Class type;
        private boolean isVisible = true;

        public ColumnModelImpl(String string, String string2, Class clazz) {
            this.id = string;
            this.displayName = string2;
            this.type = clazz;
        }

        public String getID() {
            return this.id;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Class getType() {
            return this.type;
        }

        public void setVisible(boolean bl) {
            this.isVisible = bl;
        }

        public boolean isVisible() {
            return this.isVisible;
        }
    }

    private static class NodeActionsProviderImpl
    implements NodeActionsProvider {
        private NodeActionsProviderImpl() {
        }

        public void performDefaultAction(Object object) throws UnknownTypeException {
            if (!(object instanceof Event)) {
                throw new UnknownTypeException(object);
            }
        }

        public Action[] getActions(Object object) throws UnknownTypeException {
            if (object instanceof DLightSession) {
                final DLightSession dLightSession = (DLightSession)object;
                AbstractAction abstractAction = new AbstractAction(DLightSessionsViewPanel.loc("DLightSessionsViewPanel.actions.MakeCurrent.name")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DLightManager.getDefault().setActiveSession(dLightSession);
                    }
                };
                abstractAction.setEnabled(!dLightSession.isActive());
                AbstractAction abstractAction2 = new AbstractAction(DLightSessionsViewPanel.loc("DLightSessionsViewPanel.actions.CloseSession.name")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DLightManager.getDefault().closeSession(dLightSession);
                    }
                };
                return new Action[]{abstractAction, abstractAction2};
            }
            ValidationStatus validationStatus = null;
            if (object instanceof Validateable) {
                validationStatus = ((Validateable)object).getValidationStatus();
            }
            if (object instanceof DLightTool) {
                return validationStatus == null ? new Action[]{} : validationStatus.getRequiredActions().toArray(new Action[0]);
            }
            return new Action[0];
        }
    }

    class NodeModelImpl
    implements ExtendedNodeModel {
        NodeModelImpl() {
        }

        public boolean canRename(Object object) throws UnknownTypeException {
            return false;
        }

        public boolean canCopy(Object object) throws UnknownTypeException {
            return false;
        }

        public boolean canCut(Object object) throws UnknownTypeException {
            return false;
        }

        public Transferable clipboardCopy(Object object) throws IOException, UnknownTypeException {
            return null;
        }

        public Transferable clipboardCut(Object object) throws IOException, UnknownTypeException {
            return null;
        }

        public PasteType[] getPasteTypes(Object object, Transferable transferable) throws UnknownTypeException {
            return null;
        }

        public void setName(Object object, String string) throws UnknownTypeException {
        }

        public String getIconBaseWithExtension(Object object) throws UnknownTypeException {
            return null;
        }

        public String getDisplayName(Object object) throws UnknownTypeException {
            if (object == "Root") {
                return DLightSessionsViewPanel.loc("DLightSessionsViewPanel.NodeModelImpl.rootNode.name");
            }
            if (object instanceof DLightSession) {
                DLightSession dLightSession = (DLightSession)object;
                if (DLightManager.getDefault().getActiveSession() == dLightSession) {
                    return "<html><b>" + dLightSession.getDescription() + "</b></html>";
                }
                return dLightSession.getDescription();
            }
            if (object instanceof DLightTool) {
                DLightTool dLightTool = (DLightTool)object;
                ValidationStatus validationStatus = dLightTool.getValidationStatus();
                if (validationStatus.isValid()) {
                    return dLightTool.getName();
                }
                if (validationStatus.isInvalid()) {
                    return "<html><font color=\"#FF0000\">" + dLightTool.getName() + "</font></html>";
                }
                return "<html><b>?</b> " + dLightTool.getName() + "</html>";
            }
            throw new UnknownTypeException(object);
        }

        public String getIconBase(Object object) throws UnknownTypeException {
            return null;
        }

        public String getShortDescription(Object object) throws UnknownTypeException {
            if (object == "Root") {
                return DLightSessionsViewPanel.loc("DLightSessionsViewPanel.NodeModelImpl.rootNode.tooltip");
            }
            if (object instanceof DLightSession) {
                DLightSession dLightSession = (DLightSession)object;
                return dLightSession.getDescription();
            }
            if (object instanceof DLightTool) {
                DLightTool dLightTool = (DLightTool)object;
                return dLightTool.toString();
            }
            throw new UnknownTypeException(object);
        }

        public void addModelListener(ModelListener modelListener) {
            if (!DLightSessionsViewPanel.this.listeners.contains(modelListener)) {
                DLightSessionsViewPanel.this.listeners.add(modelListener);
            }
        }

        public void removeModelListener(ModelListener modelListener) {
            DLightSessionsViewPanel.this.listeners.remove(modelListener);
        }
    }

    class TableModelImpl
    implements TableModel {
        TableModelImpl() {
        }

        public Object getValueAt(Object object, String string) throws UnknownTypeException {
            if (string == null) {
                return null;
            }
            if (object instanceof DLightSession) {
                DLightSession dLightSession = (DLightSession)object;
                if (string.equals(DLightSessionsViewPanel.stateColumnID)) {
                    return dLightSession.getState().toString();
                }
                return null;
            }
            if (object instanceof DLightTool) {
                DLightTool dLightTool = (DLightTool)object;
                ValidationStatus validationStatus = dLightTool.getValidationStatus();
                if (string.equals(DLightSessionsViewPanel.stateColumnID)) {
                    if (validationStatus.isValid()) {
                        return "OK";
                    }
                    if (validationStatus.isInvalid()) {
                        return "Tool cannot be used. " + validationStatus.getReason();
                    }
                    return validationStatus.getReason();
                }
                return null;
            }
            if (object instanceof JToolTip && string.equals(DLightSessionsViewPanel.stateColumnID)) {
                return "ToolState";
            }
            throw new UnknownTypeException(object);
        }

        public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
            return true;
        }

        public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        }

        public void addModelListener(ModelListener modelListener) {
            if (!DLightSessionsViewPanel.this.listeners.contains(modelListener)) {
                DLightSessionsViewPanel.this.listeners.add(modelListener);
            }
        }

        public void removeModelListener(ModelListener modelListener) {
            DLightSessionsViewPanel.this.listeners.remove(modelListener);
        }
    }

    class TreeModelImpl
    implements TreeModel {
        TreeModelImpl() {
        }

        public Object getRoot() {
            return "Root";
        }

        public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
            if (object == "Root") {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(DLightManager.getDefault().getSessionsList());
                return arrayList.toArray();
            }
            if (object instanceof DLightSession) {
                DLightSession dLightSession = (DLightSession)object;
                TreeSet treeSet = new TreeSet(toolsComparator);
                treeSet.addAll(dLightSession.getTools());
                return treeSet.toArray();
            }
            throw new UnknownTypeException(object);
        }

        public boolean isLeaf(Object object) {
            if (object == "Root") {
                return false;
            }
            return !(object instanceof DLightSession);
        }

        public int getChildrenCount(Object object) throws UnknownTypeException {
            if (object == "Root") {
                return DLightManager.getDefault().getSessionsList().size();
            }
            if (object instanceof DLightSession) {
                DLightSession dLightSession = (DLightSession)object;
                return dLightSession.getTools().size();
            }
            return 0;
        }

        public void addModelListener(ModelListener modelListener) {
            if (!DLightSessionsViewPanel.this.listeners.contains(modelListener)) {
                DLightSessionsViewPanel.this.listeners.add(modelListener);
            }
        }

        public void removeModelListener(ModelListener modelListener) {
            DLightSessionsViewPanel.this.listeners.remove(modelListener);
        }
    }
}

