/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.beans.beancontext.BeanContextProxy;
import java.beans.beancontext.BeanContextSupport;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceDataObject;
import org.openide.nodes.BeanChildren;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

final class InstanceNode
extends DataNode
implements Runnable {
    private static final String INSTANCE_ICON_BASE = "org/openide/loaders/instanceObject.gif";
    private static final String XML_EXT = "settings";
    private PropL propertyChangeListener = null;
    private PropertyChangeListener dobjListener;
    private boolean isSheetCreated = false;
    private boolean noBeanInfo = false;

    public InstanceNode(InstanceDataObject instanceDataObject) {
        this(instanceDataObject, Boolean.FALSE.equals(instanceDataObject.getPrimaryFile().getAttribute("beaninfo")));
    }

    private InstanceNode(InstanceDataObject instanceDataObject, boolean bl) {
        super(instanceDataObject, InstanceNode.getChildren(instanceDataObject, bl));
        this.initIconBase();
        this.noBeanInfo = bl;
        if (!bl && !this.getDataObject().getPrimaryFile().hasExt(XML_EXT)) {
            SwingUtilities.invokeLater(this);
        }
        this.dobjListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("cookie")) {
                    if (InstanceNode.this.propertyChangeListener != null) {
                        InstanceNode.this.propertyChangeListener.destroy();
                        InstanceNode.this.propertyChangeListener = null;
                    }
                    if (InstanceNode.this.noBeanInfo || InstanceNode.this.ic() == null) {
                        InstanceNode.this.initIconBase();
                    } else {
                        InstanceNode.this.fireIconChange();
                    }
                    InstanceNode.this.fireNameChange(null, null);
                    InstanceNode.this.fireDisplayNameChange(null, null);
                    InstanceNode.this.fireShortDescriptionChange(null, null);
                    if (InstanceNode.this.isSheetCreated) {
                        InstanceNode.this.setSheet(InstanceNode.this.createSheet());
                    }
                }
            }
        };
        instanceDataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.dobjListener, (Object)instanceDataObject));
    }

    private void initIconBase() {
        InstanceCookie.Of of = this.ic();
        String string = INSTANCE_ICON_BASE;
        if (of == null) {
            string = "org/openide/loaders/instanceBroken.gif";
        }
        this.setIconBaseWithExtension(string);
    }

    private static Children getChildren(DataObject dataObject, boolean bl) {
        if (bl) {
            return Children.LEAF;
        }
        InstanceCookie instanceCookie = dataObject.getCookie(InstanceCookie.class);
        if (instanceCookie == null) {
            return Children.LEAF;
        }
        try {
            Class clazz = instanceCookie.instanceClass();
            if (BeanContext.class.isAssignableFrom(clazz) || BeanContextProxy.class.isAssignableFrom(clazz)) {
                return new InstanceChildren((InstanceDataObject)dataObject);
            }
            return Children.LEAF;
        }
        catch (Exception exception) {
            return Children.LEAF;
        }
    }

    private InstanceDataObject i() {
        return (InstanceDataObject)this.getDataObject();
    }

    private InstanceCookie.Of ic() {
        return this.getDataObject().getCookie(InstanceCookie.Of.class);
    }

    public Image getIcon(int n) {
        if (this.noBeanInfo) {
            return super.getIcon(n);
        }
        Image image = null;
        try {
            DataObject dataObject = this.getDataObject();
            image = dataObject.getPrimaryFile().getFileSystem().getStatus().annotateIcon(image, n, dataObject.files());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        if (image == null) {
            image = this.initIcon(n);
        }
        if (image == null) {
            image = super.getIcon(n);
        }
        return image;
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    private void initPList() {
        try {
            InstanceCookie.Of of = this.ic();
            if (of == null) {
                return;
            }
            BeanInfo beanInfo = Utilities.getBeanInfo((Class)of.instanceClass());
            EventSetDescriptor[] eventSetDescriptorArray = beanInfo.getEventSetDescriptors();
            Method method = null;
            for (int i = 0; eventSetDescriptorArray != null && i < eventSetDescriptorArray.length; ++i) {
                method = eventSetDescriptorArray[i].getAddListenerMethod();
                if (method == null || !method.getName().equals("addPropertyChangeListener")) continue;
                Object object = of.instanceCreate();
                this.propertyChangeListener = new PropL();
                method.invoke(object, WeakListeners.propertyChange((PropertyChangeListener)this.propertyChangeListener, (Object)object));
            }
        }
        catch (Exception exception) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    private Image initIcon(int n) {
        Image image = null;
        try {
            BeanInfo beanInfo;
            Object object;
            InstanceCookie.Of of = this.ic();
            if (of == null) {
                return null;
            }
            Class clazz = of.instanceClass();
            String string = clazz.getName();
            if (string.equals("javax.swing.JSeparator") || string.equals("javax.swing.JToolBar$Separator")) {
                object = Class.forName("javax.swing.JSeparator");
                beanInfo = Utilities.getBeanInfo(object);
            } else {
                beanInfo = Utilities.getBeanInfo((Class)clazz);
            }
            if (beanInfo != null && (image = beanInfo.getIcon(n)) != null) {
                image = InstanceNode.toBufferedImage(image, true);
            }
            if (image == null && Action.class.isAssignableFrom(clazz)) {
                Object object2;
                object = (Action)of.instanceCreate();
                Icon icon = (Icon)object.getValue("SmallIcon");
                image = icon != null ? ImageUtilities.icon2Image((Icon)icon) : ((object2 = object.getValue("iconBase")) instanceof String ? ImageUtilities.loadImage((String)((String)object2), (boolean)true) : ImageUtilities.loadImage((String)"org/openide/loaders/empty.gif", (boolean)true));
            }
        }
        catch (Exception exception) {
            Logger.getLogger(InstanceNode.class.getName()).log(Level.WARNING, null, exception);
        }
        catch (LinkageError linkageError) {
            Logger.getLogger(InstanceNode.class.getName()).log(Level.WARNING, null, linkageError);
        }
        return image;
    }

    public void run() {
        try {
            InstanceCookie.Of of = this.ic();
            if (of == null) {
                return;
            }
            Class clazz = of.instanceClass();
            String string = clazz.getName();
            if (string.equals("javax.swing.JSeparator") || string.equals("javax.swing.JToolBar$Separator")) {
                this.setDisplayName(NbBundle.getMessage(InstanceDataObject.class, (String)"LBL_separator_instance"));
                return;
            }
            if (Action.class.isAssignableFrom(clazz)) {
                Action action = (Action)of.instanceCreate();
                String string2 = (String)action.getValue("Name");
                if (string2 == null) {
                    DataObject.LOG.warning("Please attach following information to the issue <http://www.netbeans.org/issues/show_bug.cgi?id=31227>: action " + string + " does not implement SystemAction.getName() or Action.getValue(NAME) properly. It returns null!");
                    this.setDisplayName(string);
                    return;
                }
                int n = string2.indexOf(38);
                if (n != -1) {
                    string2 = string2.substring(0, n) + string2.substring(n + 1);
                }
                if (string2.endsWith("...")) {
                    string2 = string2.substring(0, string2.length() - 3);
                }
                string2 = string2.trim();
                this.setDisplayName(string2);
                return;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(InstanceNode.class.getName()).log(Level.WARNING, null, exception);
            this.setDisplayName(this.getDataObject().getName());
            return;
        }
    }

    private String getNameForBean() {
        try {
            Method method;
            InstanceCookie.Of of = this.ic();
            if (of == null) {
                return NbBundle.getMessage(InstanceNode.class, (String)"LBL_BrokenSettings");
            }
            Class clazz = of.instanceClass();
            try {
                method = clazz.getMethod("getName", null);
                if (method.getReturnType() != String.class) {
                    throw new NoSuchMethodException();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    method = clazz.getMethod("getDisplayName", null);
                    if (method.getReturnType() != String.class) {
                        throw new NoSuchMethodException();
                    }
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    return null;
                }
            }
            Object object = of.instanceCreate();
            return (String)method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Method getDeclaredSetter() {
        Method method = null;
        try {
            InstanceCookie.Of of = this.ic();
            if (of == null) {
                return null;
            }
            Class clazz = of.instanceClass();
            try {
                method = clazz.getMethod("setName", String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = clazz.getMethod("setDisplayName", String.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    public void setName(String string) {
        if (!this.getDataObject().getPrimaryFile().hasExt(XML_EXT)) {
            super.setName(string);
            return;
        }
        String string2 = this.getNameImpl();
        if (string2 != null && string2.equals(string)) {
            return;
        }
        InstanceCookie.Of of = this.ic();
        if (of == null) {
            super.setName(string);
            return;
        }
        Method method = this.getDeclaredSetter();
        if (method != null) {
            try {
                Object object = of.instanceCreate();
                method.invoke(object, string);
                this.i().scheduleSave();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        super.setName(string);
    }

    public String getDisplayName() {
        String string = (String)this.getDataObject().getPrimaryFile().getAttribute("name");
        if (string == null) {
            try {
                String string2 = "\b";
                FileSystem.Status status = this.getDataObject().getPrimaryFile().getFileSystem().getStatus();
                string = status.annotateName(string2, this.getDataObject().files());
                if (string.indexOf(string2) < 0) {
                    return string;
                }
                string = this.getNameForBean();
                string = string != null ? status.annotateName(string, this.getDataObject().files()) : super.getDisplayName();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        return string;
    }

    private String getNameImpl() {
        String string = this.getNameForBean();
        if (string == null) {
            string = this.getName();
        }
        return string;
    }

    protected Sheet createSheet() {
        Sheet sheet;
        if (this.getDataObject().getPrimaryFile().hasExt("ser") || this.getDataObject().getPrimaryFile().hasExt(XML_EXT)) {
            sheet = new Sheet();
            this.changeSheet(sheet);
        } else {
            sheet = super.createSheet();
            Sheet.Set set = sheet.get("properties");
            InstanceCookie.Of of = this.ic();
            if (of == null) {
                set.put((Node.Property)new PropertySupport.ReadOnly<String>("className", String.class, NbBundle.getMessage(InstanceDataObject.class, (String)"PROP_instance_class"), NbBundle.getMessage(InstanceDataObject.class, (String)"HINT_instance_class"), (InstanceCookie)of){
                    final /* synthetic */ InstanceCookie val$ic;
                    {
                        this.val$ic = instanceCookie;
                        super(string, clazz, string2, string3);
                    }

                    public String getValue() {
                        return this.val$ic.instanceName();
                    }
                });
            }
        }
        this.isSheetCreated = true;
        return sheet;
    }

    private void changeSheet(Sheet sheet) {
        Sheet.Set set = sheet.get("properties");
        try {
            InstanceCookie.Of of = this.ic();
            if (of == null) {
                return;
            }
            BeanInfo beanInfo = Utilities.getBeanInfo((Class)of.instanceClass());
            BeanNode.Descriptor descriptor = BeanNode.computeProperties((Object)of.instanceCreate(), (BeanInfo)beanInfo);
            this.initPList();
            set = Sheet.createPropertiesSet();
            if (descriptor.property != null) {
                InstanceNode.convertProps(set, descriptor.property, this.i());
            }
            sheet.put(set);
            if (descriptor.expert != null && descriptor.expert.length != 0) {
                Sheet.Set set2 = Sheet.createExpertSet();
                InstanceNode.convertProps(set2, descriptor.expert, this.i());
                sheet.put(set2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(InstanceNode.class.getName()).log(Level.WARNING, null, classNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger(InstanceNode.class.getName()).log(Level.WARNING, null, iOException);
        }
        catch (IntrospectionException introspectionException) {
            Logger.getLogger(InstanceNode.class.getName()).log(Level.WARNING, null, introspectionException);
        }
        catch (LinkageError linkageError) {
            Logger.getLogger(InstanceNode.class.getName()).log(Level.WARNING, null, linkageError);
        }
    }

    private static final void convertProps(Sheet.Set set, Node.Property[] propertyArray, InstanceDataObject instanceDataObject) {
        for (int i = 0; i < propertyArray.length; ++i) {
            if (propertyArray[i] instanceof Node.IndexedProperty) {
                set.put(new I((Node.IndexedProperty)propertyArray[i], instanceDataObject));
                continue;
            }
            set.put(new P(propertyArray[i], instanceDataObject));
        }
    }

    private static final Image toBufferedImage(Image image, boolean bl) {
        if (bl) {
            new ImageIcon(image);
        }
        BufferedImage bufferedImage = InstanceNode.createBufferedImage();
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        image.flush();
        return bufferedImage;
    }

    private static final BufferedImage createBufferedImage() {
        ColorModel colorModel = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(2);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(16, 16), colorModel.isAlphaPremultiplied(), null);
        return bufferedImage;
    }

    public boolean canRename() {
        if (!this.getDataObject().getPrimaryFile().hasExt(XML_EXT)) {
            return super.canRename();
        }
        return this.getDeclaredSetter() != null;
    }

    public boolean canDestroy() {
        if (!this.getDataObject().getPrimaryFile().hasExt(XML_EXT)) {
            return super.canDestroy();
        }
        try {
            InstanceCookie.Of of = this.ic();
            if (of == null) {
                return true;
            }
            Class clazz = of.instanceClass();
            return !SharedClassObject.class.isAssignableFrom(clazz);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean canCut() {
        if (!this.getDataObject().getPrimaryFile().hasExt(XML_EXT)) {
            return super.canCut();
        }
        try {
            InstanceCookie.Of of = this.ic();
            if (of == null) {
                return false;
            }
            Class clazz = of.instanceClass();
            return !SharedClassObject.class.isAssignableFrom(clazz);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean canCopy() {
        if (!this.getDataObject().getPrimaryFile().hasExt(XML_EXT)) {
            return super.canCopy();
        }
        try {
            InstanceCookie.Of of = this.ic();
            if (of == null) {
                return false;
            }
            Class clazz = of.instanceClass();
            return !SharedClassObject.class.isAssignableFrom(clazz);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getShortDescription() {
        if (this.noBeanInfo) {
            return super.getShortDescription();
        }
        try {
            InstanceCookie.Of of = this.ic();
            if (of == null) {
                return this.getDataObject().getPrimaryFile().toString();
            }
            Class clazz = of.instanceClass();
            BeanDescriptor beanDescriptor = Utilities.getBeanInfo((Class)clazz).getBeanDescriptor();
            String string = beanDescriptor.getShortDescription();
            return string.equals(beanDescriptor.getName()) ? this.getDisplayName() : string;
        }
        catch (Exception exception) {
            return super.getShortDescription();
        }
        catch (LinkageError linkageError) {
            return super.getShortDescription();
        }
    }

    public Action getPreferredAction() {
        return null;
    }

    private final class PropL
    implements PropertyChangeListener {
        private boolean doNotListen = false;

        PropL() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.doNotListen) {
                return;
            }
            InstanceNode.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }

        public void destroy() {
            this.doNotListen = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanContextNode<T>
    extends BeanNode<T> {
        public BeanContextNode(T t, InstanceDataObject instanceDataObject) throws IntrospectionException {
            super(t, BeanContextNode.getChildren(t, instanceDataObject));
            this.changeSheet(this.getSheet(), instanceDataObject);
        }

        private void changeSheet(Sheet sheet, InstanceDataObject instanceDataObject) {
            Sheet.Set set = sheet.get("properties");
            if (set != null) {
                InstanceNode.convertProps(set, set.getProperties(), instanceDataObject);
            }
            if ((set = sheet.get("expert")) != null) {
                InstanceNode.convertProps(set, set.getProperties(), instanceDataObject);
            }
        }

        private static Children getChildren(Object object, InstanceDataObject instanceDataObject) {
            BeanContextChild beanContextChild;
            if (object instanceof BeanContext) {
                return new BeanChildren((BeanContext)object, (BeanChildren.Factory)new BeanFactoryImpl(instanceDataObject));
            }
            if (object instanceof BeanContextProxy && (beanContextChild = ((BeanContextProxy)object).getBeanContextProxy()) instanceof BeanContext) {
                return new BeanChildren((BeanContext)beanContextChild, (BeanChildren.Factory)new BeanFactoryImpl(instanceDataObject));
            }
            return Children.LEAF;
        }

        public boolean canDestroy() {
            return false;
        }
    }

    private static class BeanFactoryImpl
    implements BeanChildren.Factory {
        InstanceDataObject task;

        public BeanFactoryImpl(InstanceDataObject instanceDataObject) {
            this.task = instanceDataObject;
        }

        public Node createNode(Object object) throws IntrospectionException {
            return new BeanContextNode<Object>(object, this.task);
        }
    }

    private static final class InstanceChildren
    extends Children.Keys
    implements PropertyChangeListener {
        WeakReference<PropertyChangeListener> dobjListener;
        InstanceDataObject dobj;
        Object bean;
        ContextL contextL = null;

        public InstanceChildren(InstanceDataObject instanceDataObject) {
            this.dobj = instanceDataObject;
        }

        protected void addNotify() {
            super.addNotify();
            PropertyChangeListener propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.dobj);
            this.dobjListener = new WeakReference<PropertyChangeListener>(propertyChangeListener);
            this.dobj.addPropertyChangeListener(propertyChangeListener);
            this.contextL = new ContextL(this);
            this.propertyChange(null);
        }

        protected void removeNotify() {
            if (this.contextL != null && this.bean != null) {
                ((BeanContext)this.bean).removeBeanContextMembershipListener(this.contextL);
            }
            this.contextL = null;
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.dobjListener.get();
            if (propertyChangeListener != null) {
                this.dobj.removePropertyChangeListener(propertyChangeListener);
                this.dobjListener.clear();
            }
            this.setKeys(Collections.emptySet());
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent != null && !propertyChangeEvent.getPropertyName().equals("cookie")) {
                return;
            }
            if (this.contextL != null && this.bean != null) {
                ((BeanContext)this.bean).removeBeanContextMembershipListener(this.contextL);
            }
            try {
                InstanceCookie instanceCookie = this.dobj.getCookie(InstanceCookie.class);
                if (instanceCookie == null) {
                    this.bean = null;
                    return;
                }
                Class clazz = instanceCookie.instanceClass();
                this.bean = BeanContext.class.isAssignableFrom(clazz) ? instanceCookie.instanceCreate() : (BeanContextProxy.class.isAssignableFrom(clazz) ? ((BeanContextProxy)this.dobj.instanceCreate()).getBeanContextProxy() : null);
            }
            catch (Exception exception) {
                this.bean = null;
                Exceptions.printStackTrace((Throwable)exception);
            }
            if (this.bean != null) {
                ((BeanContext)this.bean).addBeanContextMembershipListener(this.contextL);
            }
            this.updateKeys();
        }

        private void updateKeys() {
            if (this.bean == null) {
                this.setKeys(Collections.emptySet());
            } else {
                this.setKeys(((BeanContext)this.bean).toArray());
            }
        }

        protected Node[] createNodes(Object object) {
            Object object2 = this.bean;
            if (this.bean == null) {
                return new Node[0];
            }
            try {
                BeanContextSupport beanContextSupport;
                if (object instanceof BeanContextSupport && ((BeanContext)object2).contains((beanContextSupport = (BeanContextSupport)object).getBeanContextPeer())) {
                    return new Node[0];
                }
                return new Node[]{new BeanContextNode<Object>(object, this.dobj)};
            }
            catch (IntrospectionException introspectionException) {
                return new Node[0];
            }
        }

        private static final class ContextL
        implements BeanContextMembershipListener {
            private WeakReference<InstanceChildren> ref;

            ContextL(InstanceChildren instanceChildren) {
                this.ref = new WeakReference<InstanceChildren>(instanceChildren);
            }

            public void childrenAdded(BeanContextMembershipEvent beanContextMembershipEvent) {
                InstanceChildren instanceChildren = (InstanceChildren)this.ref.get();
                if (instanceChildren != null) {
                    instanceChildren.updateKeys();
                }
            }

            public void childrenRemoved(BeanContextMembershipEvent beanContextMembershipEvent) {
                InstanceChildren instanceChildren = (InstanceChildren)this.ref.get();
                if (instanceChildren != null) {
                    instanceChildren.updateKeys();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class I<T>
    extends Node.IndexedProperty<T, InstanceDataObject> {
        private Node.IndexedProperty<T, InstanceDataObject> del;
        private InstanceDataObject t;

        public I(Node.IndexedProperty<T, InstanceDataObject> indexedProperty, InstanceDataObject instanceDataObject) {
            super(indexedProperty.getValueType(), indexedProperty.getElementType());
            this.del = indexedProperty;
            this.t = instanceDataObject;
        }

        public void setName(String string) {
            this.del.setName(string);
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.del.restoreDefaultValue();
        }

        public void setValue(String string, Object object) {
            this.del.setValue(string, object);
        }

        public boolean supportsDefaultValue() {
            return this.del.supportsDefaultValue();
        }

        public boolean canRead() {
            return this.del.canRead();
        }

        public PropertyEditor getPropertyEditor() {
            return this.del.getPropertyEditor();
        }

        public boolean isHidden() {
            return this.del.isHidden();
        }

        public T getValue() throws IllegalAccessException, InvocationTargetException {
            return (T)this.del.getValue();
        }

        public void setExpert(boolean bl) {
            this.del.setExpert(bl);
        }

        public void setValue(T t) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.del.setValue(t);
            this.t.scheduleSave();
        }

        public void setShortDescription(String string) {
            this.del.setShortDescription(string);
        }

        public boolean isExpert() {
            return this.del.isExpert();
        }

        public boolean canWrite() {
            return this.del.canWrite();
        }

        public Class<T> getValueType() {
            return this.del.getValueType();
        }

        public String getDisplayName() {
            return this.del.getDisplayName();
        }

        public Enumeration<String> attributeNames() {
            return this.del.attributeNames();
        }

        public String getShortDescription() {
            return this.del.getShortDescription();
        }

        public String getName() {
            return this.del.getName();
        }

        public void setHidden(boolean bl) {
            this.del.setHidden(bl);
        }

        public void setDisplayName(String string) {
            this.del.setDisplayName(string);
        }

        public boolean isPreferred() {
            return this.del.isPreferred();
        }

        public Object getValue(String string) {
            return this.del.getValue(string);
        }

        public void setPreferred(boolean bl) {
            this.del.setPreferred(bl);
        }

        public boolean canIndexedRead() {
            return this.del.canIndexedRead();
        }

        public Class<InstanceDataObject> getElementType() {
            return this.del.getElementType();
        }

        public InstanceDataObject getIndexedValue(int n) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return (InstanceDataObject)this.del.getIndexedValue(n);
        }

        public boolean canIndexedWrite() {
            return this.del.canIndexedWrite();
        }

        public void setIndexedValue(int n, InstanceDataObject instanceDataObject) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.del.setIndexedValue(n, (Object)instanceDataObject);
            this.t.scheduleSave();
        }

        public PropertyEditor getIndexedPropertyEditor() {
            return this.del.getIndexedPropertyEditor();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class P<T>
    extends Node.Property<T> {
        private Node.Property<T> del;
        private InstanceDataObject t;

        public P(Node.Property<T> property, InstanceDataObject instanceDataObject) {
            super(property.getValueType());
            this.del = property;
            this.t = instanceDataObject;
        }

        public void setName(String string) {
            this.del.setName(string);
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.del.restoreDefaultValue();
        }

        public void setValue(String string, Object object) {
            this.del.setValue(string, object);
        }

        public boolean supportsDefaultValue() {
            return this.del.supportsDefaultValue();
        }

        public boolean canRead() {
            return this.del.canRead();
        }

        public PropertyEditor getPropertyEditor() {
            return this.del.getPropertyEditor();
        }

        public boolean isHidden() {
            return this.del.isHidden();
        }

        public T getValue() throws IllegalAccessException, InvocationTargetException {
            return (T)this.del.getValue();
        }

        public void setExpert(boolean bl) {
            this.del.setExpert(bl);
        }

        public void setValue(T t) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.del.setValue(t);
            this.t.scheduleSave();
        }

        public void setShortDescription(String string) {
            this.del.setShortDescription(string);
        }

        public boolean isExpert() {
            return this.del.isExpert();
        }

        public boolean canWrite() {
            return this.del.canWrite();
        }

        public Class<T> getValueType() {
            return this.del.getValueType();
        }

        public String getDisplayName() {
            return this.del.getDisplayName();
        }

        public Enumeration<String> attributeNames() {
            return this.del.attributeNames();
        }

        public String getShortDescription() {
            return this.del.getShortDescription();
        }

        public String getName() {
            return this.del.getName();
        }

        public void setHidden(boolean bl) {
            this.del.setHidden(bl);
        }

        public void setDisplayName(String string) {
            this.del.setDisplayName(string);
        }

        public boolean isPreferred() {
            return this.del.isPreferred();
        }

        public Object getValue(String string) {
            return this.del.getValue(string);
        }

        public void setPreferred(boolean bl) {
            this.del.setPreferred(bl);
        }
    }
}

