/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationContext {
    private StackFrame frame;
    private int frameDepth;
    private JPDAThreadImpl thread;
    private ObjectReference contextVariable;
    private List<String> sourceImports;
    private List<String> staticImports;
    private boolean canInvokeMethods;
    private Runnable methodInvokePreproc;
    private JPDADebuggerImpl debugger;
    private Trees trees;
    private CompilationUnitTree compilationUnitTree;
    private TreePath treePath;
    private Map<Tree, VariableInfo> variables = new HashMap<Tree, VariableInfo>();
    private Stack<Map<String, ScriptVariable>> stack = new Stack();
    private Map<String, ScriptVariable> scriptLocalVariables = new HashMap<String, ScriptVariable>();
    private final List<ObjectReference> disabledCollectionObjects = new ArrayList<ObjectReference>();
    private PropertyChangeListener threadPropertyChangeListener = null;

    public EvaluationContext(JPDAThreadImpl jPDAThreadImpl, StackFrame stackFrame, int n, ObjectReference objectReference, List<String> list, List<String> list2, boolean bl, Runnable runnable, JPDADebuggerImpl jPDADebuggerImpl) {
        if (jPDAThreadImpl == null) {
            throw new IllegalArgumentException("Thread argument must not be null");
        }
        if (stackFrame == null) {
            throw new IllegalArgumentException("Frame argument must not be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("Imports argument must not be null");
        }
        if (list2 == null) {
            throw new IllegalArgumentException("Static imports argument must not be null");
        }
        this.thread = jPDAThreadImpl;
        this.frame = stackFrame;
        this.frameDepth = n;
        this.contextVariable = objectReference;
        this.sourceImports = list;
        this.staticImports = list2;
        this.canInvokeMethods = bl;
        this.methodInvokePreproc = runnable;
        this.debugger = jPDADebuggerImpl;
        this.stack.push(new HashMap());
    }

    public List<String> getStaticImports() {
        return this.staticImports;
    }

    public List<String> getImports() {
        return this.sourceImports;
    }

    public StackFrame getFrame() {
        return this.frame;
    }

    ObjectReference getContextVariable() {
        return this.contextVariable;
    }

    public ObjectReference getContextObject() {
        if (this.contextVariable != null) {
            return this.contextVariable;
        }
        try {
            return this.frame.thisObject();
        }
        catch (InternalException internalException) {
            if (internalException.errorCode() == 35) {
                return null;
            }
            throw internalException;
        }
    }

    public boolean canInvokeMethods() {
        return this.canInvokeMethods;
    }

    void setCanInvokeMethods(boolean bl) {
        this.canInvokeMethods = bl;
    }

    void methodToBeInvoked() {
        if (this.methodInvokePreproc != null) {
            this.methodInvokePreproc.run();
        }
    }

    void methodInvokeDone() throws IncompatibleThreadStateException {
        try {
            this.frame = ThreadReferenceWrapper.frame(this.thread.getThreadReference(), this.frameDepth);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)internalExceptionWrapper);
            invalidExpressionException.initCause((Throwable)internalExceptionWrapper);
            throw new IllegalStateException(invalidExpressionException);
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)objectCollectedExceptionWrapper);
            invalidExpressionException.initCause((Throwable)objectCollectedExceptionWrapper);
            throw new IllegalStateException(invalidExpressionException);
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)illegalThreadStateExceptionWrapper);
            invalidExpressionException.initCause((Throwable)illegalThreadStateExceptionWrapper);
            throw new IllegalStateException(invalidExpressionException);
        }
    }

    JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    public void setTrees(Trees trees) {
        this.trees = trees;
    }

    Trees getTrees() {
        return this.trees;
    }

    public void setCompilationUnit(CompilationUnitTree compilationUnitTree) {
        this.compilationUnitTree = compilationUnitTree;
    }

    CompilationUnitTree getCompilationUnit() {
        return this.compilationUnitTree;
    }

    public void setTreePath(TreePath treePath) {
        this.treePath = treePath;
    }

    TreePath getTreePath() {
        return this.treePath;
    }

    public VariableInfo getVariableInfo(Tree tree) {
        return this.variables.get(tree);
    }

    public void putField(Tree tree, Field field, ObjectReference objectReference) {
        VariableInfo.FieldInf fieldInf = new VariableInfo.FieldInf(field, objectReference);
        this.variables.put(tree, fieldInf);
    }

    public void putLocalVariable(Tree tree, LocalVariable localVariable) {
        VariableInfo.LocalVarInf localVarInf = new VariableInfo.LocalVarInf(localVariable, this);
        this.variables.put(tree, localVarInf);
    }

    public void putArrayAccess(Tree tree, ArrayReference arrayReference, int n) {
        VariableInfo.ArrayElementInf arrayElementInf = new VariableInfo.ArrayElementInf(arrayReference, n);
        this.variables.put(tree, arrayElementInf);
    }

    public void putScriptVariable(Tree tree, ScriptVariable scriptVariable) {
        VariableInfo.ScriptLocalVarInf scriptLocalVarInf = new VariableInfo.ScriptLocalVarInf(scriptVariable);
        this.variables.put(tree, scriptLocalVarInf);
    }

    public ScriptVariable getScriptVariableByName(String string) {
        return this.scriptLocalVariables.get(string);
    }

    public ScriptVariable createScriptLocalVariable(String string, Type type) {
        Map<String, ScriptVariable> map = this.stack.peek();
        ScriptVariable scriptVariable = new ScriptVariable(string, type);
        map.put(string, scriptVariable);
        this.scriptLocalVariables.put(string, scriptVariable);
        return scriptVariable;
    }

    public void pushBlock() {
        this.stack.push(new HashMap());
    }

    public void popBlock() {
        Map<String, ScriptVariable> map = this.stack.pop();
        for (String string : map.keySet()) {
            this.scriptLocalVariables.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableCollectionOf(ObjectReference objectReference) {
        List<ObjectReference> list = this.disabledCollectionObjects;
        synchronized (list) {
            if (this.threadPropertyChangeListener == null) {
                this.threadPropertyChangeListener = new PropertyChangeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (EvaluationContext.this.thread.equals(propertyChangeEvent.getSource()) && "suspended".equals(propertyChangeEvent.getPropertyName()) || ((Object)((Object)EvaluationContext.this.thread.getDebugger())).equals(propertyChangeEvent.getSource()) && "state".equals(propertyChangeEvent.getPropertyName())) {
                            if (EvaluationContext.this.thread.getDebugger().getState() != 4) {
                                if (EvaluationContext.this.thread.isMethodInvoking()) {
                                    return;
                                }
                                if (EvaluationContext.this.thread.isSuspended()) {
                                    return;
                                }
                            }
                            List list = EvaluationContext.this.disabledCollectionObjects;
                            synchronized (list) {
                                EvaluationContext.this.enableCollectionOfObjects(null);
                            }
                            EvaluationContext.this.thread.removePropertyChangeListener(EvaluationContext.this.threadPropertyChangeListener);
                            EvaluationContext.this.thread.getDebugger().removePropertyChangeListener(EvaluationContext.this.threadPropertyChangeListener);
                        }
                    }
                };
                this.thread.addPropertyChangeListener(this.threadPropertyChangeListener);
                this.thread.getDebugger().addPropertyChangeListener(this.threadPropertyChangeListener);
            }
            if (this.disabledCollectionObjects.add(objectReference)) {
                try {
                    objectReference.disableCollection();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.disabledCollectionObjects.remove(objectReference);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableCollectionOfObjects(Value value) {
        List<ObjectReference> list = this.disabledCollectionObjects;
        synchronized (list) {
            HashSet<ObjectReference> hashSet = new HashSet<ObjectReference>(this.disabledCollectionObjects);
            for (ObjectReference objectReference : hashSet) {
                if (value != null && value.equals(objectReference)) continue;
                try {
                    ObjectReferenceWrapper.enableCollection(objectReference);
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    return;
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                    Exceptions.printStackTrace((Throwable)objectCollectedExceptionWrapper);
                }
                catch (UnsupportedOperationExceptionWrapper unsupportedOperationExceptionWrapper) {
                    // empty catch block
                }
                this.disabledCollectionObjects.remove(objectReference);
            }
        }
    }

    public static abstract class VariableInfo {
        public abstract void setValue(Value var1);

        public abstract Type getType() throws ClassNotLoadedException;

        private static class ScriptLocalVarInf
        extends VariableInfo {
            private ScriptVariable variable;

            ScriptLocalVarInf(ScriptVariable scriptVariable) {
                this.variable = scriptVariable;
            }

            public Type getType() throws ClassNotLoadedException {
                return this.variable.getType();
            }

            public void setValue(Value value) {
                this.variable.setValue(value);
            }
        }

        private static class ArrayElementInf
        extends VariableInfo {
            private ArrayReference array;
            private int index;

            ArrayElementInf(ArrayReference arrayReference, int n) {
                this.array = arrayReference;
                this.index = n;
            }

            public Type getType() throws ClassNotLoadedException {
                return this.array.type();
            }

            public void setValue(Value value) {
                try {
                    this.array.setValue(this.index, value);
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    throw new IllegalStateException(classNotLoadedException);
                }
                catch (InvalidTypeException invalidTypeException) {
                    throw new IllegalStateException(new InvalidExpressionException((Throwable)invalidTypeException));
                }
            }
        }

        private static class LocalVarInf
        extends VariableInfo {
            private LocalVariable var;
            private EvaluationContext context;

            LocalVarInf(LocalVariable localVariable, EvaluationContext evaluationContext) {
                this.var = localVariable;
                this.context = evaluationContext;
            }

            public Type getType() throws ClassNotLoadedException {
                return this.var.type();
            }

            public void setValue(Value value) {
                try {
                    this.context.getFrame().setValue(this.var, value);
                }
                catch (InvalidTypeException invalidTypeException) {
                    throw new IllegalStateException(new InvalidExpressionException((Throwable)invalidTypeException));
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    throw new IllegalStateException(classNotLoadedException);
                }
            }
        }

        private static class FieldInf
        extends VariableInfo {
            private Field field;
            private ObjectReference fieldObject;

            FieldInf(Field field) {
                this.field = field;
            }

            FieldInf(Field field, ObjectReference objectReference) {
                this.field = field;
                this.fieldObject = objectReference;
            }

            public Type getType() throws ClassNotLoadedException {
                return this.field.type();
            }

            public void setValue(Value value) {
                try {
                    if (this.fieldObject != null) {
                        this.fieldObject.setValue(this.field, value);
                    } else {
                        ((ClassType)this.field.declaringType()).setValue(this.field, value);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalStateException(new InvalidExpressionException((Throwable)illegalArgumentException));
                }
                catch (InvalidTypeException invalidTypeException) {
                    throw new IllegalStateException(new InvalidExpressionException((Throwable)invalidTypeException));
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    throw new IllegalStateException(classNotLoadedException);
                }
            }
        }
    }

    public static class ScriptVariable {
        private String name;
        private Type type;
        private Mirror value;
        private boolean valueInited = false;

        public ScriptVariable(String string, Type type) {
            this.name = string;
            this.type = type;
        }

        public Mirror getValue() {
            return this.value;
        }

        public Type getType() {
            return this.type;
        }

        public void setValue(Mirror mirror) {
            this.value = mirror;
            this.valueInited = true;
        }
    }
}

