/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.actions.RunIntoMethodActionProvider;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.editor.highlighting.HighlightAttributeValue;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MethodChooser
implements KeyListener,
MouseListener,
MouseMotionListener,
PropertyChangeListener,
FocusListener {
    private static AttributeSet defaultHyperlinkHighlight;
    private JPDADebuggerImpl debugger;
    private JPDAThread currentThread;
    private String url;
    private ReferenceType clazzRef;
    private int methodLine;
    private int methodOffset;
    private AttributeSet attribsLeft = null;
    private AttributeSet attribsRight = null;
    private AttributeSet attribsMiddle = null;
    private AttributeSet attribsAll = null;
    private AttributeSet attribsArea = null;
    private AttributeSet attribsMethod = null;
    private AttributeSet attribsHyperlink = null;
    private Cursor handCursor;
    private Cursor arrowCursor;
    private Cursor originalCursor;
    private JEditorPane editorPane;
    private Document doc;
    private int startLine;
    private int endLine;
    private EditorContext.Operation[] operations;
    private Location[] locations;
    private ArrayList<Annotation> annotations;
    private boolean performAction = false;
    private int selectedIndex = -1;
    private int mousedIndex = -1;
    private ActionListener releaseListener;
    private boolean isInSelectMode = false;

    MethodChooser(JPDADebuggerImpl jPDADebuggerImpl, String string, ReferenceType referenceType, int n, int n2) {
        this.debugger = jPDADebuggerImpl;
        this.currentThread = jPDADebuggerImpl.getCurrentThread();
        this.url = string;
        this.clazzRef = referenceType;
        this.methodOffset = n2;
    }

    public void setReleaseListener(ActionListener actionListener) {
        this.releaseListener = actionListener;
    }

    public static OffsetsBag getHighlightsBag(Document document) {
        OffsetsBag offsetsBag = (OffsetsBag)document.getProperty(MethodChooser.class);
        if (offsetsBag == null) {
            offsetsBag = new OffsetsBag(document, true);
            document.putProperty(MethodChooser.class, offsetsBag);
        }
        return offsetsBag;
    }

    public boolean run() {
        DataObject dataObject = this.getDataObject(this.url);
        final EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
                    if (jEditorPaneArray != null) {
                        MethodChooser.this.editorPane = jEditorPaneArray[0];
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
        if (this.editorPane == null) {
            return false;
        }
        this.doc = this.editorPane.getDocument();
        if (this.debugger.getState() == 4) {
            return false;
        }
        boolean bl = this.collectOperations();
        if (this.selectedIndex == -1) {
            return false;
        }
        if (bl || this.operations.length == 1) {
            String string = this.operations[this.selectedIndex].getMethodName();
            boolean bl2 = RunIntoMethodActionProvider.doAction(this.debugger, string, this.locations[this.selectedIndex], true);
            return bl2;
        }
        System.setProperty("org.netbeans.modules.debugger.jpda.doNotShowTooltips", "true");
        this.debugger.addPropertyChangeListener(this);
        this.debugger.getThreadsCollector().addPropertyChangeListener(this);
        this.editorPane.putClientProperty(MethodChooser.class, this);
        this.editorPane.addKeyListener(this);
        this.editorPane.addMouseListener(this);
        this.editorPane.addMouseMotionListener(this);
        this.editorPane.addFocusListener(this);
        this.originalCursor = this.editorPane.getCursor();
        this.handCursor = Cursor.getPredefinedCursor(12);
        this.arrowCursor = Cursor.getPredefinedCursor(0);
        this.editorPane.setCursor(this.arrowCursor);
        Caret caret = this.editorPane.getCaret();
        if (caret instanceof BaseCaret) {
            ((BaseCaret)caret).setVisible(false);
        }
        this.annotateLines();
        this.requestRepaint();
        Coloring coloring = new Coloring(null, 0, null, Color.CYAN);
        Utilities.setStatusText((JTextComponent)this.editorPane, (String)(" " + NbBundle.getMessage(MethodChooser.class, (String)"MSG_RunIntoMethod_Status_Line_Help")), (Coloring)coloring);
        this.isInSelectMode = true;
        return true;
    }

    private synchronized void release() {
        this.debugger.removePropertyChangeListener(this);
        this.debugger.getThreadsCollector().removePropertyChangeListener(this);
        MethodChooser.getHighlightsBag(this.doc).clear();
        this.editorPane.removeKeyListener(this);
        this.editorPane.removeMouseListener(this);
        this.editorPane.removeMouseMotionListener(this);
        this.editorPane.removeFocusListener(this);
        this.editorPane.putClientProperty(MethodChooser.class, null);
        this.editorPane.setCursor(this.originalCursor);
        Caret caret = this.editorPane.getCaret();
        if (caret instanceof BaseCaret) {
            ((BaseCaret)caret).setVisible(true);
        }
        this.clearAnnotations();
        System.clearProperty("org.netbeans.modules.debugger.jpda.doNotShowTooltips");
        Utilities.clearStatusText((JTextComponent)this.editorPane);
        if (this.performAction) {
            this.performAction = false;
            final String string = this.operations[this.selectedIndex].getMethodName();
            this.debugger.getRequestProcessor().post(new Runnable(){

                public void run() {
                    RunIntoMethodActionProvider.doAction(MethodChooser.this.debugger, string, MethodChooser.this.locations[MethodChooser.this.selectedIndex], true);
                }
            });
        }
        if (this.releaseListener != null) {
            this.releaseListener.actionPerformed(null);
            this.releaseListener = null;
        }
        this.isInSelectMode = false;
    }

    boolean isInSelectMode() {
        return this.isInSelectMode;
    }

    void doStepIntoCurrentSelection() {
        this.performAction = true;
        this.release();
    }

    private DataObject getDataObject(String string) {
        FileObject fileObject;
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        if (fileObject == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
    }

    private boolean collectOperations() {
        int n;
        int n2;
        int n3;
        int n4;
        this.methodLine = this.currentThread.getLineNumber(null);
        List<Object> list = Collections.emptyList();
        try {
            while (this.methodLine > 0 && (list = ReferenceTypeWrapper.locationsOfLine(this.clazzRef, this.methodLine)).isEmpty()) {
                --this.methodLine;
            }
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return false;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return false;
        }
        catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
        }
        catch (AbsentInformationException absentInformationException) {
            ErrorManager.getDefault().notify(1, (Throwable)absentInformationException);
        }
        if (list.isEmpty()) {
            return false;
        }
        ExpressionPool.Expression expression = this.debugger.getExpressionPool().getExpressionAt((Location)list.get(0), this.url);
        if (expression == null) {
            return false;
        }
        EditorContext.Operation operation = this.currentThread.getCurrentOperation();
        List list2 = this.currentThread.getLastOperations();
        EditorContext.Operation operation2 = list2 != null && list2.size() > 0 ? (EditorContext.Operation)list2.get(list2.size() - 1) : null;
        EditorContext.Operation operation3 = null;
        EditorContext.Operation[] operationArray = expression.getOperations();
        if (operationArray.length == 0) {
            return false;
        }
        Location[] locationArray = expression.getLocations();
        this.operations = new EditorContext.Operation[operationArray.length];
        this.locations = new Location[operationArray.length];
        for (n4 = 0; n4 < operationArray.length; ++n4) {
            this.operations[n4] = operationArray[n4];
            this.locations[n4] = locationArray[n4];
        }
        this.startLine = this.operations[0].getMethodStartPosition().getLine();
        this.endLine = this.operations[this.operations.length - 1].getMethodEndPosition().getLine();
        for (n4 = 1; n4 < this.operations.length - 1; ++n4) {
            n3 = this.operations[n4].getMethodStartPosition().getLine();
            if (n3 < this.startLine) {
                this.startLine = n3;
            }
            if (n3 <= this.endLine) continue;
            this.endLine = n3;
        }
        n4 = -1;
        n3 = -1;
        if (operation != null) {
            n2 = operation.getBytecodeIndex();
            for (n = 0; n < this.operations.length; ++n) {
                if (this.operations[n].getBytecodeIndex() != n2) continue;
                n4 = n;
                break;
            }
        }
        if (operation2 != null) {
            n2 = operation2.getBytecodeIndex();
            for (n = 0; n < this.operations.length; ++n) {
                if (this.operations[n].getBytecodeIndex() != n2) continue;
                n3 = n;
                break;
            }
        }
        if (n4 == -1) {
            operation3 = this.operations[this.operations.length - 1];
        } else if (n4 == n3) {
            operationArray = new EditorContext.Operation[this.operations.length - 1 - n4];
            locationArray = new Location[this.operations.length - 1 - n4];
            for (n2 = 0; n2 < operationArray.length; ++n2) {
                operationArray[n2] = this.operations[n2 + n4 + 1];
                locationArray[n2] = this.locations[n2 + n4 + 1];
            }
            this.operations = operationArray;
            this.locations = locationArray;
            if (this.operations.length == 0) {
                return false;
            }
            operation3 = this.operations[0];
        } else {
            this.selectedIndex = n4;
            return true;
        }
        Object[][] objectArray = new Object[this.operations.length][2];
        for (n = 0; n < this.operations.length; ++n) {
            objectArray[n][0] = this.operations[n];
            objectArray[n][1] = this.locations[n];
        }
        Arrays.sort(objectArray, new OperatorsComparator());
        this.selectedIndex = 0;
        for (n = 0; n < this.operations.length; ++n) {
            this.operations[n] = (EditorContext.Operation)objectArray[n][0];
            this.locations[n] = (Location)objectArray[n][1];
            if (!this.operations[n].equals((Object)operation3)) continue;
            this.selectedIndex = n;
        }
        return false;
    }

    private void requestRepaint() {
        Color color;
        if (this.attribsLeft == null) {
            color = Color.BLACK;
            this.attribsLeft = this.createAttribs(EditorStyleConstants.LeftBorderLineColor, color, EditorStyleConstants.TopBorderLineColor, color, EditorStyleConstants.BottomBorderLineColor, color);
            this.attribsRight = this.createAttribs(EditorStyleConstants.RightBorderLineColor, color, EditorStyleConstants.TopBorderLineColor, color, EditorStyleConstants.BottomBorderLineColor, color);
            this.attribsMiddle = this.createAttribs(EditorStyleConstants.TopBorderLineColor, color, EditorStyleConstants.BottomBorderLineColor, color);
            this.attribsAll = this.createAttribs(EditorStyleConstants.LeftBorderLineColor, color, EditorStyleConstants.RightBorderLineColor, color, EditorStyleConstants.TopBorderLineColor, color, EditorStyleConstants.BottomBorderLineColor, color);
            this.attribsHyperlink = this.getHyperlinkHighlight();
            this.attribsMethod = this.createAttribs(StyleConstants.Foreground, Color.BLACK, StyleConstants.Bold, Boolean.TRUE);
            this.attribsArea = this.createAttribs(StyleConstants.Foreground, Color.BLACK, StyleConstants.Italic, Boolean.FALSE, StyleConstants.Bold, Boolean.FALSE);
        }
        color = new OffsetsBag(this.doc, true);
        int n = this.operations[0].getStartPosition().getOffset();
        int n2 = this.operations[this.operations.length - 1].getEndPosition().getOffset();
        color.addHighlight(n, n2, this.attribsArea);
        for (int i = 0; i < this.operations.length; ++i) {
            int n3 = this.operations[i].getMethodStartPosition().getOffset();
            int n4 = this.operations[i].getMethodEndPosition().getOffset();
            color.addHighlight(n3, n4, this.attribsMethod);
            if (this.selectedIndex == i) {
                int n5 = n4 - n3;
                if (n5 == 1) {
                    color.addHighlight(n3, n4, this.attribsAll);
                } else if (n5 > 1) {
                    color.addHighlight(n3, n3 + 1, this.attribsLeft);
                    color.addHighlight(n4 - 1, n4, this.attribsRight);
                    if (n5 > 2) {
                        color.addHighlight(n3 + 1, n4 - 1, this.attribsMiddle);
                    }
                }
            }
            if (this.mousedIndex != i) continue;
            AttributeSet attributeSet = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{this.attribsHyperlink, AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.Tooltip, new TooltipResolver()})});
            color.addHighlight(n3, n4, attributeSet);
        }
        OffsetsBag offsetsBag = MethodChooser.getHighlightsBag(this.doc);
        offsetsBag.setHighlights((OffsetsBag)color);
    }

    private void annotateLines() {
        this.annotations = new ArrayList();
        EditorContext editorContext = EditorContextBridge.getContext();
        JPDAThread jPDAThread = this.debugger.getCurrentThread();
        EditorContext.Operation operation = jPDAThread.getCurrentOperation();
        int n = operation != null ? operation.getStartPosition().getLine() : jPDAThread.getLineNumber(null);
        String string = operation != null ? "CurrentExpressionLine" : "CurrentPC";
        for (int i = this.startLine; i <= this.endLine; ++i) {
            Object object;
            if (i == n || !((object = editorContext.annotate(this.url, i, string, null)) instanceof Annotation)) continue;
            this.annotations.add((Annotation)object);
        }
    }

    private void clearAnnotations() {
        if (this.annotations != null) {
            for (Annotation annotation : this.annotations) {
                annotation.detach();
            }
        }
    }

    private AttributeSet createAttribs(Object ... objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = objectArray.length / 2 - 1; i >= 0; --i) {
            Object object = objectArray[2 * i];
            Object object2 = objectArray[2 * i + 1];
            if (object == null || object2 == null) continue;
            arrayList.add(object);
            arrayList.add(object2);
        }
        return AttributesUtilities.createImmutable((Object[])arrayList.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributeSet getHyperlinkHighlight() {
        MethodChooser methodChooser = this;
        synchronized (methodChooser) {
            if (defaultHyperlinkHighlight == null) {
                defaultHyperlinkHighlight = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Foreground, Color.BLUE, StyleConstants.Underline, Color.BLUE});
            }
        }
        return defaultHyperlinkHighlight;
    }

    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        boolean bl = true;
        switch (n) {
            case 10: 
            case 32: 
            case 118: {
                if (keyEvent.isControlDown() || keyEvent.isShiftDown()) {
                    this.release();
                    bl = false;
                    break;
                }
                this.performAction = true;
                this.release();
                break;
            }
            case 119: {
                this.release();
                bl = false;
                break;
            }
            case 27: {
                this.release();
                break;
            }
            case 9: 
            case 39: 
            case 40: {
                ++this.selectedIndex;
                if (this.selectedIndex == this.operations.length) {
                    this.selectedIndex = 0;
                }
                this.requestRepaint();
                break;
            }
            case 37: 
            case 38: {
                --this.selectedIndex;
                if (this.selectedIndex < 0) {
                    this.selectedIndex = this.operations.length - 1;
                }
                this.requestRepaint();
                break;
            }
            case 36: {
                this.selectedIndex = 0;
                this.requestRepaint();
                break;
            }
            case 35: {
                this.selectedIndex = this.operations.length - 1;
                this.requestRepaint();
            }
        }
        if (bl) {
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        mouseEvent.consume();
        int n = this.editorPane.viewToModel(mouseEvent.getPoint());
        if (mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 1) {
            if (n < 0) {
                return;
            }
            if (this.mousedIndex != -1) {
                this.selectedIndex = this.mousedIndex;
                this.performAction = true;
                this.release();
                return;
            }
        }
        try {
            int n2 = Utilities.getLineOffset((BaseDocument)((BaseDocument)this.doc), (int)n) + 1;
            if (n2 < this.startLine || n2 > this.endLine) {
                this.release();
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        mouseEvent.consume();
        int n = this.editorPane.viewToModel(mouseEvent.getPoint());
        int n2 = -1;
        if (n >= 0) {
            for (int i = 0; i < this.operations.length; ++i) {
                int n3 = this.operations[i].getMethodStartPosition().getOffset();
                int n4 = this.operations[i].getMethodEndPosition().getOffset();
                if (n < n3 || n > n4) continue;
                n2 = i;
                break;
            }
        }
        if (n2 != this.mousedIndex) {
            if (n2 == -1) {
                this.editorPane.setCursor(this.arrowCursor);
            } else {
                this.editorPane.setCursor(this.handCursor);
            }
            this.mousedIndex = n2;
            this.requestRepaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.editorPane.getCaret().setVisible(false);
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.debugger.getState() == 4 || this.currentThread != this.debugger.getCurrentThread() || !this.currentThread.isSuspended()) {
            this.release();
        }
    }

    private static final class OperatorsComparator
    implements Comparator {
        private OperatorsComparator() {
        }

        public int compare(Object object, Object object2) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            EditorContext.Operation operation = (EditorContext.Operation)objectArray[0];
            EditorContext.Operation operation2 = (EditorContext.Operation)objectArray2[0];
            return operation.getMethodStartPosition().getOffset() - operation2.getMethodStartPosition().getOffset();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TooltipResolver
    implements HighlightAttributeValue<String> {
        public String getValue(JTextComponent jTextComponent, Document document, Object object, int n, int n2) {
            return NbBundle.getMessage(MethodChooser.class, (String)"MSG_Step_Into_Method");
        }
    }
}

