/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.InvalidRequestStateException;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AbstractDICookie;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.ListeningDICookie;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.modules.debugger.jpda.ClassTypeList;
import org.netbeans.modules.debugger.jpda.DeadlockDetectorImpl;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDAStepImpl;
import org.netbeans.modules.debugger.jpda.JSR45DebuggerEngineProvider;
import org.netbeans.modules.debugger.jpda.JavaEngineProvider;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.ThreadsCollectorImpl;
import org.netbeans.modules.debugger.jpda.actions.CompoundSmartSteppingListener;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsEngineListener;
import org.netbeans.modules.debugger.jpda.expr.EvaluatorExpression;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.expr.TreeEvaluator;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IntegerValueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.LocalsTreeModel;
import org.netbeans.modules.debugger.jpda.models.ObjectTranslation;
import org.netbeans.modules.debugger.jpda.models.ThreadsCache;
import org.netbeans.modules.debugger.jpda.util.JPDAUtils;
import org.netbeans.modules.debugger.jpda.util.Operator;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.debugger.DelegatingSessionProvider;
import org.netbeans.spi.viewmodel.TreeModel;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPDADebuggerImpl
extends JPDADebugger {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda");
    private static final boolean SINGLE_THREAD_STEPPING = !Boolean.getBoolean("netbeans.debugger.multiThreadStepping");
    private VirtualMachine virtualMachine = null;
    private final Object virtualMachineLock = new Object();
    private Exception exception;
    private int state = 0;
    private final Object stateLock = new Object();
    private Operator operator;
    private PropertyChangeSupport pcs;
    public PropertyChangeSupport varChangeSupport = new PropertyChangeSupport((Object)this);
    private JPDAThreadImpl currentThread;
    private CallStackFrame currentCallStackFrame;
    private final Object currentThreadAndFrameLock = new Object();
    private int suspend = SINGLE_THREAD_STEPPING ? 1 : 2;
    public final ReentrantReadWriteLock accessLock = new DebuggerReentrantReadWriteLock(false);
    private final Object LOCK2 = new Object();
    private boolean starting;
    private AbstractDICookie attachingCookie;
    private JavaEngineProvider javaEngineProvider;
    private Set<String> languages;
    private String lastStratumn;
    private ContextProvider lookupProvider;
    private ObjectTranslation threadsTranslation;
    private ObjectTranslation localsTranslation;
    private ExpressionPool expressionPool;
    private ThreadsCache threadsCache;
    private DeadlockDetector deadlockDetector;
    private ThreadsCollectorImpl threadsCollector;
    private final Object threadsCollectorLock = new Object();
    private final Map<Long, String> markedObjects = new LinkedHashMap<Long, String>();
    private final Map<String, ObjectVariable> markedObjectLabels = new LinkedHashMap<String, ObjectVariable>();
    private StackFrame altCSF = null;
    private boolean doContinue = true;
    private Boolean singleThreadStepResumeDecision = null;
    private Boolean stepInterruptByBptResumeDecision = null;
    private Boolean canBeModified;
    private Object canBeModifiedLock = new Object();
    private SmartSteppingFilter smartSteppingFilter;
    CompoundSmartSteppingListener compoundSmartSteppingListener;
    InvalidExpressionException methodCallsUnsupportedExc;
    private boolean finishing;
    private static final Pattern jvmVersionPattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(_\\d+)?(-\\w+)?");
    private static Method tcGenericSignatureMethod;
    private static Method lvGenericSignatureMethod;
    private SourcePath engineContext;
    private LocalsTreeModel localsTreeModel;
    private Set<JSR45DebuggerEngineProvider> jsr45EngineProviders;

    public JPDADebuggerImpl(ContextProvider contextProvider) {
        this.lookupProvider = contextProvider;
        Properties properties = Properties.getDefault().getProperties("debugger.options.JPDA");
        this.suspend = properties.getInt("StepResume", this.suspend);
        this.pcs = new PropertyChangeSupport((Object)this);
        List list = contextProvider.lookup(null, DebuggerEngineProvider.class);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!(list.get(i) instanceof JavaEngineProvider)) continue;
            this.javaEngineProvider = (JavaEngineProvider)((Object)list.get(i));
        }
        if (this.javaEngineProvider == null) {
            throw new IllegalArgumentException("JavaEngineProvider have to be used to start JPDADebugger!");
        }
        this.languages = new HashSet<String>();
        this.languages.add("Java");
        this.threadsTranslation = ObjectTranslation.createThreadTranslation(this);
        this.localsTranslation = ObjectTranslation.createLocalsTranslation(this);
        this.expressionPool = new ExpressionPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSuspend() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.suspend;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuspend(int n) {
        int n2;
        Object object = this.stateLock;
        synchronized (object) {
            if (n == this.suspend) {
                return;
            }
            n2 = this.suspend;
            this.suspend = n;
        }
        this.firePropertyChange("suspend", n2, n);
    }

    public JPDAThread getCurrentThread() {
        return this.currentThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallStackFrame getCurrentCallStackFrame() {
        Object object = this.currentThreadAndFrameLock;
        synchronized (object) {
            return this.currentCallStackFrame;
        }
    }

    public Variable evaluate(String string) throws InvalidExpressionException {
        return this.evaluate(string, null, null);
    }

    public Variable evaluate(String string, ObjectVariable objectVariable) throws InvalidExpressionException {
        return this.evaluate(string, null, objectVariable);
    }

    public Variable evaluate(String string, CallStackFrame callStackFrame) throws InvalidExpressionException {
        return this.evaluate(string, callStackFrame, null);
    }

    public Variable evaluate(String string, CallStackFrame callStackFrame, ObjectVariable objectVariable) throws InvalidExpressionException {
        return this.evaluateGeneric(new EvaluatorExpression(string), callStackFrame, objectVariable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitRunning() throws DebuggerStartException {
        Object object = this.LOCK2;
        synchronized (object) {
            int n = this.getState();
            if (n == 4) {
                if (this.exception != null) {
                    throw new DebuggerStartException((Throwable)this.exception);
                }
                return;
            }
            if (!this.starting && n != 1 || this.exception != null) {
                return;
            }
            try {
                logger.fine("JPDADebuggerImpl.waitRunning(): starting = " + this.starting + ", state = " + n + ", exception = " + this.exception);
                this.LOCK2.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new DebuggerStartException((Throwable)interruptedException);
            }
            if (this.exception != null) {
                throw new DebuggerStartException((Throwable)this.exception);
            }
            return;
        }
    }

    public boolean canPopFrames() {
        VirtualMachine virtualMachine = this.getVirtualMachine();
        if (virtualMachine == null) {
            return false;
        }
        return VirtualMachineWrapper.canPopFrames0(virtualMachine);
    }

    public boolean canFixClasses() {
        VirtualMachine virtualMachine = this.getVirtualMachine();
        if (virtualMachine == null) {
            return false;
        }
        return VirtualMachineWrapper.canRedefineClasses0(virtualMachine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void fixClasses(Map<String, byte[]> map) {
        block18: {
            String string;
            JPDAThread jPDAThread;
            block19: {
                VirtualMachine virtualMachine;
                Iterator<Map.Entry<String, byte[]>> iterator;
                HashMap<ReferenceType, byte[]> hashMap;
                block17: {
                    this.accessLock.writeLock().lock();
                    hashMap = new HashMap<ReferenceType, byte[]>();
                    iterator = map.entrySet().iterator();
                    virtualMachine = this.getVirtualMachine();
                    if (virtualMachine != null) break block17;
                    this.accessLock.writeLock().unlock();
                    return;
                }
                try {
                    while (iterator.hasNext()) {
                        jPDAThread = iterator.next();
                        string = (String)jPDAThread.getKey();
                        byte[] byArray = (byte[])jPDAThread.getValue();
                        List<ReferenceType> list = VirtualMachineWrapper.classesByName(virtualMachine, string);
                        int n = list.size();
                        for (int i = 0; i < n; ++i) {
                            hashMap.put(list.get(i), byArray);
                        }
                    }
                    VirtualMachineWrapper.redefineClasses(virtualMachine, hashMap);
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    // empty catch block
                }
                this.fixBreakpoints();
                jPDAThread = this.getCurrentThread();
                if (jPDAThread == null || !jPDAThread.isSuspended()) break block18;
                if (jPDAThread.getStackDepth() >= 2) break block19;
                this.accessLock.writeLock().unlock();
                return;
            }
            try {
                string = jPDAThread.getCallStack(0, 1)[0];
            }
            catch (AbsentInformationException absentInformationException) {
                this.accessLock.writeLock().unlock();
                return;
            }
            try {
                if (string.isObsolete() && ((CallStackFrameImpl)((Object)string)).canPop()) {
                    string.popFrame();
                    this.setState(2);
                    this.updateCurrentCallStackFrame(jPDAThread);
                    this.setState(3);
                }
                break block18;
                {
                    catch (InvalidStackFrameException invalidStackFrameException) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.accessLock.writeLock().unlock();
            }
        }
    }

    public void fixBreakpoints() {
        Session session = this.getSession();
        DebuggerEngine debuggerEngine = session.getEngineForLanguage("Java");
        BreakpointsEngineListener breakpointsEngineListener = null;
        List list = debuggerEngine.lookup(null, LazyActionsManagerListener.class);
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (!(e instanceof BreakpointsEngineListener)) continue;
            breakpointsEngineListener = (BreakpointsEngineListener)e;
            break;
        }
        EditorContextBridge.getContext().disposeTimeStamp((Object)this);
        EditorContextBridge.getContext().createTimeStamp((Object)this);
        if (breakpointsEngineListener != null) {
            breakpointsEngineListener.fixBreakpointImpls();
        }
    }

    public Session getSession() {
        return (Session)this.lookupProvider.lookupFirst(null, Session.class);
    }

    public RequestProcessor getRequestProcessor() {
        return this.javaEngineProvider.getRequestProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canBeModified() {
        VirtualMachine virtualMachine = this.getVirtualMachine();
        if (virtualMachine == null) {
            return false;
        }
        Object object = this.canBeModifiedLock;
        synchronized (object) {
            if (this.canBeModified == null) {
                try {
                    Method method = VirtualMachine.class.getMethod("canBeModified", new Class[0]);
                    Object object2 = method.invoke((Object)virtualMachine, new Object[0]);
                    this.canBeModified = (Boolean)object2;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.canBeModified = Boolean.TRUE;
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.canBeModified = Boolean.TRUE;
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.canBeModified = Boolean.TRUE;
                }
            }
            return this.canBeModified;
        }
    }

    public SmartSteppingFilter getSmartSteppingFilter() {
        if (this.smartSteppingFilter == null) {
            this.smartSteppingFilter = (SmartSteppingFilter)this.lookupProvider.lookupFirst(null, SmartSteppingFilter.class);
        }
        return this.smartSteppingFilter;
    }

    private CompoundSmartSteppingListener getCompoundSmartSteppingListener() {
        if (this.compoundSmartSteppingListener == null) {
            this.compoundSmartSteppingListener = (CompoundSmartSteppingListener)((Object)this.lookupProvider.lookupFirst(null, CompoundSmartSteppingListener.class));
        }
        return this.compoundSmartSteppingListener;
    }

    boolean stopHere(JPDAThread jPDAThread) {
        return this.getCompoundSmartSteppingListener().stopHere(this.lookupProvider, jPDAThread, this.getSmartSteppingFilter());
    }

    public void fireBreakpointEvent(JPDABreakpoint jPDABreakpoint, JPDABreakpointEvent jPDABreakpointEvent) {
        super.fireBreakpointEvent(jPDABreakpoint, jPDABreakpointEvent);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popFrames(ThreadReference threadReference, StackFrame stackFrame) {
        this.accessLock.readLock().lock();
        try {
            JPDAThreadImpl jPDAThreadImpl = this.getThread(threadReference);
            this.setState(2);
            try {
                jPDAThreadImpl.popFrames(stackFrame);
                this.updateCurrentCallStackFrame(jPDAThreadImpl);
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                ErrorManager.getDefault().notify((Throwable)incompatibleThreadStateException);
            }
            finally {
                this.setState(3);
            }
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setException(Exception exception) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JPDADebuggerImpl.setException(" + exception + ")");
        }
        Object object = this.LOCK2;
        synchronized (object) {
            this.exception = exception;
            this.starting = false;
            this.LOCK2.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentThread(JPDAThread jPDAThread) {
        PropertyChangeEvent propertyChangeEvent;
        JPDAThreadImpl jPDAThreadImpl;
        CallStackFrame callStackFrame = this.getTopFrame(jPDAThread);
        Object object = this.currentThreadAndFrameLock;
        synchronized (object) {
            jPDAThreadImpl = this.currentThread;
            this.currentThread = (JPDAThreadImpl)jPDAThread;
            propertyChangeEvent = this.updateCurrentCallStackFrameNoFire(callStackFrame);
        }
        if (jPDAThread != jPDAThreadImpl) {
            this.firePropertyChange("currentThread", jPDAThreadImpl, jPDAThread);
        }
        if (propertyChangeEvent != null) {
            this.firePropertyChange(propertyChangeEvent);
        }
        this.setState(jPDAThread.isSuspended() ? 3 : 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyChangeEvent setCurrentThreadNoFire(JPDAThread jPDAThread) {
        PropertyChangeEvent propertyChangeEvent;
        JPDAThreadImpl jPDAThreadImpl;
        PropertyChangeEvent propertyChangeEvent2 = null;
        CallStackFrame callStackFrame = this.getTopFrame(jPDAThread);
        Object object = this.currentThreadAndFrameLock;
        synchronized (object) {
            jPDAThreadImpl = this.currentThread;
            this.currentThread = (JPDAThreadImpl)jPDAThread;
            propertyChangeEvent = this.updateCurrentCallStackFrameNoFire(callStackFrame);
        }
        if (jPDAThread != jPDAThreadImpl) {
            propertyChangeEvent2 = new PropertyChangeEvent((Object)this, "currentThread", jPDAThreadImpl, jPDAThread);
        }
        if (propertyChangeEvent2 == null) {
            propertyChangeEvent2 = propertyChangeEvent;
        } else if (propertyChangeEvent != null) {
            propertyChangeEvent2.setPropagationId(propertyChangeEvent);
        }
        return propertyChangeEvent2;
    }

    public void setCurrentCallStackFrame(CallStackFrame callStackFrame) {
        CallStackFrame callStackFrame2 = this.setCurrentCallStackFrameNoFire(callStackFrame);
        if (callStackFrame2 == callStackFrame) {
            return;
        }
        this.firePropertyChange("currentCallStackFrame", callStackFrame2, callStackFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallStackFrame setCurrentCallStackFrameNoFire(CallStackFrame callStackFrame) {
        CallStackFrame callStackFrame2;
        Object object = this.currentThreadAndFrameLock;
        synchronized (object) {
            if (callStackFrame == this.currentCallStackFrame) {
                return callStackFrame;
            }
            callStackFrame2 = this.currentCallStackFrame;
            this.currentCallStackFrame = callStackFrame;
        }
        return callStackFrame2;
    }

    public Value evaluateIn(String string) throws InvalidExpressionException {
        return this.evaluateIn(new EvaluatorExpression(string), null);
    }

    public Value evaluateIn(EvaluatorExpression evaluatorExpression, CallStackFrame callStackFrame) throws InvalidExpressionException {
        return this.evaluateIn(evaluatorExpression, callStackFrame, null);
    }

    private Value evaluateIn(EvaluatorExpression evaluatorExpression, CallStackFrame callStackFrame, ObjectVariable objectVariable) throws InvalidExpressionException {
        Variable variable = this.evaluateGeneric(evaluatorExpression, callStackFrame, objectVariable);
        if (variable instanceof JDIVariable) {
            return ((JDIVariable)variable).getJDIValue();
        }
        return null;
    }

    public void setAltCSF(StackFrame stackFrame) {
        this.altCSF = stackFrame;
    }

    public StackFrame getAltCSF() {
        return this.altCSF;
    }

    public Value evaluateIn(EvaluatorExpression evaluatorExpression) throws InvalidExpressionException {
        return this.evaluateIn(evaluatorExpression, null, null);
    }

    /*
     * Exception decompiling
     */
    private Variable evaluateGeneric(EvaluatorExpression var1_1, CallStackFrame var2_2, ObjectVariable var3_3) throws InvalidExpressionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Value invokeMethod(ObjectReference objectReference, com.sun.jdi.Method method, Value[] valueArray) throws InvalidExpressionException {
        return this.invokeMethod(null, objectReference, method, valueArray, 0);
    }

    public Value invokeMethod(ObjectReference objectReference, com.sun.jdi.Method method, Value[] valueArray, int n) throws InvalidExpressionException {
        return this.invokeMethod(null, objectReference, method, valueArray, n);
    }

    public Value invokeMethod(JPDAThreadImpl jPDAThreadImpl, ObjectReference objectReference, com.sun.jdi.Method method, Value[] valueArray) throws InvalidExpressionException {
        return this.invokeMethod(jPDAThreadImpl, objectReference, method, valueArray, 0);
    }

    /*
     * Exception decompiling
     */
    private Value invokeMethod(JPDAThreadImpl var1_1, ObjectReference var2_2, com.sun.jdi.Method var3_3, Value[] var4_4, int var5_5) throws InvalidExpressionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Value cutLength(StringReference stringReference, int n, ThreadReference threadReference) throws InvalidExpressionException {
        try {
            com.sun.jdi.Method method;
            com.sun.jdi.Method method2 = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(stringReference), "length", "()I");
            List<Value> list = Collections.emptyList();
            IntegerValue integerValue = (IntegerValue)TreeEvaluator.invokeVirtual(stringReference, method2, threadReference, list, this);
            if (IntegerValueWrapper.value(integerValue) > n && (method = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(stringReference), "substring", "(II)Ljava/lang/String;")) != null) {
                stringReference = (StringReference)TreeEvaluator.invokeVirtual(stringReference, method, threadReference, Arrays.asList(VirtualMachineWrapper.mirrorOf(MirrorWrapper.virtualMachine(stringReference), 0), VirtualMachineWrapper.mirrorOf(MirrorWrapper.virtualMachine(stringReference), n)), this);
            }
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
            // empty catch block
        }
        return stringReference;
    }

    public static String getGenericSignature(TypeComponent typeComponent) {
        if (tcGenericSignatureMethod == null) {
            return null;
        }
        try {
            return (String)tcGenericSignatureMethod.invoke((Object)typeComponent, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            return null;
        }
    }

    public static String getGenericSignature(LocalVariable localVariable) {
        if (lvGenericSignatureMethod == null) {
            return null;
        }
        try {
            return (String)lvGenericSignatureMethod.invoke((Object)localVariable, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualMachine getVirtualMachine() {
        Object object = this.virtualMachineLock;
        synchronized (object) {
            return this.virtualMachine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operator getOperator() {
        Object object = this.virtualMachineLock;
        synchronized (object) {
            return this.operator;
        }
    }

    public void setStarting() {
        this.setState(1);
    }

    public synchronized void setAttaching(AbstractDICookie abstractDICookie) {
        this.attachingCookie = abstractDICookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(VirtualMachine virtualMachine, Operator operator) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Start - JPDADebuggerImpl.setRunning ()");
            JPDAUtils.printFeatures(logger, virtualMachine);
        }
        Object object = this.LOCK2;
        synchronized (object) {
            this.starting = true;
        }
        object = this.virtualMachineLock;
        synchronized (object) {
            this.virtualMachine = virtualMachine;
            this.operator = operator;
        }
        object = this.canBeModifiedLock;
        synchronized (object) {
            this.canBeModified = null;
        }
        this.initGenericsSupport();
        EditorContextBridge.getContext().createTimeStamp((Object)this);
        object = this.threadsCollectorLock;
        synchronized (object) {
            if (this.threadsCache != null) {
                this.threadsCache.setVirtualMachine(virtualMachine);
            }
        }
        this.setState(2);
        object = this.virtualMachineLock;
        synchronized (object) {
            virtualMachine = this.virtualMachine;
        }
        if (virtualMachine != null) {
            this.notifyToBeResumedAll();
            this.accessLock.writeLock().lock();
            try {
                VirtualMachineWrapper.resume(virtualMachine);
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
            }
            finally {
                this.accessLock.writeLock().unlock();
            }
        }
        logger.fine("   JPDADebuggerImpl.setRunning () finished, VM resumed.");
        object = this.LOCK2;
        synchronized (object) {
            this.starting = false;
            this.LOCK2.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStoppedState(ThreadReference threadReference, boolean bl) {
        PropertyChangeEvent propertyChangeEvent;
        this.accessLock.readLock().lock();
        try {
            JPDAThread jPDAThread = this.getCurrentThread();
            JPDAThreadImpl jPDAThreadImpl = this.getThread(threadReference);
            if (!bl && jPDAThread != null && jPDAThread != jPDAThreadImpl && jPDAThread.isSuspended()) {
                return;
            }
            this.checkJSR45Languages(jPDAThreadImpl);
            propertyChangeEvent = this.setCurrentThreadNoFire(jPDAThreadImpl);
            PropertyChangeEvent propertyChangeEvent2 = this.setStateNoFire(3);
            if (propertyChangeEvent == null) {
                propertyChangeEvent = propertyChangeEvent2;
            } else if (propertyChangeEvent2 != null) {
                PropertyChangeEvent propertyChangeEvent3 = propertyChangeEvent;
                while (propertyChangeEvent3.getPropagationId() != null) {
                    propertyChangeEvent3 = (PropertyChangeEvent)propertyChangeEvent3.getPropagationId();
                }
                propertyChangeEvent3.setPropagationId(propertyChangeEvent2);
            }
        }
        finally {
            this.accessLock.readLock().unlock();
        }
        if (propertyChangeEvent != null) {
            do {
                this.firePropertyChange(propertyChangeEvent);
            } while ((propertyChangeEvent = (PropertyChangeEvent)propertyChangeEvent.getPropagationId()) != null);
        }
    }

    public void setRunningState() {
        this.setState(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStoppedStateNoContinue(ThreadReference threadReference) {
        PropertyChangeEvent propertyChangeEvent;
        this.accessLock.readLock().lock();
        try {
            propertyChangeEvent = this.setStateNoFire(2);
            JPDAThreadImpl jPDAThreadImpl = this.getThread(threadReference);
            this.checkJSR45Languages(jPDAThreadImpl);
            PropertyChangeEvent propertyChangeEvent2 = this.setCurrentThreadNoFire(jPDAThreadImpl);
            if (propertyChangeEvent == null) {
                propertyChangeEvent = propertyChangeEvent2;
            } else if (propertyChangeEvent2 != null) {
                propertyChangeEvent.setPropagationId(propertyChangeEvent2);
            }
            propertyChangeEvent2 = this.setStateNoFire(3);
            if (propertyChangeEvent == null) {
                propertyChangeEvent = propertyChangeEvent2;
            } else if (propertyChangeEvent2 != null) {
                PropertyChangeEvent propertyChangeEvent3 = propertyChangeEvent;
                while (propertyChangeEvent3.getPropagationId() != null) {
                    propertyChangeEvent3 = (PropertyChangeEvent)propertyChangeEvent3.getPropagationId();
                }
                propertyChangeEvent3.setPropagationId(propertyChangeEvent2);
            }
            this.doContinue = false;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
        if (propertyChangeEvent != null) {
            do {
                this.firePropertyChange(propertyChangeEvent);
            } while ((propertyChangeEvent = (PropertyChangeEvent)propertyChangeEvent.getPropagationId()) != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        try {
            Object object;
            block42: {
                Object object2;
                Object object3;
                JPDADebuggerImpl jPDADebuggerImpl = this;
                synchronized (jPDADebuggerImpl) {
                    block41: {
                        if (!this.finishing) break block41;
                        return;
                    }
                    this.finishing = true;
                }
                logger.fine("StartActionProvider.finish ()");
                if (this.getState() == 4) {
                    return;
                }
                jPDADebuggerImpl = (AbstractDICookie)this.lookupProvider.lookupFirst(null, AbstractDICookie.class);
                Operator operator = this.getOperator();
                if (operator != null) {
                    operator.stop();
                }
                Object object4 = this;
                synchronized (object4) {
                    if (this.attachingCookie != null && this.attachingCookie instanceof ListeningDICookie) {
                        object3 = (ListeningDICookie)this.attachingCookie;
                        try {
                            object3.getListeningConnector().stopListening(object3.getArgs());
                        }
                        catch (IOException iOException) {
                        }
                        catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
                try {
                    this.waitRunning();
                }
                catch (DebuggerStartException debuggerStartException) {
                    // empty catch block
                }
                object3 = this.virtualMachineLock;
                synchronized (object3) {
                    object4 = this.virtualMachine;
                    this.virtualMachine = null;
                }
                this.setState(4);
                if (this.jsr45EngineProviders != null) {
                    object3 = this.jsr45EngineProviders.iterator();
                    while (object3.hasNext()) {
                        object = (JSR45DebuggerEngineProvider)((Object)object3.next());
                        object2 = object.getDesctuctor();
                        if (object2 == null) continue;
                        object2.killEngine();
                    }
                    this.jsr45EngineProviders = null;
                }
                if ((object3 = this.javaEngineProvider.getDestructor()) != null) {
                    object3.killEngine();
                }
                if (object4 != null) {
                    try {
                        if (jPDADebuggerImpl instanceof AttachingDICookie) {
                            object2 = this.currentThreadAndFrameLock;
                            synchronized (object2) {
                                object = this.currentThread;
                            }
                            if (object != null && ((JPDAThreadImpl)object).isMethodInvoking()) {
                                try {
                                    ((JPDAThreadImpl)object).waitUntilMethodInvokeDone(5000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            logger.fine(" StartActionProvider.finish() VM dispose");
                            VirtualMachineWrapper.dispose((VirtualMachine)object4);
                            break block42;
                        }
                        logger.fine(" StartActionProvider.finish() VM exit");
                        VirtualMachineWrapper.exit((VirtualMachine)object4, 0);
                    }
                    catch (InternalExceptionWrapper internalExceptionWrapper) {
                        logger.fine(" StartActionProvider.finish() VM exception " + internalExceptionWrapper);
                    }
                    catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                        logger.fine(" StartActionProvider.finish() VM exception " + vMDisconnectedExceptionWrapper);
                    }
                }
            }
            logger.fine(" StartActionProvider.finish() end.");
            object = this.LOCK2;
            synchronized (object) {
                this.starting = false;
                this.LOCK2.notifyAll();
            }
            EditorContextBridge.getContext().disposeTimeStamp((Object)this);
        }
        finally {
            this.finishing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        VirtualMachine virtualMachine;
        List<ThreadReference> list = this.virtualMachineLock;
        synchronized (list) {
            virtualMachine = this.virtualMachine;
        }
        this.accessLock.writeLock().lock();
        try {
            if (virtualMachine != null) {
                logger.fine("VM suspend");
                try {
                    VirtualMachineWrapper.suspend(virtualMachine);
                    list = VirtualMachineWrapper.allThreads(virtualMachine);
                    for (ThreadReference threadReference : list) {
                        try {
                            while (ThreadReferenceWrapper.suspendCount(threadReference) > 1) {
                                ThreadReferenceWrapper.resume(threadReference);
                            }
                        }
                        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                        }
                        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                        }
                        catch (InternalExceptionWrapper internalExceptionWrapper) {
                        }
                    }
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    this.accessLock.writeLock().unlock();
                    return;
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                    this.accessLock.writeLock().unlock();
                    return;
                }
            }
            this.setState(3);
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
        this.notifySuspendAll(true, true);
    }

    public List<PropertyChangeEvent> notifySuspendAll(boolean bl, boolean bl2) {
        Collection collection = this.threadsTranslation.getTranslated();
        ArrayList<PropertyChangeEvent> arrayList = new ArrayList<PropertyChangeEvent>(collection.size());
        for (Object e : collection) {
            boolean bl3;
            if (!(e instanceof JPDAThreadImpl)) continue;
            int n = ((JPDAThreadImpl)e).getState();
            boolean bl4 = bl3 = n == 5 || n == -1 || n == 0;
            if (!bl3) {
                try {
                    PropertyChangeEvent propertyChangeEvent = ((JPDAThreadImpl)e).notifySuspended(bl, bl2);
                    if (propertyChangeEvent == null) continue;
                    arrayList.add(propertyChangeEvent);
                }
                catch (ObjectCollectedException objectCollectedException) {
                    bl3 = true;
                }
                continue;
            }
            if (n != -1 && n != 0) continue;
            this.threadsTranslation.remove(((JPDAThreadImpl)e).getThreadReference());
        }
        return arrayList;
    }

    public void notifySuspendAllNoFire() {
        Collection collection = this.threadsTranslation.getTranslated();
        for (Object e : collection) {
            boolean bl;
            if (!(e instanceof JPDAThreadImpl)) continue;
            int n = ((JPDAThreadImpl)e).getState();
            boolean bl2 = bl = n == 5 || n == -1 || n == 0;
            if (!bl) {
                try {
                    ((JPDAThreadImpl)e).notifySuspendedNoFire();
                }
                catch (ObjectCollectedException objectCollectedException) {
                    bl = true;
                }
                continue;
            }
            if (n != -1 && n != 0) continue;
            this.threadsTranslation.remove(((JPDAThreadImpl)e).getThreadReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        VirtualMachine virtualMachine;
        this.accessLock.readLock().lock();
        try {
            if (!this.doContinue) {
                this.doContinue = true;
                return;
            }
        }
        finally {
            this.accessLock.readLock().unlock();
        }
        if (this.operator.flushStaledEvents()) {
            return;
        }
        List<JPDAThread> list = this.virtualMachineLock;
        synchronized (list) {
            virtualMachine = this.virtualMachine;
        }
        if (virtualMachine != null) {
            logger.fine("VM resume");
            list = this.getAllThreads();
            this.accessLock.writeLock().lock();
            logger.finer("Debugger WRITE lock taken.");
            PropertyChangeEvent propertyChangeEvent = this.setStateNoFire(2);
            ArrayList<JPDAThreadImpl> arrayList = new ArrayList<JPDAThreadImpl>();
            for (JPDAThread jPDAThread : list) {
                if (!jPDAThread.isSuspended()) continue;
                arrayList.add((JPDAThreadImpl)jPDAThread);
            }
            try {
                for (int i = 0; i < arrayList.size(); ++i) {
                    JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)arrayList.get(i);
                    boolean bl = jPDAThreadImpl.cleanBeforeResume();
                    if (bl) continue;
                    arrayList.remove(i);
                    --i;
                }
                if (list.size() == arrayList.size()) {
                    VirtualMachineWrapper.resume(virtualMachine);
                    for (JPDAThreadImpl jPDAThreadImpl : arrayList) {
                        jPDAThreadImpl.setAsResumed();
                    }
                    logger.finer("All threads resumed.");
                } else {
                    for (JPDAThreadImpl jPDAThreadImpl : arrayList) {
                        jPDAThreadImpl.resumeAfterClean();
                        jPDAThreadImpl.setAsResumed();
                    }
                }
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                this.accessLock.writeLock().unlock();
                logger.finer("Debugger WRITE lock released.");
                if (propertyChangeEvent != null) {
                    this.firePropertyChange(propertyChangeEvent);
                }
                for (JPDAThreadImpl jPDAThreadImpl : arrayList) {
                    try {
                        jPDAThreadImpl.fireAfterResume();
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (Throwable throwable) {
                        Exceptions.printStackTrace((Throwable)throwable);
                    }
                }
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                this.accessLock.writeLock().unlock();
                logger.finer("Debugger WRITE lock released.");
                if (propertyChangeEvent != null) {
                    this.firePropertyChange(propertyChangeEvent);
                }
                for (JPDAThreadImpl jPDAThreadImpl : arrayList) {
                    try {
                        jPDAThreadImpl.fireAfterResume();
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (Throwable throwable) {
                        Exceptions.printStackTrace((Throwable)throwable);
                    }
                }
            }
            finally {
                this.accessLock.writeLock().unlock();
                logger.finer("Debugger WRITE lock released.");
                if (propertyChangeEvent != null) {
                    this.firePropertyChange(propertyChangeEvent);
                }
                for (JPDAThreadImpl jPDAThreadImpl : arrayList) {
                    try {
                        jPDAThreadImpl.fireAfterResume();
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (Throwable throwable) {
                        Exceptions.printStackTrace((Throwable)throwable);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean currentThreadToBeResumed() {
        this.accessLock.readLock().lock();
        try {
            if (!this.doContinue) {
                this.doContinue = true;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.accessLock.readLock().unlock();
        }
        if (this.operator.flushStaledEvents()) {
            return false;
        }
        this.setState(2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeCurrentThread() {
        this.accessLock.readLock().lock();
        try {
            if (!this.doContinue) {
                this.doContinue = true;
                return;
            }
        }
        finally {
            this.accessLock.readLock().unlock();
        }
        if (this.operator.flushStaledEvents()) {
            return;
        }
        this.setState(2);
        this.currentThread.resume();
    }

    public void notifyToBeResumedAll() {
        Collection collection = this.threadsTranslation.getTranslated();
        for (Object e : collection) {
            boolean bl;
            if (!(e instanceof JPDAThreadImpl)) continue;
            int n = ((JPDAThreadImpl)e).getState();
            boolean bl2 = bl = n == 5 || n == -1 || n == 0;
            if (!bl) {
                ((JPDAThreadImpl)e).notifyToBeResumed();
                continue;
            }
            if (n != -1 && n != 0) continue;
            this.threadsTranslation.remove(((JPDAThreadImpl)e).getThreadReference());
        }
    }

    public void notifyToBeResumedAllNoFire() {
        Collection collection = this.threadsTranslation.getTranslated();
        for (Object e : collection) {
            boolean bl;
            if (!(e instanceof JPDAThreadImpl)) continue;
            int n = ((JPDAThreadImpl)e).getState();
            boolean bl2 = bl = n == 5 || n == -1 || n == 0;
            if (!bl) {
                ((JPDAThreadImpl)e).notifyToBeResumedNoFire();
                continue;
            }
            if (n != -1 && n != 0) continue;
            this.threadsTranslation.remove(((JPDAThreadImpl)e).getThreadReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadsCache getThreadsCache() {
        Object object = this.threadsCollectorLock;
        synchronized (object) {
            if (this.threadsCache == null) {
                this.threadsCache = new ThreadsCache(this);
                this.threadsCache.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        String string = propertyChangeEvent.getPropertyName();
                        if ("threadStarted".equals(string)) {
                            JPDADebuggerImpl.this.firePropertyChange("threadStarted", null, JPDADebuggerImpl.this.getThread((ThreadReference)propertyChangeEvent.getNewValue()));
                        }
                        if ("threadDied".equals(string)) {
                            JPDADebuggerImpl.this.firePropertyChange("threadDied", JPDADebuggerImpl.this.getThread((ThreadReference)propertyChangeEvent.getOldValue()), null);
                        }
                        if ("groupAdded".equals(string)) {
                            JPDADebuggerImpl.this.firePropertyChange("threadGroupAdded", null, JPDADebuggerImpl.this.getThreadGroup((ThreadGroupReference)propertyChangeEvent.getNewValue()));
                        }
                    }
                });
            }
            return this.threadsCache;
        }
    }

    List<JPDAThread> getAllThreads() {
        ThreadsCache threadsCache = this.getThreadsCache();
        if (threadsCache == null) {
            return Collections.emptyList();
        }
        List<ThreadReference> list = threadsCache.getAllThreads();
        int n = list.size();
        ArrayList<JPDAThreadImpl> arrayList = new ArrayList<JPDAThreadImpl>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getThread(list.get(i)));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public JPDAThreadGroup[] getTopLevelThreadGroups() {
        ThreadsCache threadsCache = this.getThreadsCache();
        if (threadsCache == null) {
            return new JPDAThreadGroup[0];
        }
        List<ThreadGroupReference> list = threadsCache.getTopLevelThreadGroups();
        JPDAThreadGroup[] jPDAThreadGroupArray = new JPDAThreadGroup[list.size()];
        for (int i = 0; i < jPDAThreadGroupArray.length; ++i) {
            jPDAThreadGroupArray[i] = this.getThreadGroup(list.get(i));
        }
        return jPDAThreadGroupArray;
    }

    public JPDAThreadImpl getThread(ThreadReference threadReference) {
        return (JPDAThreadImpl)this.threadsTranslation.translate(threadReference);
    }

    public JPDAThreadImpl getExistingThread(ThreadReference threadReference) {
        return (JPDAThreadImpl)this.threadsTranslation.translateExisting(threadReference);
    }

    public JPDAThreadGroup getThreadGroup(ThreadGroupReference threadGroupReference) {
        return (JPDAThreadGroup)this.threadsTranslation.translate(threadGroupReference);
    }

    public Variable getLocalVariable(LocalVariable localVariable, Value value) {
        return (Variable)this.localsTranslation.translate(localVariable, value);
    }

    public JPDAClassType getClassType(ReferenceType referenceType) {
        return (JPDAClassType)this.localsTranslation.translate(referenceType);
    }

    public Variable getVariable(Value value) {
        return this.getLocalsTreeModel().getVariable(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markObject(ObjectVariable objectVariable, String string) {
        Map<Long, String> map = this.markedObjects;
        synchronized (map) {
            long l = objectVariable.getUniqueID();
            String string2 = this.markedObjects.remove(l);
            if (string2 != null) {
                this.markedObjectLabels.remove(string2);
            }
            if (string != null) {
                this.markedObjects.put(l, string);
                ObjectVariable objectVariable2 = this.markedObjectLabels.get(string);
                if (objectVariable2 != null) {
                    this.markedObjects.remove(objectVariable2.getUniqueID());
                }
                this.markedObjectLabels.put(string, objectVariable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLabel(ObjectVariable objectVariable) {
        Map<Long, String> map = this.markedObjects;
        synchronized (map) {
            return this.markedObjects.get(objectVariable.getUniqueID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectVariable getLabeledVariable(String string) {
        Map<Long, String> map = this.markedObjects;
        synchronized (map) {
            return this.markedObjectLabels.get(string);
        }
    }

    public ExpressionPool getExpressionPool() {
        return this.expressionPool;
    }

    synchronized void setSingleThreadStepResumeDecision(Boolean bl) {
        this.singleThreadStepResumeDecision = bl;
    }

    synchronized Boolean getSingleThreadStepResumeDecision() {
        return this.singleThreadStepResumeDecision;
    }

    public synchronized void setStepInterruptByBptResumeDecision(Boolean bl) {
        this.stepInterruptByBptResumeDecision = bl;
    }

    public synchronized Boolean getStepInterruptByBptResumeDecision() {
        return this.stepInterruptByBptResumeDecision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initGenericsSupport() {
        tcGenericSignatureMethod = null;
        if (Bootstrap.virtualMachineManager().minorInterfaceVersion() >= 5) {
            VirtualMachine virtualMachine;
            Object object = this.virtualMachineLock;
            synchronized (object) {
                virtualMachine = this.virtualMachine;
            }
            if (virtualMachine == null) {
                return;
            }
            try {
                int n;
                object = jvmVersionPattern.matcher(VirtualMachineWrapper.version(virtualMachine));
                if (((Matcher)object).matches() && (n = Integer.parseInt(((Matcher)object).group(2))) >= 5) {
                    try {
                        tcGenericSignatureMethod = TypeComponent.class.getMethod("genericSignature", new Class[0]);
                        lvGenericSignatureMethod = LocalVariable.class.getMethod("genericSignature", new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyChangeEvent setStateNoFire(int n) {
        int n2;
        Object object = this.stateLock;
        synchronized (object) {
            if (n == this.state) {
                return null;
            }
            n2 = this.state;
            this.state = n;
        }
        System.setProperty("org.openide.awt.SwingBrowserImpl.do-not-block-awt", String.valueOf(n != 4));
        return new PropertyChangeEvent((Object)this, "state", new Integer(n2), new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int n) {
        Object object;
        if (n == 2) {
            object = this.currentThreadAndFrameLock;
            synchronized (object) {
                this.currentCallStackFrame = null;
            }
        }
        if ((object = this.setStateNoFire(n)) != null) {
            this.firePropertyChange((PropertyChangeEvent)object);
        }
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    private void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.pcs.firePropertyChange(propertyChangeEvent);
    }

    public synchronized SourcePath getEngineContext() {
        if (this.engineContext == null) {
            this.engineContext = (SourcePath)this.lookupProvider.lookupFirst(null, SourcePath.class);
        }
        return this.engineContext;
    }

    private LocalsTreeModel getLocalsTreeModel() {
        if (this.localsTreeModel == null) {
            this.localsTreeModel = (LocalsTreeModel)this.lookupProvider.lookupFirst("LocalsView", TreeModel.class);
        }
        return this.localsTreeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadReference getEvaluationThread() {
        Object object = this.currentThreadAndFrameLock;
        synchronized (object) {
            if (this.currentThread != null) {
                return this.currentThread.getThreadReference();
            }
        }
        List<ThreadReference> list = this.virtualMachineLock;
        synchronized (list) {
            object = this.virtualMachine;
        }
        if (object == null) {
            return null;
        }
        try {
            list = VirtualMachineWrapper.allThreads((VirtualMachine)object);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
        if (list.size() < 1) {
            return null;
        }
        int n = list.size();
        ThreadReference threadReference = null;
        for (int i = 0; i < n; ++i) {
            ThreadReference threadReference2 = list.get(i);
            try {
                if (!ThreadReferenceWrapper.isSuspended(threadReference2)) continue;
                threadReference = threadReference2;
                if (!ThreadReferenceWrapper.name(threadReference2).equals("Finalizer")) continue;
                return threadReference2;
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                continue;
            }
            catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                continue;
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                continue;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                // empty catch block
            }
        }
        return threadReference;
    }

    private void updateCurrentCallStackFrame(JPDAThread jPDAThread) {
        if (jPDAThread == null || jPDAThread.getStackDepth() < 1) {
            this.setCurrentCallStackFrame(null);
        } else {
            try {
                this.setCurrentCallStackFrame(jPDAThread.getCallStack(0, 1)[0]);
            }
            catch (AbsentInformationException absentInformationException) {
                this.setCurrentCallStackFrame(null);
            }
        }
    }

    private CallStackFrame getTopFrame(JPDAThread jPDAThread) {
        CallStackFrame callStackFrame;
        if (jPDAThread == null || jPDAThread.getStackDepth() < 1) {
            callStackFrame = null;
        } else {
            try {
                callStackFrame = jPDAThread.getCallStack(0, 1)[0];
            }
            catch (AbsentInformationException absentInformationException) {
                callStackFrame = null;
            }
        }
        return callStackFrame;
    }

    private PropertyChangeEvent updateCurrentCallStackFrameNoFire(CallStackFrame callStackFrame) {
        CallStackFrame callStackFrame2 = this.setCurrentCallStackFrameNoFire(callStackFrame);
        if (callStackFrame2 == callStackFrame) {
            return null;
        }
        return new PropertyChangeEvent((Object)this, "currentCallStackFrame", callStackFrame2, callStackFrame);
    }

    private List<EventRequest> disableAllBreakpoints() throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        logger.fine("disableAllBreakpoints() start.");
        ArrayList<EventRequest> arrayList = new ArrayList<EventRequest>();
        VirtualMachine virtualMachine = this.getVirtualMachine();
        if (virtualMachine == null) {
            return arrayList;
        }
        EventRequestManager eventRequestManager = VirtualMachineWrapper.eventRequestManager(virtualMachine);
        arrayList.addAll(EventRequestManagerWrapper.accessWatchpointRequests(eventRequestManager));
        arrayList.addAll(EventRequestManagerWrapper.breakpointRequests(eventRequestManager));
        arrayList.addAll(EventRequestManagerWrapper.classPrepareRequests(eventRequestManager));
        arrayList.addAll(EventRequestManagerWrapper.classUnloadRequests(eventRequestManager));
        arrayList.addAll(EventRequestManagerWrapper.exceptionRequests(eventRequestManager));
        arrayList.addAll(EventRequestManagerWrapper.methodEntryRequests(eventRequestManager));
        arrayList.addAll(EventRequestManagerWrapper.methodExitRequests(eventRequestManager));
        arrayList.addAll(EventRequestManagerWrapper.modificationWatchpointRequests(eventRequestManager));
        arrayList.addAll(EventRequestManagerWrapper.threadDeathRequests(eventRequestManager));
        arrayList.addAll(EventRequestManagerWrapper.threadStartRequests(eventRequestManager));
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            if (!EventRequestWrapper.isEnabled((EventRequest)arrayList.get(i))) {
                arrayList.remove(i);
                continue;
            }
            EventRequestWrapper.disable((EventRequest)arrayList.get(i));
        }
        this.operator.breakpointsDisabled();
        logger.fine("disableAllBreakpoints() end.");
        return arrayList;
    }

    private void enableAllBreakpoints(List<EventRequest> list) {
        logger.fine("enableAllBreakpoints() start.");
        this.operator.breakpointsEnabled();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            try {
                EventRequestWrapper.enable(list.get(i));
                continue;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                continue;
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                continue;
            }
            catch (InvalidRequestStateException invalidRequestStateException) {
                continue;
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                continue;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return;
            }
        }
        logger.fine("enableAllBreakpoints() end.");
    }

    private void checkJSR45Languages(JPDAThread jPDAThread) {
        if (jPDAThread.getStackDepth() > 0) {
            try {
                String string;
                String string2;
                int n;
                CallStackFrame[] callStackFrameArray = jPDAThread.getCallStack(0, 1);
                if (callStackFrameArray.length < 1) {
                    return;
                }
                CallStackFrame callStackFrame = callStackFrameArray[0];
                List<String> list = callStackFrame.getAvailableStrata();
                String string3 = callStackFrame.getDefaultStratum();
                if (list.size() == 1 && "Java".equals(list.get(0)) && (n = (string2 = callStackFrame.getSourceName(null)).lastIndexOf(46)) > 0) {
                    string = string2.substring(++n);
                    if (!"JAVA".equals(string = string.toUpperCase())) {
                        list = Collections.singletonList(string);
                        string3 = string;
                    }
                }
                n = list.size();
                for (int i = 0; i < n; ++i) {
                    if (this.languages.contains(list.get(i))) continue;
                    string = (String)list.get(i);
                    DebuggerManager.getDebuggerManager().startDebugging(this.createJSR45DI(string));
                    this.languages.add(string);
                }
                if (string3 != null && !string3.equals(this.lastStratumn)) {
                    this.javaEngineProvider.getSession().setCurrentLanguage(string3);
                }
                this.lastStratumn = string3;
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }
    }

    private DebuggerInfo createJSR45DI(String string) {
        if (this.jsr45EngineProviders == null) {
            this.jsr45EngineProviders = new HashSet<JSR45DebuggerEngineProvider>(1);
        }
        JSR45DebuggerEngineProvider jSR45DebuggerEngineProvider = new JSR45DebuggerEngineProvider(string);
        this.jsr45EngineProviders.add(jSR45DebuggerEngineProvider);
        return DebuggerInfo.create((String)("netbeans-jpda-JSR45DICookie-" + string), (Object[])new Object[]{new DelegatingSessionProvider(){

            public Session getSession(DebuggerInfo debuggerInfo) {
                return JPDADebuggerImpl.this.javaEngineProvider.getSession();
            }
        }, jSR45DebuggerEngineProvider});
    }

    public JPDAStep createJPDAStep(int n, int n2) {
        Session session = (Session)this.lookupProvider.lookupFirst(null, Session.class);
        return new JPDAStepImpl(this, session, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JPDAClassType> getAllClasses() {
        List<Object> list;
        Object object = this.virtualMachineLock;
        synchronized (object) {
            list = this.virtualMachine == null ? Collections.emptyList() : VirtualMachineWrapper.allClasses0(this.virtualMachine);
        }
        return new ClassTypeList(this, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JPDAClassType> getClassesByName(String string) {
        List<Object> list;
        Object object = this.virtualMachineLock;
        synchronized (object) {
            list = this.virtualMachine == null ? Collections.emptyList() : VirtualMachineWrapper.classesByName0(this.virtualMachine, string);
        }
        return new ClassTypeList(this, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getInstanceCounts(List<JPDAClassType> list) throws UnsupportedOperationException {
        if (JPDAUtils.IS_JDK_16) {
            VirtualMachine virtualMachine;
            List<ReferenceType> list2 = this.virtualMachineLock;
            synchronized (list2) {
                virtualMachine = this.virtualMachine;
            }
            if (virtualMachine == null) {
                return new long[list.size()];
            }
            if (list instanceof ClassTypeList) {
                ClassTypeList classTypeList = (ClassTypeList)list;
                list2 = classTypeList.getTypes();
            } else {
                list2 = new ArrayList<ReferenceType>(list.size());
                for (JPDAClassType jPDAClassType : list) {
                    list2.add(((JPDAClassTypeImpl)jPDAClassType).getType());
                }
            }
            try {
                return VirtualMachineWrapper.instanceCounts(virtualMachine, list2);
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return new long[list.size()];
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return new long[list.size()];
            }
        }
        throw new UnsupportedOperationException("Not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canGetInstanceInfo() {
        Object object = this.virtualMachineLock;
        synchronized (object) {
            return this.virtualMachine != null && JPDADebuggerImpl.canGetInstanceInfo(this.virtualMachine);
        }
    }

    private static boolean canGetInstanceInfo(VirtualMachine virtualMachine) {
        if (JPDAUtils.IS_JDK_16) {
            try {
                Method method = VirtualMachine.class.getMethod("canGetInstanceInfo", new Class[0]);
                Object object = method.invoke((Object)virtualMachine, new Object[0]);
                return Boolean.TRUE.equals(object);
            }
            catch (Exception exception) {
                Logger.getLogger(JPDADebuggerImpl.class.getName()).log(Level.INFO, "", exception);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadsCollectorImpl getThreadsCollector() {
        Object object = this.threadsCollectorLock;
        synchronized (object) {
            if (this.threadsCollector == null) {
                this.threadsCollector = new ThreadsCollectorImpl(this);
            }
            return this.threadsCollector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeadlockDetector getDeadlockDetector() {
        Object object = this.threadsCollectorLock;
        synchronized (object) {
            if (this.deadlockDetector == null) {
                this.deadlockDetector = new DeadlockDetectorImpl(this);
            }
            return this.deadlockDetector;
        }
    }

    private static class DebuggerReentrantReadWriteLock
    extends ReentrantReadWriteLock {
        private ReentrantReadWriteLock.ReadLock readerLock = new DebuggerReadLock(this);
        private ReentrantReadWriteLock.WriteLock writerLock = new DebuggerWriteLock(this);

        public DebuggerReentrantReadWriteLock(boolean bl) {
            super(bl);
        }

        public ReentrantReadWriteLock.ReadLock readLock() {
            return this.readerLock;
        }

        public ReentrantReadWriteLock.WriteLock writeLock() {
            return this.writerLock;
        }

        private static class DebuggerWriteLock
        extends ReentrantReadWriteLock.WriteLock {
            protected DebuggerWriteLock(ReentrantReadWriteLock reentrantReadWriteLock) {
                super(reentrantReadWriteLock);
            }

            public void lock() {
                assert (!EventQueue.isDispatchThread()) : "Debugger lock taken in AWT Event Queue!";
                super.lock();
            }
        }

        private static class DebuggerReadLock
        extends ReentrantReadWriteLock.ReadLock {
            protected DebuggerReadLock(ReentrantReadWriteLock reentrantReadWriteLock) {
                super(reentrantReadWriteLock);
            }

            public void lock() {
                assert (!EventQueue.isDispatchThread()) : "Debugger lock taken in AWT Event Queue!";
                super.lock();
            }
        }
    }
}

