/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.LineBreakpoint;
import org.netbeans.modules.php.dbgp.packets.BrkpntSetCommand;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;

public class BrkpntCommandBuilder {
    private BrkpntCommandBuilder() {
    }

    public static BrkpntSetCommand buildLineBreakpoint(SessionId sessionId, String string, FileObject fileObject, int n) {
        BrkpntSetCommand brkpntSetCommand = new BrkpntSetCommand(string);
        String string2 = sessionId.toWebServerURI(fileObject);
        if (string2 == null) {
            return null;
        }
        brkpntSetCommand.setType(BrkpntSetCommand.Types.LINE);
        brkpntSetCommand.setFile(string2);
        brkpntSetCommand.setLineNumber(n);
        return brkpntSetCommand;
    }

    public static BrkpntSetCommand buildLineBreakpoint(SessionId sessionId, String string, LineBreakpoint lineBreakpoint) {
        Line line = lineBreakpoint.getLine();
        FileObject fileObject = (FileObject)line.getLookup().lookup(FileObject.class);
        BrkpntSetCommand brkpntSetCommand = BrkpntCommandBuilder.buildLineBreakpoint(sessionId, string, fileObject, line.getLineNumber());
        if (brkpntSetCommand != null) {
            brkpntSetCommand.setBreakpoint(lineBreakpoint);
        }
        return brkpntSetCommand;
    }

    public static BrkpntSetCommand buildCallBreakpoint(String string, String string2) {
        BrkpntSetCommand brkpntSetCommand = new BrkpntSetCommand(string);
        brkpntSetCommand.setType(BrkpntSetCommand.Types.CALL);
        brkpntSetCommand.setFunction(string2);
        return brkpntSetCommand;
    }

    public static BrkpntSetCommand buildCallBreakpoint(String string, FunctionBreakpoint functionBreakpoint) {
        String string2 = functionBreakpoint.getFunction();
        BrkpntSetCommand brkpntSetCommand = BrkpntCommandBuilder.buildCallBreakpoint(string, string2);
        brkpntSetCommand.setBreakpoint(functionBreakpoint);
        return brkpntSetCommand;
    }

    public static BrkpntSetCommand buildReturnBreakpoint(String string, String string2) {
        BrkpntSetCommand brkpntSetCommand = new BrkpntSetCommand(string);
        brkpntSetCommand.setType(BrkpntSetCommand.Types.RETURN);
        brkpntSetCommand.setFunction(string2);
        return brkpntSetCommand;
    }

    public static BrkpntSetCommand buildReturnBreakpoint(String string, FunctionBreakpoint functionBreakpoint) {
        String string2 = functionBreakpoint.getFunction();
        BrkpntSetCommand brkpntSetCommand = BrkpntCommandBuilder.buildReturnBreakpoint(string, string2);
        brkpntSetCommand.setBreakpoint(functionBreakpoint);
        return brkpntSetCommand;
    }

    public static BrkpntSetCommand buildExceptionBreakpoint(String string, String string2) {
        BrkpntSetCommand brkpntSetCommand = new BrkpntSetCommand(string);
        brkpntSetCommand.setType(BrkpntSetCommand.Types.EXCEPTION);
        brkpntSetCommand.setException(string2);
        return brkpntSetCommand;
    }

    public static BrkpntSetCommand buildConditionalBreakpoint(String string, String string2) {
        BrkpntSetCommand brkpntSetCommand = new BrkpntSetCommand(string);
        brkpntSetCommand.setType(BrkpntSetCommand.Types.WATCH);
        brkpntSetCommand.setExpression(string2);
        return brkpntSetCommand;
    }
}

