/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.ProxyClient;
import org.netbeans.modules.php.dbgp.SessionManager;
import org.netbeans.modules.php.dbgp.SingleThread;
import org.netbeans.modules.php.dbgp.breakpoints.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

class ServerThread
extends SingleThread {
    private static final int TIMEOUT = 10000;
    private static final String PORT_OCCUPIED = "MSG_PortOccupied";
    private int myPort;
    private ServerSocket myServer;
    private AtomicBoolean isStopped;
    private SessionManager sessionManager;

    ServerThread(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
        this.isStopped = new AtomicBoolean(false);
    }

    public void run() {
        this.isStopped = new AtomicBoolean(false);
        DebugSession debugSession = this.getDebugSession();
        ProxyClient proxyClient = null;
        if (debugSession != null && this.createServerSocket(debugSession)) {
            proxyClient = ProxyClient.getInstance(debugSession.getOptions());
            if (proxyClient != null) {
                proxyClient.register();
            }
            debugSession.startBackend();
            while (!this.isStopped() && this.getDebugSession() != null) {
                try {
                    Socket socket = this.myServer.accept();
                    if (this.isStopped.get() || socket == null) continue;
                    debugSession.start(socket);
                    this.sessionManager.add(debugSession);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.log(socketTimeoutException);
                }
                catch (IOException iOException) {
                    this.log(iOException);
                }
            }
            this.closeSocket();
        }
        if (proxyClient != null) {
            proxyClient.unregister();
        }
    }

    private DebugSession getDebugSession() {
        DebugSession debugSession = (DebugSession)DebuggerManager.getDebuggerManager().getCurrentEngine().lookupFirst(null, DebugSession.class);
        if (debugSession == null) {
            Session session;
            Session[] sessionArray;
            Session[] sessionArray2 = sessionArray = DebuggerManager.getDebuggerManager().getSessions();
            int n = sessionArray2.length;
            for (int i = 0; i < n && (debugSession = (DebugSession)(session = sessionArray2[i]).lookupFirst(null, DebugSession.class)) == null; ++i) {
            }
        }
        return debugSession;
    }

    private void log(Throwable throwable) {
        Logger.getLogger(ServerThread.class.getName()).log(Level.FINE, null, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createServerSocket(DebugSession debugSession) {
        Class<ServerThread> clazz = ServerThread.class;
        synchronized (ServerThread.class) {
            try {
                this.myPort = debugSession.getOptions().getPort();
                this.myServer = new ServerSocket(this.myPort);
                this.myServer.setSoTimeout(10000);
                this.myServer.setReuseAddress(true);
            }
            catch (IOException iOException) {
                String string = NbBundle.getMessage(ServerThread.class, (String)PORT_OCCUPIED);
                string = MessageFormat.format(string, this.myPort);
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 0);
                Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (object.equals(0)) {
                    Utils.openPhpOptionsDialog();
                }
                this.log(iOException);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() {
        Class<ServerThread> clazz = ServerThread.class;
        synchronized (ServerThread.class) {
            if (this.myServer == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                if (!this.myServer.isClosed()) {
                    this.myServer.close();
                }
            }
            catch (IOException iOException) {
                this.log(iOException);
            }
            return;
        }
    }

    public void cancel() {
        this.isStopped.set(true);
        this.closeSocket();
    }

    private boolean isStopped() {
        return this.isStopped.get();
    }
}

