/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.io.File;
import java.util.logging.Level;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.MacBrowserImpl;
import org.netbeans.modules.extbrowser.NbBrowserException;
import org.netbeans.modules.extbrowser.NbDdeBrowserImpl;
import org.netbeans.modules.extbrowser.UnixBrowserImpl;
import org.openide.awt.HtmlBrowser;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class FirefoxBrowser
extends ExtWebBrowser {
    private static final long serialVersionUID = -3982770681461437966L;

    public FirefoxBrowser() {
        this.ddeServer = "FIREFOX";
    }

    public static Boolean isHidden() {
        String string = null;
        if (Utilities.isWindows()) {
            try {
                string = NbDdeBrowserImpl.getBrowserPath("FIREFOX");
            }
            catch (NbBrowserException nbBrowserException) {
                ExtWebBrowser.getEM().log(Level.INFO, "Cannot detect Firefox : " + nbBrowserException);
            }
            if (string != null && string.trim().length() > 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Utilities.isUnix() ? Boolean.FALSE : Boolean.TRUE;
    }

    public String getName() {
        if (this.name == null) {
            this.name = NbBundle.getMessage((Class)FirefoxBrowser.class, (String)"CTL_FirefoxBrowserName");
        }
        return this.name;
    }

    public HtmlBrowser.Impl createHtmlBrowserImpl() {
        ExtBrowserImpl extBrowserImpl = null;
        if (Utilities.isWindows()) {
            extBrowserImpl = new NbDdeBrowserImpl(this);
        } else if (Utilities.isMac()) {
            extBrowserImpl = new MacBrowserImpl(this);
        } else if (Utilities.isUnix() && !Utilities.isMac()) {
            extBrowserImpl = new UnixBrowserImpl(this);
        } else {
            throw new UnsupportedOperationException(NbBundle.getMessage((Class)FirefoxBrowser.class, (String)"MSG_CannotUseBrowser"));
        }
        return extBrowserImpl;
    }

    protected NbProcessDescriptor defaultBrowserExecutable() {
        String string = "";
        if (Utilities.isWindows()) {
            String string2;
            string = string + "{URL}";
            try {
                String string3 = NbDdeBrowserImpl.getBrowserPath(this.getDDEServer());
                return new NbProcessDescriptor(string3, string);
            }
            catch (NbBrowserException nbBrowserException) {
                string2 = "C:\\Program Files\\Mozilla Firefox\\firefox.exe";
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                string2 = "firefox.exe";
            }
            NbProcessDescriptor nbProcessDescriptor = new NbProcessDescriptor(string2, string);
            return nbProcessDescriptor;
        }
        if (Utilities.isMac()) {
            string = string + "-a firefox {URL}";
            NbProcessDescriptor nbProcessDescriptor = new NbProcessDescriptor("/usr/bin/open", string, ExtWebBrowser.UnixBrowserFormat.getHint());
            return nbProcessDescriptor;
        }
        String string4 = "firefox";
        if (Utilities.getOperatingSystem() == 16) {
            File file = new File("/usr/bin/firefox");
            if (file.exists()) {
                string4 = file.getAbsolutePath();
            }
            if ((file = new File("/usr/bin/mozilla-firefox")).exists()) {
                string4 = file.getAbsolutePath();
            }
            if ((file = new File("/usr/local/firefox/firefox")).exists()) {
                string4 = file.getAbsolutePath();
            }
        } else if (Utilities.getOperatingSystem() == 8) {
            File file = new File("/usr/sfw/lib/firefox/firefox");
            if (file.exists()) {
                string4 = file.getAbsolutePath();
            } else {
                file = new File("/opt/csw/bin/firefox");
                if (file.exists()) {
                    string4 = file.getAbsolutePath();
                }
            }
        }
        NbProcessDescriptor nbProcessDescriptor = new NbProcessDescriptor(string4, "-remote \"openURL({URL})\"", ExtWebBrowser.UnixBrowserFormat.getHint());
        return nbProcessDescriptor;
    }
}

