/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.FolderList;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.SettingsPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelSourceFolders
extends SettingsPanel
implements PropertyChangeListener {
    private final Panel firer;
    private WizardDescriptor wizardDescriptor;
    public static final String INITIAL_SOURCE_ROOT = "EXISTING_SOURCES_CURRENT_DIRECTORY";
    private JLabel description;
    private JPanel sourcePanel;
    private JPanel testsPanel;

    PanelSourceFolders(Panel panel) {
        this.firer = panel;
        this.initComponents();
        this.setName(NbBundle.getMessage(PanelSourceFolders.class, (String)"LAB_ConfigureSourceRoots"));
        this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_JavaExtSourcesProjectLocation"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelSourceFolders.class, (String)"AN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_PanelSourceFolders"));
        this.sourcePanel.addPropertyChangeListener(this);
        this.testsPanel.addPropertyChangeListener(this);
        ((FolderList)this.sourcePanel).setRelatedFolderList((FolderList)this.testsPanel);
        ((FolderList)this.testsPanel).setRelatedFolderList((FolderList)this.sourcePanel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("files".equals(propertyChangeEvent.getPropertyName())) {
            this.dataChanged();
        } else if ("lastUsedDir".equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getSource() == this.sourcePanel) {
                ((FolderList)this.testsPanel).setLastUsedDir((File)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getSource() == this.testsPanel) {
                ((FolderList)this.sourcePanel).setLastUsedDir((File)propertyChangeEvent.getNewValue());
            }
        }
    }

    private void dataChanged() {
        this.firer.fireChangeEvent();
    }

    @Override
    void read(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
        File file = (File)wizardDescriptor.getProperty("projdir");
        ((FolderList)this.sourcePanel).setProjectFolder(file);
        ((FolderList)this.testsPanel).setProjectFolder(file);
        File[] fileArray = (File[])wizardDescriptor.getProperty("sourceRoot");
        assert (fileArray != null) : "sourceRoot property must be initialized!";
        ((FolderList)this.sourcePanel).setFiles(fileArray);
        File[] fileArray2 = (File[])wizardDescriptor.getProperty("testRoot");
        assert (fileArray2 != null) : "testRoot property must be initialized!";
        ((FolderList)this.testsPanel).setFiles(fileArray2);
        File file2 = null;
        FileObject fileObject = Templates.getExistingSourcesFolder((WizardDescriptor)this.wizardDescriptor);
        if (fileObject != null) {
            file2 = FileUtil.toFile((FileObject)fileObject);
        }
        if (file2 != null && file2.isDirectory()) {
            ((FolderList)this.sourcePanel).setLastUsedDir(file2);
            ((FolderList)this.testsPanel).setLastUsedDir(file2);
        }
    }

    @Override
    void store(WizardDescriptor wizardDescriptor) {
        File[] fileArray = ((FolderList)this.sourcePanel).getFiles();
        File[] fileArray2 = ((FolderList)this.testsPanel).getFiles();
        wizardDescriptor.putProperty("sourceRoot", (Object)fileArray);
        wizardDescriptor.putProperty("testRoot", (Object)fileArray2);
    }

    @Override
    boolean valid(WizardDescriptor wizardDescriptor) {
        File[] fileArray;
        File[] fileArray2;
        File file = (File)wizardDescriptor.getProperty("projdir");
        String string = PanelSourceFolders.checkValidity(file, fileArray2 = ((FolderList)this.sourcePanel).getFiles(), fileArray = ((FolderList)this.testsPanel).getFiles());
        if (string == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
            return true;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
        return false;
    }

    static String checkValidity(File file, File[] fileArray, File[] fileArray2) {
        String string;
        int n;
        String string2 = file.getAbsolutePath();
        for (n = 0; n < fileArray.length; ++n) {
            if (!fileArray[n].isDirectory() || !fileArray[n].canRead()) {
                return MessageFormat.format(NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalSources"), fileArray[n].getAbsolutePath());
            }
            string = fileArray[n].getAbsolutePath();
            if (!string2.equals(string) && !string2.startsWith(string + File.separatorChar)) continue;
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalProjectFolder");
        }
        for (n = 0; n < fileArray2.length; ++n) {
            if (!fileArray2[n].isDirectory() || !fileArray2[n].canRead()) {
                return MessageFormat.format(NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalTests"), fileArray[n].getAbsolutePath());
            }
            string = fileArray2[n].getAbsolutePath();
            if (!string2.equals(string) && !string2.startsWith(string + File.separatorChar)) continue;
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalProjectFolder");
        }
        return null;
    }

    @Override
    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
        this.searchClassFiles(((FolderList)this.sourcePanel).getFiles());
    }

    private static void findClassFiles(File file, List<File> list) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isFile() && file2.getName().endsWith(".class")) {
                list.add(file2);
                continue;
            }
            if (!file2.isDirectory()) continue;
            PanelSourceFolders.findClassFiles(file2, list);
        }
    }

    private void searchClassFiles(File[] fileArray) throws WizardValidationException {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : fileArray) {
            PanelSourceFolders.findClassFiles(file, arrayList);
        }
        if (!arrayList.isEmpty()) {
            File file;
            JButton jButton = new JButton(NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_DeleteOption"));
            JButton jButton2 = new JButton(NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_KeepOption"));
            JButton jButton3 = new JButton(NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_CancelOption"));
            jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_DeleteOption"));
            jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_KeepOption"));
            jButton3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_CancelOption"));
            file = new NotifyDescriptor((Object)NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_FoundClassFiles"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_FoundClassFiles_Title"), 1, 3, new Object[]{jButton, jButton2, jButton3}, (Object)jButton);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)file);
            if (jButton.equals(object)) {
                for (File file2 : arrayList) {
                    file2.delete();
                }
            } else if (!jButton2.equals(object)) {
                throw new WizardValidationException((JComponent)this.sourcePanel, "", "");
            }
        }
    }

    private void initComponents() {
        this.description = new JLabel();
        this.sourcePanel = this.createSourcePanel();
        this.testsPanel = this.createTestPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.description, (String)NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_SourceDirectoriesLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.description, gridBagConstraints);
        this.description.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelSourceFolders.class).getString("ACSN_jLabel3"));
        this.description.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelSourceFolders.class).getString("ACSD_jLabel3"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.45;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.sourcePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.45;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.testsPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSD_PanelSourceFolders"));
    }

    private JPanel createSourcePanel() {
        return new FolderList(NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_SourceRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_SourceRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_AddSourceRoot"), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_AddSourceFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_AddSourceFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_RemoveSourceFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_RemoveSourceFolder"));
    }

    private JPanel createTestPanel() {
        return new FolderList(NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_TestRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_TestRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_AddTestRoot"), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_AddTestFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_AddTestFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_RemoveTestFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_RemoveTestFolder"));
    }

    static class Panel
    implements WizardDescriptor.ValidatingPanel {
        private ArrayList<ChangeListener> listeners;
        private PanelSourceFolders component;
        private WizardDescriptor settings;

        Panel() {
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(changeListener);
        }

        public void addChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(changeListener);
        }

        public void readSettings(Object object) {
            this.settings = (WizardDescriptor)object;
            this.component.read(this.settings);
            Object object2 = this.component.getClientProperty("NewProjectWizard_Title");
            if (object2 != null) {
                this.settings.putProperty("NewProjectWizard_Title", object2);
            }
        }

        public void storeSettings(Object object) {
            this.component.store(this.settings);
        }

        public void validate() throws WizardValidationException {
            this.component.validate(this.settings);
        }

        public boolean isValid() {
            return this.component.valid(this.settings);
        }

        public synchronized Component getComponent() {
            if (this.component == null) {
                this.component = new PanelSourceFolders(this);
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(PanelSourceFolders.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChangeEvent() {
            Iterator iterator = null;
            Object object = this;
            synchronized (object) {
                if (this.listeners == null) {
                    return;
                }
                iterator = ((ArrayList)this.listeners.clone()).iterator();
            }
            object = new ChangeEvent(this);
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
            }
        }
    }
}

