/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.netbeans.modules.ruby.rubyproject.RubyProjectUtil;
import org.netbeans.modules.ruby.rubyproject.SharedRubyProjectProperties;
import org.netbeans.modules.ruby.rubyproject.SourceRoots;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.RubySourceRootsUi;
import org.netbeans.modules.ruby.spi.project.support.rake.GeneratedFilesHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.openide.util.EditableProperties;

public class RubyProjectProperties
extends SharedRubyProjectProperties {
    private static final Logger LOGGER = Logger.getLogger(RubyProjectProperties.class.getName());
    public static final String RUN_WORK_DIR = "work.dir";
    private static final String[] CONFIG_PROPS = new String[]{"main.file", "application.args", "ruby.options", "work.dir", "rake.args", "jvm.args", "platform.active"};
    private static final String[] CONFIG_PRIVATE_PROPS = new String[]{"application.args", "work.dir", "rake.args", "platform.active"};
    DefaultTableModel sourceRootsModel = RubySourceRootsUi.createModel(this.getRubyProject().getSourceRoots());
    DefaultTableModel testRootsModel = RubySourceRootsUi.createModel(this.getRubyProject().getTestSourceRoots());

    public RubyProjectProperties(RubyProject rubyProject, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, GeneratedFilesHelper generatedFilesHelper) {
        super(rubyProject, propertyEvaluator, updateHelper, generatedFilesHelper, referenceHelper);
    }

    RubyProject getRubyProject() {
        return (RubyProject)this.getProject().getLookup().lookup(RubyProject.class);
    }

    protected String[] getConfigProperties() {
        return CONFIG_PROPS;
    }

    protected String[] getConfigPrivateProperties() {
        return CONFIG_PRIVATE_PROPS;
    }

    protected void prePropertiesStore() throws IOException {
        this.storeRoots(this.getRubyProject().getSourceRoots(), this.sourceRootsModel);
        this.storeRoots(this.getRubyProject().getTestSourceRoots(), this.testRootsModel);
    }

    protected void storeProperties(EditableProperties editableProperties, EditableProperties editableProperties2) throws IOException {
        RubyPlatform rubyPlatform = this.getPlatform();
        if (rubyPlatform == null) {
            LOGGER.fine("Project has invalid platform (null).");
            return;
        }
        RubyPlatform.Info info = rubyPlatform.getInfo();
        Util.logUsage(RubyProjectProperties.class, "USG_PROJECT_CONFIG_RUBY", info.getKind(), info.getPlatformVersion(), info.getGemVersion());
    }

    private void storeRoots(SourceRoots sourceRoots, DefaultTableModel defaultTableModel) throws MalformedURLException {
        Vector<Vector> vector = defaultTableModel.getDataVector();
        URL[] uRLArray = new URL[vector.size()];
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            File file = (File)vector.elementAt(i).elementAt(0);
            uRLArray[i] = RubyProjectUtil.getRootURL(file, null);
            stringArray[i] = (String)vector.elementAt(i).elementAt(1);
        }
        sourceRoots.putRoots(uRLArray, stringArray);
    }
}

