/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.rake;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.io.ReaderInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RakeTaskReader {
    private final Project project;

    RakeTaskReader(Project project) {
        this.project = project;
    }

    Set<RakeTask> getRakeTaskTree() {
        return this.getRakeTaskTree(true);
    }

    Set<RakeTask> getRakeTaskTree(boolean bl) {
        try {
            Set<RakeTask> set;
            String string = this.rawRead();
            Set<RakeTask> set2 = set = string == null ? Collections.emptySet() : RakeTaskReader.parseTasks(new StringReader(string));
            if (bl) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    RakeTask rakeTask = (RakeTask)iterator.next();
                    if (rakeTask.isNameSpace() || rakeTask.getDescription() != null) continue;
                    iterator.remove();
                }
            }
            return set;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return Collections.emptySet();
        }
    }

    String rawRead() {
        final FileObject fileObject = this.project.getProjectDirectory();
        try {
            final StringBuilder stringBuilder = new StringBuilder(5000);
            fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    FileObject fileObject2 = fileObject.getFileObject("nbproject/private/rake-d.txt");
                    if (fileObject2 == null) {
                        return;
                    }
                    BufferedReader bufferedReader = null;
                    try {
                        String string;
                        InputStream inputStream = fileObject2.getInputStream();
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        while ((string = bufferedReader.readLine()) != null) {
                            stringBuilder.append(string);
                            stringBuilder.append('\n');
                        }
                    }
                    finally {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                }
            });
            return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    private static Set<RakeTask> parseTasks(Reader reader) throws IOException {
        Properties properties = new Properties();
        properties.load((InputStream)new ReaderInputStream(reader));
        TreeSet<RakeTask> treeSet = new TreeSet<RakeTask>();
        HashMap<String, RakeTask> hashMap = new HashMap<String, RakeTask>(50);
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if ("".equals(string2)) {
                string2 = null;
            }
            if (!hashSet.add(string)) continue;
            RakeTask rakeTask = null;
            String[] stringArray = string.split(":");
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(':');
                }
                stringBuilder.append(stringArray[i]);
                String string3 = stringBuilder.toString();
                RakeTask rakeTask2 = (RakeTask)hashMap.get(string3);
                if (rakeTask2 == null) {
                    RakeTask rakeTask3 = RakeTask.newNameSpace(stringArray[i]);
                    if (rakeTask == null) {
                        treeSet.add(rakeTask3);
                    } else {
                        rakeTask.addChild(rakeTask3);
                    }
                    hashMap.put(string3, rakeTask3);
                    rakeTask = rakeTask3;
                    continue;
                }
                rakeTask = rakeTask2;
            }
            RakeTask rakeTask4 = new RakeTask(string, stringArray[stringArray.length - 1], string2);
            if (rakeTask != null) {
                rakeTask.addChild(rakeTask4);
                continue;
            }
            treeSet.add(rakeTask4);
        }
        return treeSet;
    }
}

