/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.rake;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.codecoverage.RubyCoverageProvider;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.rubyproject.RubyFileLocator;
import org.netbeans.modules.ruby.rubyproject.rake.RakeRunnerAction;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.netbeans.modules.ruby.rubyproject.spi.RakeTaskCustomizer;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RakeRunner {
    private final Project project;
    private boolean showWarnings;
    private boolean debug;
    private FileObject rakeFile;
    private RubyFileLocator fileLocator;
    private File pwd;
    private String displayName;
    private final List<String> parameters = new ArrayList<String>();

    public RakeRunner(Project project) {
        this.project = project;
    }

    static void runTask(Project project, RakeTask rakeTask, String string, boolean bl) {
        RakeRunner rakeRunner = new RakeRunner(project);
        rakeRunner.showWarnings(true);
        if (string != null) {
            rakeRunner.setParameters(Utilities.parseParameters((String)string));
        }
        rakeRunner.setDebug(bl);
        rakeRunner.run(rakeTask);
    }

    public void setRakeFile(FileObject fileObject) {
        this.rakeFile = fileObject;
    }

    public void showWarnings(boolean bl) {
        this.showWarnings = bl;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setFileLocator(RubyFileLocator rubyFileLocator) {
        this.fileLocator = rubyFileLocator;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public void setPWD(File file) {
        this.pwd = file;
    }

    public void setParameters(String ... stringArray) {
        Parameters.notNull((CharSequence)"parameters", (Object)stringArray);
        for (String string : stringArray) {
            this.parameters.add(string);
        }
    }

    public List<Future<Integer>> run(String ... stringArray) {
        if (stringArray.length == 0) {
            stringArray = new String[]{"default"};
        }
        if (!RubyPlatform.hasValidRake((Project)this.project, (boolean)this.showWarnings)) {
            return null;
        }
        RakeTask[] rakeTaskArray = new RakeTask[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            RakeTask rakeTask = RakeSupport.getRakeTask(this.project, stringArray[i]);
            if (rakeTask == null) {
                if (this.showWarnings) {
                    Util.notifyLocalized(RakeRunner.class, (String)"RakeRunner.task.does.not.exist", (Object[])new Object[]{stringArray[i]});
                }
                return null;
            }
            rakeTaskArray[i] = rakeTask;
        }
        return this.run(rakeTaskArray);
    }

    private List<Future<Integer>> run(RakeTask ... rakeTaskArray) {
        assert (rakeTaskArray.length > 0) : "must pass at least one task";
        if (!RubyPlatform.hasValidRake((Project)this.project, (boolean)this.showWarnings)) {
            return null;
        }
        LifecycleManager.getDefault().saveAll();
        if (this.fileLocator == null) {
            this.fileLocator = new RubyFileLocator(Lookup.EMPTY, this.project);
        }
        if (this.rakeFile == null) {
            this.rakeFile = RakeSupport.findRakeFile(this.project);
        }
        if (this.rakeFile == null) {
            this.pwd = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        }
        if (this.pwd == null) {
            this.pwd = FileUtil.toFile((FileObject)this.rakeFile.getParent());
        }
        List<RakeTask> list = Arrays.asList(rakeTaskArray);
        this.computeAndSetDisplayName(list);
        List<ExecutionService> list2 = this.getExecutionServices(list);
        ArrayList<Future<Integer>> arrayList = new ArrayList<Future<Integer>>(list2.size());
        for (ExecutionService executionService : list2) {
            arrayList.add(executionService.run());
        }
        return arrayList;
    }

    private List<ExecutionService> getExecutionServices(List<? extends RakeTask> list) {
        ArrayList<ExecutionService> arrayList = new ArrayList<ExecutionService>(list.size());
        for (RubyExecutionDescriptor rubyExecutionDescriptor : this.getDescriptors(list)) {
            arrayList.add(this.buildExecutionService(rubyExecutionDescriptor));
        }
        return arrayList;
    }

    private ExecutionService buildExecutionService(RubyExecutionDescriptor rubyExecutionDescriptor) {
        Runnable runnable;
        String string = null;
        if (this.project != null && (runnable = (PropertyEvaluator)this.project.getLookup().lookup(PropertyEvaluator.class)) != null) {
            string = runnable.getProperty("source.encoding");
        }
        runnable = rubyExecutionDescriptor.getPostBuild();
        rubyExecutionDescriptor.postBuild(new Runnable(){

            public void run() {
                if (runnable != null) {
                    runnable.run();
                }
                FileUtil.refreshFor((File[])new File[]{FileUtil.toFile((FileObject)RakeRunner.this.project.getProjectDirectory())});
            }
        });
        RubyProcessCreator rubyProcessCreator = new RubyProcessCreator(rubyExecutionDescriptor, string);
        return ExecutionService.newService((Callable)rubyProcessCreator, (ExecutionDescriptor)rubyExecutionDescriptor.toExecutionDescriptor(), (String)this.displayName);
    }

    List<RubyExecutionDescriptor> getDescriptors(List<? extends RakeTask> list) {
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)this.project);
        String string = rubyPlatform.getRake();
        Collection collection = Lookup.getDefault().lookupAll(RakeTaskCustomizer.class);
        ArrayList<RubyExecutionDescriptor> arrayList = new ArrayList<RubyExecutionDescriptor>(list.size());
        RubyCoverageProvider rubyCoverageProvider = RubyCoverageProvider.get((Project)this.project);
        if (rubyCoverageProvider == null || !rubyCoverageProvider.isEnabled()) {
            rubyCoverageProvider = null;
        }
        for (RakeTask rakeTask : list) {
            ArrayList<String> arrayList222;
            RubyExecutionDescriptor rubyExecutionDescriptor = new RubyExecutionDescriptor(rubyPlatform, this.displayName, this.pwd, string);
            this.doStandardConfiguration(rubyExecutionDescriptor);
            String[] stringArray = rubyExecutionDescriptor.getInitialArgs() != null ? rubyExecutionDescriptor.getInitialArgs() : new String[]{};
            ArrayList<String> arrayList3 = new ArrayList<String>(Arrays.asList(stringArray));
            for (ArrayList<String> arrayList222 : collection) {
                arrayList222.customize(this.project, rakeTask, rubyExecutionDescriptor, this.debug);
            }
            arrayList3.addAll(rakeTask.getRakeParameters());
            Object object = "";
            arrayList222 = arrayList3.iterator();
            while (arrayList222.hasNext()) {
                object = (String)object + (String)arrayList222.next();
                if (!arrayList222.hasNext()) continue;
                object = (String)object + " ";
            }
            rubyExecutionDescriptor.initialArgs((String)object);
            arrayList222 = new ArrayList<String>();
            String[] stringArray2 = rubyExecutionDescriptor.getAdditionalArgs();
            if (stringArray2 != null && stringArray2.length > 0) {
                arrayList222.addAll(Arrays.asList(stringArray2));
            }
            arrayList222.add(rakeTask.getTask());
            for (String string2 : this.parameters) {
                arrayList222.add(string2);
            }
            arrayList222.addAll(rakeTask.getTaskParameters());
            rubyExecutionDescriptor.additionalArgs(arrayList222.toArray(new String[arrayList222.size()]));
            if (rubyCoverageProvider != null) {
                rubyExecutionDescriptor = rubyCoverageProvider.wrapWithCoverage(rubyExecutionDescriptor, true, null);
            }
            arrayList.add(rubyExecutionDescriptor);
        }
        return arrayList;
    }

    private void doStandardConfiguration(RubyExecutionDescriptor rubyExecutionDescriptor) {
        String[] stringArray;
        PropertyEvaluator propertyEvaluator;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (this.project != null && (propertyEvaluator = (PropertyEvaluator)this.project.getLookup().lookup(PropertyEvaluator.class)) != null) {
            string = propertyEvaluator.getProperty("source.encoding");
            string2 = propertyEvaluator.getProperty("javac.classpath");
            string3 = propertyEvaluator.getProperty("rake.args");
            string4 = propertyEvaluator.getProperty("jvm.args");
            string5 = propertyEvaluator.getProperty("ruby.options");
        }
        propertyEvaluator = new ArrayList();
        if (string3 != null && (stringArray = Utilities.parseParameters(string3)) != null) {
            for (String string6 : stringArray) {
                propertyEvaluator.add(string6);
            }
        }
        if (this.rakeFile != null) {
            propertyEvaluator.add("-f");
            propertyEvaluator.add(FileUtil.toFile((FileObject)this.rakeFile).getAbsolutePath());
        }
        if (!propertyEvaluator.isEmpty()) {
            rubyExecutionDescriptor.additionalArgs(propertyEvaluator.toArray(new String[propertyEvaluator.size()]));
        }
        if (string5 != null) {
            rubyExecutionDescriptor.initialArgs(string5);
        }
        rubyExecutionDescriptor.allowInput();
        rubyExecutionDescriptor.classPath(string2);
        rubyExecutionDescriptor.jvmArguments(string4);
        rubyExecutionDescriptor.fileLocator((LineConvertors.FileLocator)this.fileLocator);
        rubyExecutionDescriptor.addStandardRecognizers();
        if (RubyPlatform.platformFor((Project)this.project).isJRuby()) {
            rubyExecutionDescriptor.appendJdkToPath(true);
        }
        rubyExecutionDescriptor.addOutConvertor((LineConvertor)new RakeErrorLineConvertor(rubyExecutionDescriptor, string, this.displayName));
        rubyExecutionDescriptor.addErrConvertor((LineConvertor)new RakeErrorLineConvertor(rubyExecutionDescriptor, string, this.displayName));
        rubyExecutionDescriptor.debug(this.debug);
    }

    private void computeAndSetDisplayName(List<? extends RakeTask> list) {
        ProjectInformation projectInformation = ProjectUtils.getInformation((Project)this.project);
        String string = projectInformation == null ? NbBundle.getMessage(RakeRunnerAction.class, (String)"RakeRunnerAction.Rake") : projectInformation.getDisplayName();
        StringBuilder stringBuilder = new StringBuilder(string).append(" (");
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(list.get(i).getTask());
            if (i == list.size() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(')');
        this.setDisplayName(stringBuilder.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RakeErrorLineConvertor
    implements LineConvertor {
        private final RubyExecutionDescriptor template;
        private final String charsetName;
        private final String displayName;

        public RakeErrorLineConvertor(RubyExecutionDescriptor rubyExecutionDescriptor, String string, String string2) {
            this.template = rubyExecutionDescriptor;
            this.charsetName = string;
            this.displayName = string2;
        }

        public List<ConvertedLine> convert(String string) {
            if (string.indexOf("(See full trace by running task with --trace)") != -1) {
                return Collections.singletonList(ConvertedLine.forText((String)NbBundle.getMessage(RakeRunner.class, (String)"RakeSupport.RerunRakeWithTrace"), (OutputListener)new OutputListener(){

                    public void outputLineSelected(OutputEvent outputEvent) {
                    }

                    public void outputLineAction(OutputEvent outputEvent) {
                        RubyProcessCreator rubyProcessCreator = new RubyProcessCreator(this.buildDescriptor(), RakeErrorLineConvertor.this.charsetName);
                        ExecutionService.newService((Callable)rubyProcessCreator, (ExecutionDescriptor)RakeErrorLineConvertor.this.template.toExecutionDescriptor(), (String)RakeErrorLineConvertor.this.displayName).run();
                    }

                    private RubyExecutionDescriptor buildDescriptor() {
                        String[] stringArray = RakeErrorLineConvertor.this.template.getAdditionalArgs() != null ? RakeErrorLineConvertor.this.template.getAdditionalArgs() : new String[]{};
                        String[] stringArray2 = new String[stringArray.length + 1];
                        for (int i = 0; i < stringArray.length; ++i) {
                            stringArray2[i] = stringArray[i];
                        }
                        stringArray2[stringArray2.length - 1] = "--trace";
                        return new RubyExecutionDescriptor(RakeErrorLineConvertor.this.template).additionalArgs(stringArray2);
                    }

                    public void outputLineCleared(OutputEvent outputEvent) {
                    }
                }));
            }
            return null;
        }
    }
}

