/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.websvc.saas.spi.ConsumerFlavorProvider;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaasTransferable<T>
implements Transferable {
    public static final Set<DataFlavor> WSDL_METHOD_FLAVORS = new HashSet<DataFlavor>(Arrays.asList(ConsumerFlavorProvider.WSDL_METHOD_FLAVOR, ConsumerFlavorProvider.WSDL_METHOD_NODE_FLAVOR));
    public static final Set<DataFlavor> WADL_METHOD_FLAVORS = new HashSet<DataFlavor>(Arrays.asList(ConsumerFlavorProvider.WADL_METHOD_FLAVOR, ConsumerFlavorProvider.WADL_METHOD_NODE_FLAVOR));
    public static final Set<DataFlavor> WSDL_PORT_FLAVORS = new HashSet<DataFlavor>(Arrays.asList(ConsumerFlavorProvider.PORT_FLAVOR, ConsumerFlavorProvider.PORT_NODE_FLAVOR));
    public static final Set<DataFlavor> WSDL_SERVICE_FLAVORS = new HashSet<DataFlavor>(Arrays.asList(ConsumerFlavorProvider.WSDL_SERVICE_FLAVOR, ConsumerFlavorProvider.WSDL_SERVICE_NODE_FLAVOR));
    public static final Set<DataFlavor> CUSTOM_METHOD_FLAVORS = new HashSet<DataFlavor>(Arrays.asList(ConsumerFlavorProvider.CUSTOM_METHOD_FLAVOR, ConsumerFlavorProvider.CUSTOM_METHOD_NODE_FLAVOR));
    private final T transferData;
    private final Set<DataFlavor> flavors;

    public SaasTransferable(T t, Set<DataFlavor> set) {
        this.transferData = t;
        this.flavors = set;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors.toArray(new DataFlavor[this.flavors.size()]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.flavors.contains(dataFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return this.transferData;
    }

    public static Transferable addFlavors(Transferable transferable) {
        Collection collection = Lookup.getDefault().lookupAll(ConsumerFlavorProvider.class);
        Transferable transferable2 = transferable;
        for (ConsumerFlavorProvider consumerFlavorProvider : collection) {
            transferable2 = consumerFlavorProvider.addDataFlavors(transferable2);
        }
        return transferable2;
    }
}

