/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.model.wsdl.impl;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.netbeans.modules.websvc.saas.model.wsdl.impl.WsdlErrorHandler;
import org.netbeans.modules.websvc.saas.model.wsdl.impl.WsdlModel;
import org.netbeans.modules.websvc.saas.model.wsdl.impl.WsdlModelListener;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXParseException;

public class WsdlModeler {
    private WsdlModel wsdlModel;
    private URL wsdlUrl;
    private URL[] bindings;
    private URL catalog;
    private EntityResolver entityResolver;
    private Set<String> bindingFiles;
    private String packageName;
    private List<WsdlModelListener> modelListeners;
    RequestProcessor.Task task;
    RequestProcessor.Task task1;
    int listenersSize;
    protected Properties properties;
    private Throwable creationException;

    WsdlModeler(URL uRL) {
        this.wsdlUrl = uRL;
        this.modelListeners = Collections.synchronizedList(new ArrayList());
        this.task = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                WsdlModeler.this.generateWsdlModel();
                WsdlModeler.this.fireModelCreated(WsdlModeler.this.wsdlModel);
            }
        }, true);
    }

    void setWsdlUrl(URL uRL) {
        this.wsdlUrl = uRL;
    }

    public URL getWsdlUrl() {
        return this.wsdlUrl;
    }

    public WsdlModel getWsdlModel() {
        return this.wsdlModel;
    }

    public WsdlModel getAndWaitForWsdlModel() {
        if (this.getWsdlModel() == null) {
            this.generateWsdlModel();
        }
        return this.wsdlModel;
    }

    public void generateWsdlModel(WsdlModelListener wsdlModelListener, final WsdlErrorHandler wsdlErrorHandler) {
        RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                WsdlModeler.this.generateWsdlModel(wsdlErrorHandler);
                WsdlModeler.this.fireModelCreated(WsdlModeler.this.wsdlModel);
            }
        }, true);
        this.addWsdlModelListener(wsdlModelListener);
        task.run();
    }

    public void generateWsdlModel(WsdlModelListener wsdlModelListener) {
        this.generateWsdlModel(wsdlModelListener, false);
    }

    public void generateWsdlModel(WsdlModelListener wsdlModelListener, boolean bl) {
        if (bl) {
            try {
                this.task.waitFinished(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.addWsdlModelListener(wsdlModelListener);
            this.task.schedule(0);
        } else {
            this.addWsdlModelListener(wsdlModelListener);
            if (this.task.isFinished()) {
                this.task.schedule(0);
            }
        }
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Throwable getCreationException() {
        return this.creationException;
    }

    private void generateWsdlModel() {
        this.generateWsdlModel(new CatchFirstErrorHandler());
    }

    private void generateWsdlModel(WsdlErrorHandler wsdlErrorHandler) {
        block7: {
            try {
                FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(this.wsdlUrl.toURI())));
                ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)false);
                WSDLModel wSDLModel = WSDLModelFactory.getDefault().getModel(Utilities.getModelSource((FileObject)fileObject, (boolean)false));
                if (wSDLModel == null) {
                    SAXParseException sAXParseException = null;
                    if (wsdlErrorHandler instanceof CatchFirstErrorHandler) {
                        sAXParseException = ((CatchFirstErrorHandler)wsdlErrorHandler).getFirstError();
                        this.creationException = sAXParseException;
                    }
                    if (sAXParseException == null) {
                        this.creationException = new Exception(NbBundle.getMessage(WsdlModeler.class, (String)"ERR_CannotGenerateModel", (Object)this.wsdlUrl.toExternalForm()));
                    }
                } else {
                    this.wsdlModel = new WsdlModel(wSDLModel);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                this.wsdlModel = null;
                SAXParseException sAXParseException = null;
                if (wsdlErrorHandler instanceof CatchFirstErrorHandler) {
                    sAXParseException = ((CatchFirstErrorHandler)wsdlErrorHandler).getFirstError();
                    this.creationException = sAXParseException;
                }
                if (sAXParseException != null) break block7;
                this.creationException = uRISyntaxException;
            }
        }
    }

    private synchronized void addWsdlModelListener(WsdlModelListener wsdlModelListener) {
        if (wsdlModelListener != null) {
            this.modelListeners.add(wsdlModelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelCreated(WsdlModel wsdlModel) {
        Object object = this.modelListeners;
        synchronized (object) {
            for (WsdlModelListener wsdlModelListener : this.modelListeners) {
                wsdlModelListener.modelCreated(wsdlModel);
            }
        }
        object = this;
        synchronized (object) {
            this.modelListeners.clear();
        }
    }

    private class CatchFirstErrorHandler
    implements WsdlErrorHandler {
        private SAXParseException firstError;

        private CatchFirstErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) throws WsdlErrorHandler.AbortException {
        }

        public void info(SAXParseException sAXParseException) {
        }

        public void fatalError(SAXParseException sAXParseException) throws WsdlErrorHandler.AbortException {
            if (this.firstError == null) {
                this.firstError = sAXParseException;
            }
        }

        public void error(SAXParseException sAXParseException) throws WsdlErrorHandler.AbortException {
            if (this.firstError == null) {
                this.firstError = sAXParseException;
            }
        }

        public SAXParseException getFirstError() {
            return this.firstError;
        }
    }
}

