/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.dom;

import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.xam.AbstractModel;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentUpdater;
import org.netbeans.modules.xml.xam.EmbeddableRoot;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.ChangeInfo;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.dom.DocumentModel;
import org.netbeans.modules.xml.xam.dom.DocumentModelAccess;
import org.netbeans.modules.xml.xam.dom.ElementIdentity;
import org.netbeans.modules.xml.xam.dom.ReadOnlyAccess;
import org.netbeans.modules.xml.xam.dom.SyncUnit;
import org.netbeans.modules.xml.xam.spi.DocumentModelAccessProvider;
import org.openide.util.Lookup;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocumentModel<T extends DocumentComponent<T>>
extends AbstractModel<T>
implements DocumentModel<T> {
    protected DocumentModelAccess access;
    private boolean needsSync;
    private DocumentListener docListener = new DocumentChangeListener();
    private Document swingDocument;
    private Set<String> elementNames = null;

    public AbstractDocumentModel(ModelSource modelSource) {
        super(modelSource);
    }

    public Document getBaseDocument() {
        return (Document)this.getModelSource().getLookup().lookup(Document.class);
    }

    public abstract T createRootComponent(Element var1);

    @Override
    public boolean areSameNodes(Node node, Node node2) {
        return this.getAccess().areSameNodes(node, node2);
    }

    public Set<QName> getQNames() {
        return Collections.emptySet();
    }

    @Override
    protected boolean needsSync() {
        Document document = this.swingDocument;
        Document document2 = (Document)this.getModelSource().getLookup().lookup(Document.class);
        if (document2 == null) {
            this.swingDocument = null;
            return false;
        }
        if (document == null || document2 != document) {
            this.swingDocument = document2;
            document2.addDocumentListener(new WeakDocumentListener(this.docListener, document2));
        }
        return this.needsSync || !document2.equals(document);
    }

    @Override
    protected void syncStarted() {
        this.needsSync = false;
        this.getAccess().unsetDirty();
    }

    @Override
    protected void syncCompleted() {
        super.syncCompleted();
    }

    private void documentChanged() {
        if (!this.isIntransaction()) {
            this.getAccess().setDirty();
            this.needsSync = true;
        }
    }

    protected abstract ComponentUpdater<T> getComponentUpdater();

    public Set<String> getElementNames() {
        if (this.elementNames == null) {
            this.elementNames = new HashSet<String>();
            Set<QName> set = this.getQNames();
            for (QName qName : set) {
                this.elementNames.add(qName.getLocalPart());
            }
        }
        return this.elementNames;
    }

    public ChangeInfo prepareChangeInfo(List<Node> list) {
        Object object;
        if (list.size() < 1) {
            throw new IllegalArgumentException("pathToRoot here should be at least 1");
        }
        if (list.get(list.size() - 1) instanceof org.w3c.dom.Document) {
            list.remove(list.size() - 1);
        }
        if (list.size() < 2) {
            throw new IllegalArgumentException("pathToRoot here should be at least 2");
        }
        Node node = null;
        Element element = null;
        boolean bl = true;
        Set<QName> set = this.getQNames();
        if (set != null && set.size() > 0) {
            for (int i = list.size() - 1; i >= 0; --i) {
                object = list.get(i);
                element = (Element)node;
                node = object;
                if (!(object instanceof Element)) {
                    bl = false;
                } else {
                    QName qName = new QName(this.getAccess().lookupNamespaceURI(node, list), node.getLocalName());
                    if (set.contains(qName)) continue;
                    bl = false;
                }
                break;
            }
        } else {
            node = list.get(0);
            element = (Element)list.get(1);
            bl = node instanceof Element;
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (element != null) {
            for (int i = list.indexOf(element); i < list.size(); ++i) {
                arrayList.add(0, (Element)list.get(i));
            }
        }
        object = new ArrayList();
        if (element != null) {
            int n = list.indexOf(node);
            for (int i = 0; i < n; ++i) {
                object.add(0, list.get(i));
            }
        }
        return new ChangeInfo(element, node, bl, arrayList, (List<Node>)object);
    }

    public SyncUnit prepareSyncUnit(ChangeInfo changeInfo, SyncUnit syncUnit) {
        if (changeInfo.getChangedNode() == null) {
            throw new IllegalStateException("Bad change info");
        }
        AbstractDocumentComponent abstractDocumentComponent = (AbstractDocumentComponent)changeInfo.getParentComponent();
        if (abstractDocumentComponent == null) {
            abstractDocumentComponent = (AbstractDocumentComponent)this.findComponent(changeInfo.getRootToParentPath());
        }
        if (abstractDocumentComponent == null) {
            throw new IllegalArgumentException("Could not find parent component");
        }
        DocumentComponent documentComponent = null;
        DocumentComponent documentComponent2 = null;
        boolean bl = false;
        if (changeInfo.isDomainElement()) {
            if (changeInfo.isDomainElementAdded()) {
                documentComponent2 = this.createChildComponent(abstractDocumentComponent, changeInfo.getChangedElement());
            } else {
                documentComponent = (DocumentComponent)abstractDocumentComponent.findChildComponent(changeInfo.getChangedElement());
                if (documentComponent == null) {
                    abstractDocumentComponent.findChildComponentByIdentity(changeInfo.getChangedElement());
                }
            }
        } else {
            bl = true;
        }
        if (syncUnit == null) {
            syncUnit = new SyncUnit(abstractDocumentComponent);
        }
        syncUnit.addChange(changeInfo);
        if (documentComponent != null) {
            syncUnit.addToRemoveList(documentComponent);
        }
        if (documentComponent2 != null) {
            syncUnit.addToAddList(documentComponent2);
        }
        if (bl) {
            syncUnit.setComponentChanged(true);
        }
        return syncUnit;
    }

    protected void firePropertyChangedEvents(SyncUnit syncUnit) {
        this.firePropertyChangedEvents(syncUnit, null);
    }

    protected void firePropertyChangedEvents(SyncUnit syncUnit, Element element) {
        Object object;
        Object object2;
        HashSet<String> hashSet = new HashSet<String>(syncUnit.getRemovedAttributes().keySet());
        hashSet.addAll(syncUnit.getAddedAttributes().keySet());
        for (String string : hashSet) {
            object2 = syncUnit.getRemovedAttributes().get(string);
            object = syncUnit.getAddedAttributes().get(string);
            super.firePropertyChangeEvent(new PropertyChangeEvent(syncUnit.getTarget(), string, object2 == null ? null : object2.getValue(), object == null ? null : object.getValue()));
        }
        if (syncUnit.hasTextContentChanges()) {
            super.firePropertyChangeEvent(new PropertyChangeEvent(syncUnit.getTarget(), "textContent", element == null ? "" : this.getAccess().getXmlFragment(element), this.getAccess().getXmlFragment(syncUnit.getTarget().getPeer())));
        }
        for (String string : syncUnit.getNonDomainedElementChanges()) {
            object2 = new ArrayList();
            object = new ArrayList();
            NodeList nodeList = element.getElementsByTagName(string);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                object2.add((Element)element2.cloneNode(true));
            }
            NodeList nodeList2 = syncUnit.getTarget().getPeer().getElementsByTagName(string);
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                object.add((Element)nodeList2.item(i).cloneNode(true));
            }
            super.firePropertyChangeEvent(new PropertyChangeEvent(syncUnit.getTarget(), AbstractDocumentModel.toLocalName(string), object2, object));
        }
    }

    protected static String toLocalName(String string) {
        String[] stringArray = string.split(":");
        return stringArray[stringArray.length - 1];
    }

    public void processSyncUnit(SyncUnit syncUnit) {
        AbstractDocumentComponent abstractDocumentComponent = (AbstractDocumentComponent)syncUnit.getTarget();
        if (abstractDocumentComponent == null) {
            throw new IllegalArgumentException("sync unit should not be null");
        }
        if (!abstractDocumentComponent.isInDocumentModel()) {
            return;
        }
        Element element = syncUnit.getTarget().getPeer();
        syncUnit.updateTargetReference();
        if (syncUnit.isComponentChanged()) {
            ComponentEvent.EventType eventType = ComponentEvent.EventType.VALUE_CHANGED;
            if (!syncUnit.hasWhitespaceChangeOnly()) {
                this.fireComponentChangedEvent(new ComponentEvent(abstractDocumentComponent, eventType));
            }
            this.firePropertyChangedEvents(syncUnit, element);
        }
        for (DocumentComponent documentComponent : syncUnit.getToRemoveList()) {
            this.removeChildComponent(documentComponent);
        }
        for (DocumentComponent documentComponent : syncUnit.getToAddList()) {
            Element element2 = ((AbstractDocumentComponent)documentComponent).getPeer();
            int n = abstractDocumentComponent.findDomainIndex(element2);
            this.addChildComponent(abstractDocumentComponent, documentComponent, n);
        }
    }

    private DocumentComponent createChildComponent(DocumentComponent documentComponent, Element element) {
        DocumentModel documentModel = (DocumentModel)documentComponent.getModel();
        if (documentModel == null) {
            throw new IllegalArgumentException("Cannot create child component from a deleted component.");
        }
        return documentModel.createComponent(documentComponent, element);
    }

    @Override
    public void addChildComponent(Component component, Component component2, int n) {
        AbstractDocumentModel abstractDocumentModel = (AbstractDocumentModel)component.getModel();
        if (abstractDocumentModel == null) {
            return;
        }
        abstractDocumentModel.getComponentUpdater().update(component, component2, n, ComponentUpdater.Operation.ADD);
    }

    @Override
    public void removeChildComponent(Component component) {
        if (component.getParent() == null) {
            return;
        }
        AbstractDocumentModel abstractDocumentModel = (AbstractDocumentModel)component.getParent().getModel();
        if (abstractDocumentModel == null) {
            return;
        }
        abstractDocumentModel.getComponentUpdater().update(component.getParent(), component, ComponentUpdater.Operation.REMOVE);
    }

    public DocumentComponent findComponent(Element element) {
        return this.findComponent((AbstractDocumentComponent)this.getRootComponent(), element);
    }

    private DocumentComponent findComponent(DocumentComponent documentComponent, Element element) {
        DocumentComponent documentComponent2;
        if (documentComponent.referencesSameNode(element)) {
            return documentComponent;
        }
        for (Object object : documentComponent.getChildren()) {
            documentComponent2 = this.findComponent((DocumentComponent)object, element);
            if (documentComponent2 == null) continue;
            return documentComponent2;
        }
        if (documentComponent instanceof EmbeddableRoot.ForeignParent) {
            for (EmbeddableRoot embeddableRoot : ((EmbeddableRoot.ForeignParent)((Object)documentComponent)).getAdoptedChildren()) {
                if (!(embeddableRoot instanceof DocumentComponent) || (documentComponent2 = this.findComponent((DocumentComponent)((Object)embeddableRoot), element)) == null) continue;
                return documentComponent2;
            }
        }
        return null;
    }

    public DocumentComponent findComponent(List<Element> list) {
        return this.findComponent((AbstractDocumentComponent)this.getRootComponent(), list, 0);
    }

    public AbstractDocumentComponent findComponent(AbstractDocumentComponent abstractDocumentComponent, List<Element> list, int n) {
        if (list == null || list.size() <= n) {
            return null;
        }
        Element element = list.get(n);
        if (abstractDocumentComponent.referencesSameNode(element)) {
            if (list.size() == n + 1) {
                abstractDocumentComponent.checkChildrenPopulated();
                return abstractDocumentComponent;
            }
            for (Object c : abstractDocumentComponent.getChildren()) {
                AbstractDocumentComponent abstractDocumentComponent2 = (AbstractDocumentComponent)c;
                AbstractDocumentComponent abstractDocumentComponent3 = this.findComponent(abstractDocumentComponent2, list, n + 1);
                if (abstractDocumentComponent3 == null) continue;
                return abstractDocumentComponent3;
            }
        }
        return null;
    }

    @Override
    public DocumentComponent findComponent(int n) {
        if (this.getState() != Model.State.VALID) {
            return this.getRootComponent();
        }
        Element element = this.getAccess().getContainingElement(n);
        if (element == null) {
            return this.getRootComponent();
        }
        List<Element> list = null;
        try {
            list = this.getAccess().getPathFromRoot(this.getDocument(), element);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (list == null || list.isEmpty()) {
            return this.findComponent(element);
        }
        return this.findComponent(list);
    }

    @Override
    public String getXPathExpression(DocumentComponent documentComponent) {
        Element element = documentComponent.getPeer();
        return this.getAccess().getXPath(this.getDocument(), element);
    }

    @Override
    public org.w3c.dom.Document getDocument() {
        return this.getAccess().getDocumentRoot();
    }

    @Override
    public DocumentModelAccess getAccess() {
        if (this.access == null) {
            this.access = this.getEffectiveAccessProvider().createModelAccess(this);
            if (!(this.access instanceof ReadOnlyAccess)) {
                this.access.addUndoableEditListener(this);
                this.setIdentifyingAttributes();
            }
        }
        return this.access;
    }

    private DocumentModelAccessProvider getEffectiveAccessProvider() {
        DocumentModelAccessProvider documentModelAccessProvider = (DocumentModelAccessProvider)this.getModelSource().getLookup().lookup(DocumentModelAccessProvider.class);
        return documentModelAccessProvider == null ? AbstractDocumentModel.getAccessProvider() : documentModelAccessProvider;
    }

    public static DocumentModelAccessProvider getAccessProvider() {
        DocumentModelAccessProvider documentModelAccessProvider = (DocumentModelAccessProvider)Lookup.getDefault().lookup(DocumentModelAccessProvider.class);
        if (documentModelAccessProvider == null) {
            return ReadOnlyAccess.Provider.getInstance();
        }
        return documentModelAccessProvider;
    }

    protected void setIdentifyingAttributes() {
        ElementIdentity elementIdentity = this.getAccess().getElementIdentity();
        elementIdentity.addIdentifier("id");
        elementIdentity.addIdentifier("name");
        elementIdentity.addIdentifier("ref");
    }

    protected boolean isDomainElement(Node node) {
        if (!(node instanceof Element)) {
            return false;
        }
        QName qName = new QName(node.getNamespaceURI(), node.getLocalName());
        return this.getQNames().contains(qName) || this.getElementNames().contains(qName.getLocalPart());
    }

    @Override
    protected void refresh() {
        org.w3c.dom.Document document = null;
        try {
            document = this.getDocument();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (document != null && document.getDocumentElement() != null) {
            this.createRootComponent(document.getDocumentElement());
            this.setState(Model.State.VALID);
        }
    }

    public Map<QName, List<QName>> getQNameValuedAttributes() {
        return new HashMap<QName, List<QName>>();
    }

    private class DocumentChangeListener
    implements DocumentListener {
        private DocumentChangeListener() {
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            AbstractDocumentModel.this.documentChanged();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            AbstractDocumentModel.this.documentChanged();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    private static class WeakDocumentListener
    implements DocumentListener {
        private Document source;
        private WeakReference<DocumentListener> delegate;

        public WeakDocumentListener(DocumentListener documentListener, Document document) {
            this.source = document;
            this.delegate = new WeakReference<DocumentListener>(documentListener);
        }

        private DocumentListener getDelegate() {
            DocumentListener documentListener = (DocumentListener)this.delegate.get();
            if (documentListener == null) {
                this.source.removeDocumentListener(this);
            }
            return documentListener;
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            DocumentListener documentListener = this.getDelegate();
            if (documentListener != null) {
                documentListener.removeUpdate(documentEvent);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            DocumentListener documentListener = this.getDelegate();
            if (documentListener != null) {
                documentListener.changedUpdate(documentEvent);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            DocumentListener documentListener = this.getDelegate();
            if (documentListener != null) {
                documentListener.insertUpdate(documentEvent);
            }
        }
    }
}

