/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.text.ChoiceFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.MarkBlockChain;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProvider;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.diff.DiffActionTooltipWindow;
import org.netbeans.modules.versioning.diff.DiffFileEncodingQueryImpl;
import org.netbeans.modules.versioning.diff.DiffMark;
import org.netbeans.modules.versioning.diff.DiffSidebarDiffPanel;
import org.netbeans.modules.versioning.diff.DiffSidebarManager;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DiffSidebar
extends JPanel
implements DocumentListener,
ComponentListener,
FoldHierarchyListener,
FileChangeListener {
    private static final int BAR_WIDTH = 9;
    private static final Logger LOG = Logger.getLogger(DiffSidebar.class.getName());
    private final JTextComponent textComponent;
    private FileObject fileObject;
    private final FoldHierarchy foldHierarchy;
    private final BaseDocument document;
    private boolean sidebarVisible;
    private boolean sidebarTemporarilyDisabled;
    private boolean sidebarInComponentHierarchy;
    private Difference[] currentDiff;
    private DiffMarkProvider markProvider;
    private Color colorAdded = new Color(150, 255, 150);
    private Color colorChanged = new Color(160, 200, 255);
    private Color colorRemoved = new Color(255, 160, 180);
    private Color colorBorder = new Color(102, 102, 102);
    private int originalContentSerial;
    private int originalContentBufferSerial = -1;
    private String originalContentBuffer;
    private RequestProcessor.Task refreshDiffTask;
    private VersioningSystem ownerVersioningSystem;

    public DiffSidebar(JTextComponent jTextComponent, FileObject fileObject) {
        this.textComponent = jTextComponent;
        this.fileObject = fileObject;
        this.foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
        this.document = (BaseDocument)this.textComponent.getDocument();
        this.markProvider = new DiffMarkProvider();
        this.setToolTipText("");
        this.refreshDiffTask = DiffSidebarManager.getInstance().createDiffSidebarTask(new RefreshDiffTask());
        this.setMaximumSize(new Dimension(9, Integer.MAX_VALUE));
    }

    FileObject getFileObject() {
        return this.fileObject;
    }

    private void refreshOriginalContent() {
        File file = this.fileObject != null ? FileUtil.toFile((FileObject)this.fileObject) : null;
        this.ownerVersioningSystem = file != null ? VersioningManager.getInstance().getOwner(file) : null;
        ++this.originalContentSerial;
        this.sidebarTemporarilyDisabled = false;
        this.refreshDiff();
    }

    JTextComponent getTextComponent() {
        return this.textComponent;
    }

    Difference[] getCurrentDiff() {
        return this.currentDiff;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Difference difference = this.getDifferenceAt(mouseEvent);
        return DiffSidebar.getShortDescription(difference);
    }

    static String getShortDescription(Difference difference) {
        if (difference == null) {
            return null;
        }
        switch (difference.getType()) {
            case 1: {
                int n = difference.getSecondEnd() - difference.getSecondStart() + 1;
                return MessageFormat.format(new ChoiceFormat(NbBundle.getMessage(DiffSidebar.class, (String)"TT_LinesAdded")).format(n), n);
            }
            case 2: {
                int n = difference.getFirstEnd() - difference.getFirstStart() + 1;
                return MessageFormat.format(new ChoiceFormat(NbBundle.getMessage(DiffSidebar.class, (String)"TT_LinesChanged")).format(n), n);
            }
            case 0: {
                int n = difference.getFirstEnd() - difference.getFirstStart() + 1;
                return MessageFormat.format(new ChoiceFormat(NbBundle.getMessage(DiffSidebar.class, (String)"TT_LinesDeleted")).format(n), n);
            }
        }
        throw new IllegalStateException("Unknown difference type: " + difference.getType());
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 500 || mouseEvent.isPopupTrigger()) {
            Difference difference = this.getDifferenceAt(mouseEvent);
            if (difference == null) {
                return;
            }
            this.onClick(mouseEvent, difference);
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    private void onClick(MouseEvent mouseEvent, Difference difference) {
        Point point = new Point(mouseEvent.getPoint());
        SwingUtilities.convertPointToScreen(point, this);
        Point point2 = new Point(point);
        SwingUtilities.convertPointFromScreen(point2, this.textComponent);
        this.showTooltipWindow(new Point(point.x - point2.x, point.y), difference);
    }

    private void showTooltipWindow(Point point, Difference difference) {
        DiffActionTooltipWindow diffActionTooltipWindow = new DiffActionTooltipWindow(this, difference);
        diffActionTooltipWindow.show(new Point(point.x, point.y));
    }

    private Difference getDifferenceAt(MouseEvent mouseEvent) {
        Difference difference;
        Difference[] differenceArray = this.currentDiff;
        if (differenceArray == null) {
            return null;
        }
        int n = this.getLineFromMouseEvent(mouseEvent);
        if (n == -1) {
            return null;
        }
        Difference difference2 = this.getDifference(n + 1, differenceArray);
        if (difference2 == null) {
            difference2 = this.getDifference(n, differenceArray);
            if (difference2 != null && difference2.getType() != 0) {
                difference2 = null;
            }
        } else if (difference2.getType() == 0 && (difference = this.getDifference(n, differenceArray)) != null && difference.getType() == 0) {
            difference2 = this.getCloserDifference(mouseEvent, difference, difference2);
        }
        return difference2;
    }

    private Difference getCloserDifference(MouseEvent mouseEvent, Difference difference, Difference difference2) {
        Difference difference3 = difference2;
        JTextComponent jTextComponent = this.textComponent;
        if (jTextComponent != null) {
            BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
            try {
                Rectangle rectangle = baseTextUI.modelToView(jTextComponent, baseTextUI.viewToModel(jTextComponent, new Point(0, mouseEvent.getY())));
                if (rectangle != null && (double)mouseEvent.getY() < rectangle.getY() + rectangle.getHeight() / 2.0) {
                    difference3 = difference;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return difference3;
    }

    void onDiff(final Difference difference) {
        try {
            final DiffController diffController = DiffController.create((StreamSource)new SidebarStreamSource(true), (StreamSource)new SidebarStreamSource(false));
            DiffTopComponent diffTopComponent = new DiffTopComponent(diffController);
            diffTopComponent.setName(NbBundle.getMessage(DiffSidebar.class, (String)"CTL_DiffPanel_Title", (Object[])new Object[]{this.fileObject.getNameExt()}));
            diffTopComponent.open();
            diffTopComponent.requestActive();
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("(void) differencesChanged".equals(propertyChangeEvent.getPropertyName())) {
                        diffController.removePropertyChangeListener((PropertyChangeListener)this);
                        int n = DiffSidebar.this.getDiffIndex(difference);
                        if (n != -1 && n < diffController.getDifferenceCount()) {
                            diffController.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, n);
                        }
                    }
                }
            };
            diffController.addPropertyChangeListener(propertyChangeListener);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private int getDiffIndex(Difference difference) {
        Difference[] differenceArray = this.currentDiff;
        if (differenceArray != null) {
            for (int i = 0; i < differenceArray.length; ++i) {
                if (difference != differenceArray[i]) continue;
                return i;
            }
        }
        return -1;
    }

    private int computeDocumentOffset(int n) {
        int n2 = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)n);
        if (n2 == -1) {
            Element element = this.document.getParagraphElement(0).getParentElement();
            for (n2 = element.getElement(n - 1).getEndOffset(); n2 > this.document.getLength(); --n2) {
            }
        }
        return n2;
    }

    void onRollback(Difference difference) {
        try {
            if (difference.getType() == 1) {
                int n = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)(difference.getSecondStart() - 1));
                int n2 = this.computeDocumentOffset(difference.getSecondEnd());
                this.document.remove(n, n2 - n);
            } else if (difference.getType() == 2) {
                int n = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)(difference.getSecondStart() - 1));
                int n3 = this.computeDocumentOffset(difference.getSecondEnd());
                this.document.replace(n, n3 - n, difference.getFirstText(), null);
            } else {
                int n = this.computeDocumentOffset(difference.getSecondStart());
                String string = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)difference.getSecondStart()) == -1 ? "\n" : "";
                this.document.insertString(n, string + difference.getFirstText(), null);
            }
            this.refreshDiff();
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
    }

    boolean canRollback(Difference difference) {
        int n;
        int n2;
        if (!(this.document instanceof GuardedDocument)) {
            return true;
        }
        if (difference.getType() == 0) {
            n = n2 = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)difference.getSecondStart());
        } else {
            n = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)(difference.getSecondStart() - 1));
            n2 = Utilities.getRowStartFromLineOffset((BaseDocument)this.document, (int)difference.getSecondEnd());
        }
        MarkBlockChain markBlockChain = ((GuardedDocument)this.document).getGuardedBlockChain();
        return (markBlockChain.compareBlock(n, n2) & 1) == 0;
    }

    void onPrevious(Difference difference) {
        int n;
        Difference[] differenceArray = this.currentDiff;
        if (differenceArray != null && (n = this.getDiffIndex(difference)) > -1 && n < differenceArray.length) {
            difference = differenceArray[n - 1];
            Point point = this.scrollToDifference(difference);
            this.showTooltipWindow(point, difference);
            this.textComponent.repaint();
        }
    }

    void onNext(Difference difference) {
        int n;
        Difference[] differenceArray = this.currentDiff;
        if (differenceArray != null && (n = this.getDiffIndex(difference)) > -1 && n < differenceArray.length - 1) {
            difference = differenceArray[n + 1];
            Point point = this.scrollToDifference(difference);
            this.showTooltipWindow(point, difference);
            this.textComponent.repaint();
        }
    }

    private Point scrollToDifference(Difference difference) {
        int n = difference.getSecondStart() - 1;
        int n2 = difference.getSecondEnd() - 1;
        if (n == -1) {
            n = 0;
        }
        if (difference.getType() == 0) {
            n2 = n;
        }
        try {
            EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.textComponent);
            int n3 = editorUI.getLineHeight() * 5;
            int n4 = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)this.textComponent.getDocument()), (int)n);
            int n5 = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)this.textComponent.getDocument()), (int)n2);
            Rectangle rectangle = this.textComponent.getUI().modelToView(this.textComponent, n4);
            Rectangle rectangle2 = this.textComponent.getUI().modelToView(this.textComponent, n5);
            Rectangle rectangle3 = new Rectangle(rectangle.x - n3, rectangle.y - n3, rectangle.x, rectangle2.y - rectangle.y + rectangle2.height + n3 * 2);
            this.textComponent.scrollRectToVisible(rectangle3);
            Point point = new Point(rectangle2.x, rectangle2.y + rectangle2.height + 1);
            SwingUtilities.convertPointToScreen(point, this.textComponent);
            return point;
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.WARNING, "scrollToDifference", badLocationException);
            return null;
        }
    }

    String getMimeType() {
        if (this.textComponent instanceof JEditorPane) {
            return ((JEditorPane)this.textComponent).getContentType();
        }
        return "text/plain";
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileDeleted(FileEvent fileEvent) {
        DataObject dataObject;
        if (this.fileObject != null) {
            this.fileObject.removeFileChangeListener((FileChangeListener)this);
            this.fileObject = null;
        }
        if ((dataObject = (DataObject)this.document.getProperty((Object)"stream")) != null) {
            this.fileObject = dataObject.getPrimaryFile();
        }
        this.fileRenamed(null);
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DiffSidebar.this.refresh();
            }
        });
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    private int getLineFromMouseEvent(MouseEvent mouseEvent) {
        int n = -1;
        EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.textComponent);
        if (editorUI != null) {
            try {
                JTextComponent jTextComponent = editorUI.getComponent();
                if (jTextComponent != null) {
                    BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
                    int n2 = baseTextUI.viewToModel(jTextComponent, new Point(0, mouseEvent.getY()));
                    n = Utilities.getLineOffset((BaseDocument)this.document, (int)n2);
                }
            }
            catch (BadLocationException badLocationException) {
                LOG.log(Level.WARNING, "getLineFromMouseEvent", badLocationException);
            }
        }
        return n;
    }

    void refresh() {
        if (!this.sidebarInComponentHierarchy) {
            return;
        }
        this.shutdown();
        this.initialize();
        this.refreshDiff();
        this.revalidate();
    }

    public void setSidebarVisible(boolean bl) {
        if (this.sidebarVisible == bl) {
            return;
        }
        this.sidebarVisible = bl;
        this.refreshDiff();
        this.revalidate();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.sidebarInComponentHierarchy = true;
        this.initialize();
    }

    @Override
    public void removeNotify() {
        this.shutdown();
        this.sidebarInComponentHierarchy = false;
        super.removeNotify();
    }

    private void initialize() {
        assert (SwingUtilities.isEventDispatchThread());
        this.document.addDocumentListener((DocumentListener)this);
        this.textComponent.addComponentListener(this);
        this.foldHierarchy.addFoldHierarchyListener((FoldHierarchyListener)this);
        this.refreshOriginalContent();
        if (this.fileObject != null) {
            this.fileObject.addFileChangeListener((FileChangeListener)this);
        }
    }

    private void shutdown() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.fileObject != null) {
            this.fileObject.removeFileChangeListener((FileChangeListener)this);
        }
        this.foldHierarchy.removeFoldHierarchyListener((FoldHierarchyListener)this);
        this.textComponent.removeComponentListener(this);
        this.document.removeDocumentListener((DocumentListener)this);
    }

    private Reader getDocumentReader() {
        return Utils.getDocumentReader(this.textComponent.getDocument());
    }

    private void refreshDiff() {
        this.refreshDiffTask.schedule(50);
    }

    MarkProvider getMarkProvider() {
        return this.markProvider;
    }

    static void copyStreamsCloseAll(OutputStream outputStream, InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.close();
        inputStream.close();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.textComponent.getSize();
        dimension.width = this.sidebarVisible ? 9 : 0;
        return dimension;
    }

    @Override
    public void paintComponent(final Graphics graphics) {
        super.paintComponent(graphics);
        this.document.render(new Runnable(){

            public void run() {
                DiffSidebar.this.paintComponentUnderLock(graphics);
            }
        });
    }

    private void paintComponentUnderLock(Graphics graphics) {
        block12: {
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle.y >= 16) {
                rectangle.y -= 16;
                rectangle.height += 16;
            }
            JTextComponent jTextComponent = this.textComponent;
            BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
            EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.textComponent);
            View view = Utilities.getDocumentView((JTextComponent)jTextComponent);
            if (view == null) {
                return;
            }
            graphics.setColor(this.backgroundColor());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            Difference[] differenceArray = this.currentDiff;
            if (differenceArray == null || differenceArray.length == 0) {
                return;
            }
            try {
                int n = baseTextUI.getPosFromY(rectangle.y);
                int n2 = view.getViewIndex(n, Position.Bias.Forward);
                int n3 = view.getViewCount();
                if (n2 < 0 || n2 >= n3) break block12;
                Rectangle rectangle2 = baseTextUI.modelToView(jTextComponent, view.getView(n2).getStartOffset());
                int n4 = rectangle2 == null ? 0 : rectangle2.y;
                int[] nArray = new int[3];
                int n5 = rectangle.y + rectangle.height;
                Element element = baseTextUI.getRootView(jTextComponent).getElement();
                View view2 = view.getView(n2);
                int n6 = element.getElementIndex(view2.getStartOffset());
                if (++n6 == 1 && differenceArray[0].getSecondStart() == 0 && differenceArray[0].getType() == 0) {
                    graphics.setColor(this.getColor(differenceArray[0]));
                    nArray[0] = n4 - editorUI.getLineAscent() / 2;
                    nArray[1] = n4;
                    nArray[2] = n4 + editorUI.getLineAscent() / 2;
                    graphics.fillPolygon(new int[]{0, 9, 0}, nArray, 3);
                }
                for (int i = n2; i < n3; ++i) {
                    Difference difference;
                    view2 = view.getView(i);
                    n6 = element.getElementIndex(view2.getStartOffset());
                    if ((difference = this.getDifference(++n6, differenceArray)) != null) {
                        graphics.setColor(this.getColor(difference));
                        if (difference.getType() == 0) {
                            nArray[0] = n4 + editorUI.getLineAscent();
                            nArray[1] = n4 + editorUI.getLineAscent() * 3 / 2;
                            nArray[2] = n4 + editorUI.getLineAscent() * 2;
                            graphics.fillPolygon(new int[]{2, 9, 2}, nArray, 3);
                            graphics.setColor(this.colorBorder);
                            graphics.drawLine(2, nArray[0], 2, nArray[2] - 1);
                        } else {
                            graphics.fillRect(3, n4, 6, editorUI.getLineHeight());
                            graphics.setColor(this.colorBorder);
                            int n7 = n4 + editorUI.getLineHeight();
                            graphics.drawLine(2, n4, 2, n7);
                            if (difference.getSecondStart() == n6) {
                                graphics.drawLine(2, n4, 8, n4);
                            }
                            graphics.drawLine(2, n7, 8, n7);
                        }
                    }
                    if ((n4 += editorUI.getLineHeight()) < n5) {
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
        }
    }

    private Color getColor(Difference difference) {
        if (difference.getType() == 1) {
            return this.colorAdded;
        }
        if (difference.getType() == 2) {
            return this.colorChanged;
        }
        return this.colorRemoved;
    }

    private Difference getDifference(int n, Difference[] differenceArray) {
        if (n < 0 || differenceArray == null) {
            return null;
        }
        for (int i = 0; i < differenceArray.length; ++i) {
            Difference difference = differenceArray[i];
            if (n < difference.getSecondStart()) {
                return null;
            }
            if (difference.getType() == 0 && n == difference.getSecondStart()) {
                return difference;
            }
            if (n > difference.getSecondEnd()) continue;
            return difference;
        }
        return null;
    }

    private Color backgroundColor() {
        if (this.textComponent != null) {
            return this.textComponent.getBackground();
        }
        return Color.WHITE;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.refreshDiff();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.refreshDiff();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.refreshDiff();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.revalidate();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void foldHierarchyChanged(FoldHierarchyEvent foldHierarchyEvent) {
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getText(VersioningSystem versioningSystem) {
        String string;
        FileObject fileObject;
        File file;
        block9: {
            if (versioningSystem == null) {
                return null;
            }
            Collection<File> collection = DiffSidebar.getFiles(this.fileObject);
            if (collection.isEmpty()) {
                return null;
            }
            file = Utils.getTempFolder();
            fileObject = null;
            Collection<File> collection2 = null;
            DiffFileEncodingQueryImpl diffFileEncodingQueryImpl = null;
            try {
                collection2 = this.checkoutOriginalFiles(collection, file, versioningSystem);
                diffFileEncodingQueryImpl = (DiffFileEncodingQueryImpl)((Object)Lookup.getDefault().lookup(DiffFileEncodingQueryImpl.class));
                Charset charset = FileEncodingQuery.getEncoding((FileObject)this.fileObject);
                if (diffFileEncodingQueryImpl != null) {
                    diffFileEncodingQueryImpl.associateEncoding(charset, collection2);
                }
                File file2 = new File(file, this.fileObject.getNameExt());
                fileObject = FileUtil.toFileObject((File)file2);
                string = DiffSidebar.getText(file2, fileObject, charset);
                if (collection2 == null || diffFileEncodingQueryImpl == null) break block9;
                diffFileEncodingQueryImpl.resetEncodingForFiles(collection2);
            }
            catch (Exception exception) {
                String string2 = null;
                return string2;
            }
            finally {
                if (collection2 != null && diffFileEncodingQueryImpl != null) {
                    diffFileEncodingQueryImpl.resetEncodingForFiles(collection2);
                }
                DiffSidebar.deleteTempFolder(file, fileObject);
            }
        }
        DiffSidebar.deleteTempFolder(file, fileObject);
        return string;
    }

    private static Collection<File> getFiles(FileObject fileObject) {
        Collection<File> collection;
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return Collections.emptyList();
        }
        try {
            Set set = DataObject.find((FileObject)fileObject).files();
            assert (set.contains(fileObject));
            if (set.size() == 1) {
                collection = Collections.singleton(file);
            } else {
                collection = new ArrayList(set.size());
                for (FileObject fileObject2 : set) {
                    collection.add(FileUtil.toFile((FileObject)fileObject2));
                }
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            collection = Collections.singleton(file);
        }
        assert (collection.contains(file));
        return collection;
    }

    private Collection<File> checkoutOriginalFiles(Collection<File> collection, File file, VersioningSystem versioningSystem) {
        ArrayList<File> arrayList = new ArrayList<File>(collection.size());
        for (File file2 : collection) {
            File file3 = new File(file, file2.getName());
            versioningSystem.getOriginalFile(file2, file3);
            arrayList.add(file3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getText(File file, FileObject fileObject, Charset charset) throws IOException {
        if (fileObject == null) return DiffSidebar.getRawText(file, charset);
        try {
            EditorCookie editorCookie = DiffSidebar.getEditorCookie(fileObject);
            if (editorCookie == null) return DiffSidebar.getRawText(fileObject, charset);
            try {
                StyledDocument styledDocument;
                try {
                    styledDocument = editorCookie.openDocument();
                }
                catch (UserQuestionException userQuestionException) {
                    userQuestionException.confirmed();
                    styledDocument = editorCookie.openDocument();
                }
                String string = styledDocument.getText(0, styledDocument.getLength());
                return string;
            }
            finally {
                editorCookie.close();
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DiffSidebar.getRawText(file, charset);
    }

    private static EditorCookie getEditorCookie(FileObject fileObject) throws IOException {
        MultiDataObject.Entry entry;
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
        if (dataObject instanceof MultiDataObject && (entry = DiffSidebar.findEntryForFile((MultiDataObject)dataObject, fileObject)) != null && entry instanceof CookieSet.Factory) {
            CookieSet.Factory factory = (CookieSet.Factory)entry;
            return (EditorCookie)factory.createCookie(EditorCookie.class);
        }
        return (EditorCookie)dataObject.getCookie(EditorCookie.class);
    }

    private static MultiDataObject.Entry findEntryForFile(MultiDataObject multiDataObject, FileObject fileObject) {
        MultiDataObject.Entry entry = multiDataObject.getPrimaryEntry();
        if (fileObject.equals(entry.getFile())) {
            return entry;
        }
        for (MultiDataObject.Entry entry2 : multiDataObject.secondaryEntries()) {
            if (!fileObject.equals(entry2.getFile())) continue;
            return entry;
        }
        return null;
    }

    private static String getRawText(FileObject fileObject, Charset charset) throws IOException {
        char[] cArray = new StringDecoder(charset).decode(fileObject.asBytes());
        return new String(cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRawText(File file, Charset charset) throws IOException {
        long l = file.length();
        if (l == 0L) {
            return file.exists() ? "" : null;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        try {
            int n = (int)fileChannel.size();
            ByteBuffer byteBuffer = ByteBuffer.allocate(n);
            fileChannel.read(byteBuffer);
            char[] cArray = new StringDecoder(charset).decode(byteBuffer);
            String string = new String(cArray);
            return string;
        }
        finally {
            fileChannel.close();
        }
    }

    private static void deleteTempFolder(File file, FileObject fileObject) {
        boolean bl = false;
        if (fileObject != null) {
            try {
                FileObject fileObject2 = fileObject.getParent();
                if (fileObject2 != null) {
                    fileObject2.delete();
                    bl = true;
                } else {
                    fileObject.delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!bl) {
            Utils.deleteRecursively(file);
        }
    }

    static /* synthetic */ Difference[] access$202(DiffSidebar diffSidebar, Difference[] differenceArray) {
        diffSidebar.currentDiff = differenceArray;
        return differenceArray;
    }

    private class SidebarStreamSource
    extends StreamSource {
        private final boolean isFirst;

        public SidebarStreamSource(boolean bl) {
            this.isFirst = bl;
        }

        public boolean isEditable() {
            return !this.isFirst;
        }

        public Lookup getLookup() {
            if (this.isFirst) {
                return super.getLookup();
            }
            return Lookups.fixed((Object[])new Object[]{DiffSidebar.this.document});
        }

        public String getName() {
            return DiffSidebar.this.fileObject.getNameExt();
        }

        public String getTitle() {
            if (this.isFirst) {
                return NbBundle.getMessage(DiffSidebar.class, (String)"LBL_DiffPane_Original");
            }
            return NbBundle.getMessage(DiffSidebar.class, (String)"LBL_DiffPane_WorkingCopy");
        }

        public String getMIMEType() {
            return DiffSidebar.this.getMimeType();
        }

        public Reader createReader() throws IOException {
            return this.isFirst ? new StringReader(DiffSidebar.this.originalContentBuffer) : DiffSidebar.this.getDocumentReader();
        }

        public Writer createWriter(Difference[] differenceArray) throws IOException {
            return null;
        }
    }

    private static final class StringDecoder {
        private final CharsetDecoder charsetDecoder;

        StringDecoder(Charset charset) {
            this.charsetDecoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }

        char[] decode(byte[] byArray) {
            if (byArray.length == 0) {
                return new char[0];
            }
            return this.decode(ByteBuffer.wrap(byArray));
        }

        char[] decode(ByteBuffer byteBuffer) {
            char[] cArray = new char[this.computeOutBufSize(byteBuffer.limit())];
            CharBuffer charBuffer = CharBuffer.wrap(cArray);
            this.charsetDecoder.reset();
            try {
                CoderResult coderResult = this.charsetDecoder.decode(byteBuffer, charBuffer, true);
                if (!coderResult.isUnderflow()) {
                    coderResult.throwException();
                }
                if (!(coderResult = this.charsetDecoder.flush(charBuffer)).isUnderflow()) {
                    coderResult.throwException();
                }
            }
            catch (CharacterCodingException characterCodingException) {
                assert (false);
                throw new Error(characterCodingException);
            }
            if (cArray.length != charBuffer.position()) {
                cArray = StringDecoder.trimToSize(cArray, charBuffer.position());
            }
            return cArray;
        }

        private int computeOutBufSize(int n) {
            float f = this.charsetDecoder.maxCharsPerByte();
            return (int)Math.ceil((double)n * (double)f);
        }

        private static char[] trimToSize(char[] cArray, int n) {
            if (n > cArray.length) {
                throw new IllegalArgumentException();
            }
            if (n == cArray.length) {
                return cArray;
            }
            char[] cArray2 = new char[n];
            System.arraycopy(cArray, 0, cArray2, 0, n);
            return cArray2;
        }
    }

    public class RefreshDiffTask
    implements Runnable {
        public void run() {
            this.computeDiff();
            DiffSidebar.this.repaint();
            DiffSidebar.this.markProvider.refresh();
        }

        private void computeDiff() {
            if (!DiffSidebar.this.sidebarVisible || DiffSidebar.this.sidebarTemporarilyDisabled) {
                DiffSidebar.access$202(DiffSidebar.this, null);
                return;
            }
            this.fetchOriginalContent();
            if (DiffSidebar.this.originalContentBuffer == null) {
                DiffSidebar.access$202(DiffSidebar.this, null);
                return;
            }
            Reader reader = DiffSidebar.this.getDocumentReader();
            if (reader == null) {
                return;
            }
            DiffProvider diffProvider = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
            if (diffProvider == null) {
                DiffSidebar.access$202(DiffSidebar.this, null);
                return;
            }
            try {
                DiffSidebar.access$202(DiffSidebar.this, diffProvider.computeDiff((Reader)new StringReader(DiffSidebar.this.originalContentBuffer), reader));
            }
            catch (IOException iOException) {
                DiffSidebar.access$202(DiffSidebar.this, null);
            }
        }

        private void fetchOriginalContent() {
            int n = DiffSidebar.this.originalContentSerial;
            if (DiffSidebar.this.originalContentBuffer != null && DiffSidebar.this.originalContentBufferSerial == n) {
                return;
            }
            DiffSidebar.this.originalContentBufferSerial = n;
            DiffSidebar.this.originalContentBuffer = DiffSidebar.this.getText(DiffSidebar.this.ownerVersioningSystem);
            if (DiffSidebar.this.originalContentBuffer == null) {
                DiffSidebar.this.sidebarTemporarilyDisabled = true;
                LOG.log(Level.FINE, "Disabling diffsidebar for {0}, no content available", DiffSidebar.this.fileObject.getPath());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DiffMarkProvider
    extends MarkProvider {
        private List<DiffMark> marks = this.getMarksForDifferences();

        public List getMarks() {
            return this.marks;
        }

        void refresh() {
            List<DiffMark> list = this.marks;
            this.marks = this.getMarksForDifferences();
            this.firePropertyChange("marks", list, this.marks);
        }

        private List<DiffMark> getMarksForDifferences() {
            if (DiffSidebar.this.currentDiff == null || !DiffSidebar.this.isVisible() || DiffSidebar.this.getWidth() <= 0) {
                return Collections.emptyList();
            }
            ArrayList<DiffMark> arrayList = new ArrayList<DiffMark>(DiffSidebar.this.currentDiff.length);
            for (int i = 0; i < DiffSidebar.this.currentDiff.length; ++i) {
                Difference difference = DiffSidebar.this.currentDiff[i];
                arrayList.add(new DiffMark(difference, DiffSidebar.this.getColor(difference)));
            }
            return arrayList;
        }
    }

    private static class DiffTopComponent
    extends TopComponent {
        private JComponent diffView;

        public DiffTopComponent() {
        }

        public DiffTopComponent(DiffController diffController) {
            this.diffView = diffController.getJComponent();
            this.setLayout(new BorderLayout());
            this.diffView.putClientProperty(TopComponent.class, (Object)this);
            DiffSidebarDiffPanel diffSidebarDiffPanel = new DiffSidebarDiffPanel(diffController);
            this.add(diffSidebarDiffPanel);
        }

        public UndoRedo getUndoRedo() {
            UndoRedo undoRedo = (UndoRedo)this.diffView.getClientProperty(UndoRedo.class);
            return undoRedo == null ? UndoRedo.NONE : undoRedo;
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return "DiffSidebarTopComponent";
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(((Object)((Object)this)).getClass());
        }
    }
}

