/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import proguard.WordReader;

public class FileWordReader
extends WordReader {
    private final String name;
    private LineNumberReader reader;

    public FileWordReader(File file) throws IOException {
        super(file.getParentFile());
        this.name = file.getPath();
        this.reader = new LineNumberReader(new BufferedReader(new FileReader(file)));
    }

    public FileWordReader(URL uRL) throws IOException {
        super(null);
        this.name = uRL.toString();
        this.reader = new LineNumberReader(new BufferedReader(new InputStreamReader(uRL.openStream())));
    }

    protected String nextLine() throws IOException {
        return this.reader.readLine();
    }

    protected String lineLocationDescription() {
        return "line " + this.reader.getLineNumber() + " of file '" + this.name + "'";
    }

    public void close() throws IOException {
        super.close();
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

