/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.util.Vector;
import org.netbeans.lib.terminalemulator.BCoord;
import org.netbeans.lib.terminalemulator.BExtent;
import org.netbeans.lib.terminalemulator.Line;
import org.netbeans.lib.terminalemulator.LineVisitor;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.lib.terminalemulator.WordDelineator;

class Buffer {
    private OurVector<Line> lines = new OurVector();
    public int nlines;
    private int visible_cols;
    private int extra_cols;

    public int visibleCols() {
        return this.visible_cols;
    }

    public int totalCols() {
        return this.visible_cols + this.extra_cols;
    }

    public Buffer(int n) {
        this.visible_cols = n;
    }

    public void setVisibleCols(int n) {
        int n2 = n - this.visible_cols;
        this.visible_cols = n;
        this.extra_cols -= n2;
        if (this.extra_cols < 0) {
            this.extra_cols = 0;
        }
    }

    public void noteColumn(int n) {
        int n2 = n - this.visible_cols;
        if (n2 > this.extra_cols) {
            this.extra_cols = n2;
        }
    }

    Line lineAt(int n) {
        try {
            return (Line)this.lines.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    Line bottom() {
        return this.lineAt(this.nlines);
    }

    public Line appendLine() {
        Line line = new Line();
        this.lines.add(line);
        ++this.nlines;
        return line;
    }

    public Line addLineAt(int n) {
        Line line = new Line();
        this.lines.add(n, line);
        ++this.nlines;
        return line;
    }

    public int removeLinesAt(int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            n3 += this.lineAt(i).length() + 1;
        }
        this.lines.removeRange(n, n + n2);
        this.nlines -= n2;
        return n3;
    }

    public void removeLineAt(int n) {
        this.lines.remove(n);
        --this.nlines;
    }

    public Line moveLineFromTo(int n, int n2) {
        Line line = (Line)this.lines.remove(n);
        this.lines.add(n2, line);
        return line;
    }

    void visitLines(BCoord bCoord, BCoord bCoord2, boolean bl, LineVisitor lineVisitor) {
        if (bCoord.row == bCoord2.row) {
            Line line = this.lineAt(bCoord.row);
            lineVisitor.visit(line, bCoord.row, bCoord.col, bCoord2.col);
        } else {
            boolean bl2 = false;
            Line line = this.lineAt(bCoord.row);
            bl2 = bl && !line.isWrapped() ? lineVisitor.visit(line, bCoord.row, bCoord.col, this.totalCols()) : lineVisitor.visit(line, bCoord.row, bCoord.col, line.length() - 1);
            if (!bl2) {
                return;
            }
            for (int i = bCoord.row + 1; i < bCoord2.row; ++i) {
                line = this.lineAt(i);
                bl2 = bl && !line.isWrapped() ? lineVisitor.visit(line, i, 0, this.totalCols()) : lineVisitor.visit(line, i, 0, line.length() - 1);
                if (bl2) continue;
                return;
            }
            line = this.lineAt(bCoord2.row);
            bl2 = lineVisitor.visit(line, bCoord2.row, 0, bCoord2.col);
            if (!bl2) {
                return;
            }
        }
    }

    void reverseVisitLines(BCoord bCoord, BCoord bCoord2, boolean bl, LineVisitor lineVisitor) {
        if (bCoord.row == bCoord2.row) {
            Line line = this.lineAt(bCoord.row);
            lineVisitor.visit(line, bCoord.row, bCoord.col, bCoord2.col);
        } else {
            boolean bl2 = false;
            Line line = this.lineAt(bCoord2.row);
            bl2 = lineVisitor.visit(line, bCoord2.row, 0, bCoord2.col);
            if (!bl2) {
                return;
            }
            for (int i = bCoord2.row - 1; i > bCoord.row; --i) {
                line = this.lineAt(i);
                bl2 = bl && !line.isWrapped() ? lineVisitor.visit(line, i, 0, this.totalCols()) : lineVisitor.visit(line, i, 0, line.length() - 1);
                if (bl2) continue;
                return;
            }
            line = this.lineAt(bCoord.row);
            bl2 = bl && !line.isWrapped() ? lineVisitor.visit(line, bCoord.row, bCoord.col, this.totalCols()) : lineVisitor.visit(line, bCoord.row, bCoord.col, line.length() - 1);
            if (!bl2) {
                return;
            }
        }
    }

    public BExtent find_word(WordDelineator wordDelineator, BCoord bCoord) {
        Line line = this.lineAt(bCoord.row);
        if (bCoord.col >= line.length()) {
            return new BExtent(bCoord, bCoord);
        }
        int n = wordDelineator.findLeft(line.stringBuffer(), bCoord.col);
        int n2 = wordDelineator.findRight(line.stringBuffer(), bCoord.col);
        return new BExtent(new BCoord(bCoord.row, n), new BCoord(bCoord.row, n2));
    }

    public BCoord backup(BCoord bCoord) {
        if (bCoord.col > 0) {
            return new BCoord(bCoord.row, bCoord.col - 1);
        }
        for (int i = bCoord.row - 1; i >= 0; --i) {
            Line line = this.lineAt(i);
            if (line.length() == 0) continue;
            return new BCoord(i, line.length() - 1);
        }
        return null;
    }

    public BCoord advance(BCoord bCoord) {
        int n = bCoord.row;
        int n2 = bCoord.col;
        Line line = this.lineAt(n);
        if (++n2 < line.length()) {
            return new BCoord(n, n2);
        }
        while (++n < this.nlines) {
            line = this.lineAt(n);
            if (line.length() == 0) continue;
            return new BCoord(n, 0);
        }
        return null;
    }

    private int utilization(int n, int n2) {
        float f = (float)n / (float)n2;
        float f2 = f * 100.0f;
        return (int)f2;
    }

    public void printStats(boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < this.nlines; ++i) {
            Line line = this.lineAt(i);
            n += line.length();
            n2 += line.capacity();
            if (!line.hasAttributes()) continue;
            ++n3;
            n4 += line.length();
            n5 += line.capacity();
        }
        Term.indent(bl);
        System.out.println("Buffer:  nlines " + this.nlines);
        Term.indent(bl);
        System.out.println("         chars " + n + "  charcapacity " + n2 + "  utilzn %" + this.utilization(n, n2));
        Term.indent(bl);
        System.out.println("         attrs " + n4 + "  attrcapacity " + n5 + "  utilzn %" + this.utilization(n4, n5));
        long l = 0L;
        long l2 = 40L;
        l += l2 * (long)this.nlines;
        l += (long)(12 * this.nlines);
        l += (long)(2 * n2);
        l += (long)(12 * n3);
        Term.indent(bl);
        System.out.println("         bytes " + (l += (long)(4 * n5)) / 1024L + "K");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OurVector<T>
    extends Vector<T> {
        OurVector() {
        }

        @Override
        public void removeRange(int n, int n2) {
            super.removeRange(n, n2);
        }
    }
}

