/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.editor.ext.html.parser.AstNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstPath {
    private AstNode first;
    private AstNode last;

    AstPath(AstNode astNode, AstNode astNode2) {
        this.first = astNode;
        this.last = astNode2;
    }

    public AstNode first() {
        return this.first;
    }

    public AstNode last() {
        return this.last;
    }

    public List<AstNode> path() {
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        for (AstNode astNode = this.last; astNode != null; astNode = astNode.parent()) {
            arrayList.add(astNode);
            if (astNode == this.first) break;
        }
        return arrayList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (AstNode astNode : this.path()) {
            AstNode astNode2 = astNode.parent();
            int n = astNode2 == null ? 0 : AstPath.indexInSimilarNodes(astNode.parent(), astNode);
            stringBuilder.append(astNode.name() + "[" + (Object)((Object)astNode.type()) + "]( " + n + ")/");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AstPath)) {
            return false;
        }
        AstPath astPath = (AstPath)object;
        List<AstNode> list = this.path();
        List<AstNode> list2 = astPath.path();
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            int n;
            AstNode astNode = list.get(i);
            AstNode astNode2 = list2.get(i);
            AstNode astNode3 = astNode.parent();
            AstNode astNode4 = astNode2.parent();
            if (astNode3 == null && astNode4 == null) continue;
            int n2 = AstPath.indexInSimilarNodes(astNode3, astNode);
            if (n2 != (n = AstPath.indexInSimilarNodes(astNode4, astNode2))) {
                return false;
            }
            if (astNode.signature().equals(astNode2.signature())) continue;
            return false;
        }
        return true;
    }

    public static int indexInSimilarNodes(AstNode astNode, AstNode astNode2) {
        int n = -1;
        for (AstNode astNode3 : astNode.children()) {
            if (astNode2.name().equals(astNode3.name()) && astNode2.type() == astNode3.type()) {
                ++n;
            }
            if (astNode3 != astNode2) continue;
            break;
        }
        return n;
    }

    public int hashCode() {
        int n = 7;
        n = 47 * n + (this.first != null ? this.first.hashCode() : 0);
        n = 47 * n + (this.last != null ? this.last.hashCode() : 0);
        return n;
    }

    public static boolean isDescendant(AstNode astNode, AstNode astNode2) {
        if (astNode == astNode2) {
            return false;
        }
        AstNode astNode3 = astNode2;
        while ((astNode3 = astNode3.parent()) != null) {
            if (astNode != astNode3) continue;
            return true;
        }
        return false;
    }
}

