/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.edit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.Watch;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.NotifyRequest;

public class EditCommand
extends BasicCommand {
    private boolean checkThatUnedited;
    private boolean forceEvenIfEdited;
    private Watch temporaryWatch;
    private transient ClientServices clientServices;

    public static File getEditBackupFile(File file) {
        return new File(file.getParent(), "CVS/Base/" + file.getName());
    }

    public EditCommand() {
        this.resetCVSCommand();
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException {
        this.clientServices = clientServices;
        try {
            clientServices.ensureConnection();
            super.execute(clientServices, eventManager);
            this.addArgumentRequest(this.isCheckThatUnedited(), "-c");
            this.addArgumentRequest(this.isForceEvenIfEdited(), "-f");
            this.addRequestForWorkingDirectory(clientServices);
            this.addRequest(CommandRequest.NOOP);
            clientServices.processRequests(this.requests);
        }
        catch (AuthenticationException authenticationException) {
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (EOFException eOFException) {
            throw new CommandException(eOFException, CommandException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
        finally {
            this.requests.clear();
            this.clientServices = null;
        }
    }

    protected void addRequestForFile(File file, Entry entry) {
        String string = Watch.getWatchString(this.getTemporaryWatch());
        this.requests.add(new NotifyRequest(file, "E", string));
        try {
            this.editFile(this.clientServices, file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void commandTerminated(TerminationEvent terminationEvent) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("edit ");
        stringBuffer.append(this.getCVSArguments());
        this.appendFileArguments(stringBuffer);
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "Rl";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setCheckThatUnedited(false);
        this.setForceEvenIfEdited(true);
        this.setTemporaryWatch(null);
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        return stringBuffer.toString();
    }

    public boolean isCheckThatUnedited() {
        return this.checkThatUnedited;
    }

    public void setCheckThatUnedited(boolean bl) {
        this.checkThatUnedited = bl;
    }

    public boolean isForceEvenIfEdited() {
        return this.forceEvenIfEdited;
    }

    public void setForceEvenIfEdited(boolean bl) {
        this.forceEvenIfEdited = bl;
    }

    public Watch getTemporaryWatch() {
        return this.temporaryWatch;
    }

    public void setTemporaryWatch(Watch watch) {
        this.temporaryWatch = watch;
    }

    private void editFile(ClientServices clientServices, File file) throws IOException {
        this.addBaserevEntry(clientServices, file);
        FileUtils.copyFile(file, EditCommand.getEditBackupFile(file));
        FileUtils.setFileReadOnly(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBaserevEntry(ClientServices clientServices, File file) throws IOException {
        Entry entry = clientServices.getEntry(file);
        if (entry == null || entry.getRevision() == null || entry.isNewUserFile() || entry.isUserFileToBeRemoved()) {
            throw new IllegalArgumentException("File does not have an Entry or Entry is invalid!");
        }
        File file2 = new File(file.getParentFile(), "CVS/Baserev");
        File file3 = new File(file2.getAbsolutePath() + '~');
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        boolean bl = true;
        boolean bl2 = true;
        String string = 'B' + file.getName() + '/';
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file3));
            bl2 = false;
            bufferedReader = new BufferedReader(new FileReader(file2));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.startsWith(string)) {
                    bl = false;
                }
                bl2 = true;
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                bl2 = false;
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            if (bl2) {
                throw iOException;
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedWriter != null) {
                block36: {
                    try {
                        if (!bl || bl2) break block36;
                        bufferedWriter.write(string + entry.getRevision() + '/');
                        bufferedWriter.newLine();
                    }
                    catch (Throwable throwable) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                }
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
        file2.delete();
        file3.renameTo(file2);
    }
}

