/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.phpmodule.PhpInterpreter;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleExtender;
import org.netbeans.modules.php.symfony.SymfonyPhpFrameworkProvider;
import org.netbeans.modules.php.symfony.SymfonyScript;
import org.netbeans.modules.php.symfony.ui.wizards.NewProjectConfigurationPanel;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymfonyPhpModuleExtender
extends PhpModuleExtender {
    private NewProjectConfigurationPanel panel = null;

    public Set<FileObject> extend(PhpModule phpModule) throws PhpModuleExtender.ExtendingException {
        FileObject fileObject;
        FileObject fileObject2;
        SymfonyScript symfonyScript = null;
        try {
            symfonyScript = SymfonyScript.getDefault();
        }
        catch (PhpProgram.InvalidPhpProgramException invalidPhpProgramException) {
            Exceptions.printStackTrace((Throwable)invalidPhpProgramException);
        }
        assert (symfonyScript.isValid()) : "Symfony script has to be valid!";
        if (!symfonyScript.initProject(phpModule, this.getPanel().getProjectParams())) {
            Logger.getLogger(SymfonyPhpModuleExtender.class.getName()).info("Framework Symfony not found in newly created project " + phpModule.getDisplayName());
            throw new PhpModuleExtender.ExtendingException(NbBundle.getMessage(SymfonyPhpModuleExtender.class, (String)"MSG_NotExtended"));
        }
        for (Pair<String, String[]> fileObject32 : this.getPanel().getApps()) {
            symfonyScript.initApp(phpModule, (String)fileObject32.first, (String[])fileObject32.second);
        }
        SymfonyPhpFrameworkProvider.getInstance().getFrameworkCommandSupport(phpModule).refreshFrameworkCommandsLater(null);
        HashSet hashSet = new HashSet();
        FileObject fileObject3 = phpModule.getSourceDirectory().getFileObject("config/databases.yml");
        if (fileObject3 != null) {
            hashSet.add(fileObject3);
        }
        if ((fileObject2 = phpModule.getSourceDirectory().getFileObject("config/ProjectConfiguration.class.php")) != null) {
            hashSet.add(fileObject2);
        }
        if (hashSet.isEmpty() && (fileObject = phpModule.getSourceDirectory().getFileObject("web/index.php")) != null) {
            hashSet.add(fileObject);
        }
        return hashSet;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.getPanel().addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.getPanel().removeChangeListener(changeListener);
    }

    public JComponent getComponent() {
        return this.getPanel();
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        return this.getErrorMessage() == null;
    }

    public String getErrorMessage() {
        try {
            PhpInterpreter.getDefault();
        }
        catch (PhpProgram.InvalidPhpProgramException invalidPhpProgramException) {
            return invalidPhpProgramException.getLocalizedMessage();
        }
        try {
            SymfonyScript.getDefault();
        }
        catch (PhpProgram.InvalidPhpProgramException invalidPhpProgramException) {
            return NbBundle.getMessage(SymfonyPhpModuleExtender.class, (String)"MSG_CannotExtend", (Object)invalidPhpProgramException.getMessage());
        }
        return this.getPanel().getErrorMessage();
    }

    public String getWarningMessage() {
        return this.getPanel().getWarningMessage();
    }

    private synchronized NewProjectConfigurationPanel getPanel() {
        if (this.panel == null) {
            this.panel = new NewProjectConfigurationPanel();
        }
        return this.panel;
    }
}

