/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.progress.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.progress.spi.RunOffEDTProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class RunOffEDTImpl
implements RunOffEDTProvider {
    private static final RequestProcessor WORKER = new RequestProcessor(ProgressUtils.class.getName());
    private static final Map<Class<? extends Runnable>, Integer> OPERATIONS = new WeakHashMap<Class<? extends Runnable>, Integer>();
    private static final int CLEAR_TIME = 100;
    private static final int CANCEL_TIME = 1000;
    private static final int WARNING_TIME = Integer.getInteger("org.netbeans.modules.progress.ui.WARNING_TIME", 10000);
    private static final Logger LOG = Logger.getLogger(RunOffEDTImpl.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOffEventDispatchThread(Runnable runnable, String string, AtomicBoolean atomicBoolean, boolean bl, int n, int n2) {
        Parameters.notNull((CharSequence)"operation", (Object)runnable);
        Parameters.notNull((CharSequence)"cancelOperation", (Object)atomicBoolean);
        if (!SwingUtilities.isEventDispatchThread()) {
            runnable.run();
            return;
        }
        long l = System.currentTimeMillis();
        this.runOffEventDispatchThreadImpl(runnable, string, atomicBoolean, bl, n, n2);
        int n3 = (int)(System.currentTimeMillis() - l);
        boolean bl2 = false;
        if (!$assertionsDisabled) {
            bl2 = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl2) {
            Class<?> clazz = runnable.getClass();
            Map<Class<? extends Runnable>, Integer> map = OPERATIONS;
            synchronized (map) {
                if (n3 < 100) {
                    OPERATIONS.remove(clazz);
                } else {
                    Integer n4 = OPERATIONS.get(runnable.getClass());
                    if (n4 != null && n3 + n4 > WARNING_TIME) {
                        LOG.log(Level.WARNING, "Operation is too slow", new Exception(clazz + " is too slow"));
                    }
                    OPERATIONS.put(clazz, n3);
                }
            }
        }
    }

    private void runOffEventDispatchThreadImpl(final Runnable runnable, String string, final AtomicBoolean atomicBoolean, boolean bl, int n, int n2) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference<Dialog> atomicReference = new AtomicReference<Dialog>();
        WORKER.post(new Runnable(){

            public void run() {
                if (atomicBoolean.get()) {
                    return;
                }
                runnable.run();
                countDownLatch.countDown();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Dialog dialog = (Dialog)atomicReference.get();
                        if (dialog != null) {
                            dialog.setVisible(false);
                        }
                    }
                });
            }
        });
        Component component = ((JFrame)WindowManager.getDefault().getMainWindow()).getGlassPane();
        if (RunOffEDTImpl.waitMomentarily(component, null, n, countDownLatch)) {
            return;
        }
        Cursor cursor = Cursor.getPredefinedCursor(3);
        if (RunOffEDTImpl.waitMomentarily(component, cursor, n2, countDownLatch)) {
            return;
        }
        String string2 = NbBundle.getMessage(RunOffEDTImpl.class, (String)"RunOffAWT.TITLE_Operation");
        String string3 = NbBundle.getMessage(RunOffEDTImpl.class, (String)"RunOffAWT.BTN_Cancel");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)string, string2, true, new Object[]{string3}, (Object)string3, 0, null, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                atomicBoolean.set(true);
                ((Dialog)atomicReference.get()).setVisible(false);
            }
        });
        dialogDescriptor.setMessageType(1);
        atomicReference.set(DialogDisplayer.getDefault().createDialog(dialogDescriptor));
        ((Dialog)atomicReference.get()).setVisible(true);
        if (bl) {
            try {
                if (!countDownLatch.await(1000L, TimeUnit.MILLISECONDS)) {
                    throw new IllegalStateException("Canceled operation did not finish in time.");
                }
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.FINE, null, interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitMomentarily(Component component, Cursor cursor, int n, CountDownLatch countDownLatch) {
        Cursor cursor2 = component.getCursor();
        try {
            if (cursor != null) {
                component.setCursor(cursor);
            }
            component.setVisible(true);
            try {
                boolean bl = countDownLatch.await(n, TimeUnit.MILLISECONDS);
                return bl;
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.FINE, null, interruptedException);
                boolean bl = true;
                component.setVisible(false);
                component.setCursor(cursor2);
                return bl;
            }
        }
        finally {
            component.setVisible(false);
            component.setCursor(cursor2);
        }
    }
}

