/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.spi.project.support.rake;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyProvider;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilterPropertyProvider
implements PropertyProvider {
    private PropertyProvider delegate;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final ChangeListener strongListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            FilterPropertyProvider.this.fireChange();
        }
    };
    private ChangeListener weakListener = null;

    protected FilterPropertyProvider(PropertyProvider propertyProvider) {
        assert (propertyProvider != null);
        this.setDelegate(propertyProvider);
    }

    protected final void setDelegate(PropertyProvider propertyProvider) {
        if (propertyProvider == this.delegate) {
            return;
        }
        if (this.delegate != null) {
            assert (this.weakListener != null);
            this.delegate.removeChangeListener(this.weakListener);
        }
        this.delegate = propertyProvider;
        this.weakListener = WeakListeners.change((ChangeListener)this.strongListener, (Object)propertyProvider);
        propertyProvider.addChangeListener(this.weakListener);
        this.fireChange();
    }

    @Override
    public final Map<String, String> getProperties() {
        return this.delegate.getProperties();
    }

    @Override
    public final synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    @Override
    public final synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ChangeListener[] changeListenerArray;
        Object object = this;
        synchronized (object) {
            if (this.listeners.isEmpty()) {
                return;
            }
            changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        object = new ChangeEvent(this);
        for (ChangeListener changeListener : changeListenerArray) {
            changeListener.stateChanged((ChangeEvent)object);
        }
    }
}

