/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.nodes;

import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.DBElement;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.IndexElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.nodes.ColumnElementNode;
import org.netbeans.modules.dbschema.nodes.ColumnPairElementNode;
import org.netbeans.modules.dbschema.nodes.DBElementNodeFactory;
import org.netbeans.modules.dbschema.nodes.ForeignKeyElementNode;
import org.netbeans.modules.dbschema.nodes.IconStrings;
import org.netbeans.modules.dbschema.nodes.IndexElementNode;
import org.netbeans.modules.dbschema.nodes.SchemaChildren;
import org.netbeans.modules.dbschema.nodes.SchemaElementNode;
import org.netbeans.modules.dbschema.nodes.TableChildren;
import org.netbeans.modules.dbschema.nodes.TableElementFilter;
import org.netbeans.modules.dbschema.nodes.TableElementNode;
import org.openide.actions.ToolsAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class DefaultDBFactory
implements DBElementNodeFactory,
IconStrings {
    public static final String WAIT = "org/openide/src/resources/wait";
    public static final String ERROR = "org/openide/src/resources/error";
    public static final DefaultDBFactory READ_WRITE = new DefaultDBFactory(true);
    public static final DefaultDBFactory READ_ONLY = new DefaultDBFactory(false);
    private boolean _writeable;
    private static final SystemAction[] CATEGORY_ACTIONS = new SystemAction[]{SystemAction.get(ToolsAction.class)};
    static final String[] NAMES = new String[]{NbBundle.getMessage(DefaultDBFactory.class, (String)"Columns"), NbBundle.getMessage(DefaultDBFactory.class, (String)"Indexes"), NbBundle.getMessage(DefaultDBFactory.class, (String)"FKs"), NbBundle.getMessage(DefaultDBFactory.class, (String)"Tables")};
    static final int[][] FILTERS = new int[][]{{4}, {8}, {16}, {1}};
    static final String[] CATEGORY_ICONS = new String[]{"org/netbeans/modules/dbschema/resources/columns", "org/netbeans/modules/dbschema/resources/indexes", "org/netbeans/modules/dbschema/resources/foreignKeys", "org/netbeans/modules/dbschema/resources/table"};

    public DefaultDBFactory(boolean bl) {
        this._writeable = bl;
    }

    public boolean isWriteable() {
        return this._writeable;
    }

    public Node createSchemaNode(SchemaElement schemaElement) {
        return new SchemaElementNode(schemaElement, this.createSchemaChildren(schemaElement), this.isWriteable());
    }

    protected Children createSchemaChildren(SchemaElement schemaElement) {
        return this.createSchemaChildren(schemaElement, this.isWriteable() ? READ_WRITE : READ_ONLY);
    }

    protected final Children createSchemaChildren(SchemaElement schemaElement, DBElementNodeFactory dBElementNodeFactory) {
        SchemaChildren schemaChildren = new SchemaChildren(dBElementNodeFactory, schemaElement);
        boolean bl = this.isWriteable();
        return schemaChildren;
    }

    public Node createColumnNode(ColumnElement columnElement) {
        return new ColumnElementNode(columnElement, this.isWriteable());
    }

    public Node createColumnPairNode(ColumnPairElement columnPairElement) {
        return new ColumnPairElementNode(columnPairElement, this.isWriteable());
    }

    public Node createIndexNode(IndexElement indexElement) {
        return new IndexElementNode(indexElement, (TableChildren)this.createIndexChildren(indexElement), this.isWriteable());
    }

    protected Children createIndexChildren(IndexElement indexElement) {
        return this.createIndexChildren(indexElement, this.isWriteable() ? READ_WRITE : READ_ONLY);
    }

    protected final Children createIndexChildren(IndexElement indexElement, DBElementNodeFactory dBElementNodeFactory) {
        TableChildren tableChildren = new TableChildren(dBElementNodeFactory, indexElement);
        boolean bl = this.isWriteable();
        return tableChildren;
    }

    public Node createForeignKeyNode(ForeignKeyElement foreignKeyElement) {
        return new ForeignKeyElementNode(foreignKeyElement, (TableChildren)this.createForeignKeyChildren(foreignKeyElement), this.isWriteable());
    }

    protected Children createForeignKeyChildren(ForeignKeyElement foreignKeyElement) {
        return this.createForeignKeyChildren(foreignKeyElement, this.isWriteable() ? READ_WRITE : READ_ONLY);
    }

    protected final Children createForeignKeyChildren(ForeignKeyElement foreignKeyElement, DBElementNodeFactory dBElementNodeFactory) {
        TableChildren tableChildren = new TableChildren(dBElementNodeFactory, foreignKeyElement);
        boolean bl = this.isWriteable();
        return tableChildren;
    }

    public Node createTableNode(TableElement tableElement) {
        return new TableElementNode(tableElement, this.createTableChildren(tableElement), this.isWriteable());
    }

    protected Children createTableChildren(TableElement tableElement) {
        return this.createTableChildren(tableElement, this.isWriteable() ? READ_WRITE : READ_ONLY);
    }

    protected final Children createTableChildren(TableElement tableElement, DBElementNodeFactory dBElementNodeFactory) {
        TableChildren tableChildren = new TableChildren(dBElementNodeFactory, tableElement);
        TableElementFilter tableElementFilter = new TableElementFilter();
        boolean bl = this.isWriteable();
        tableElementFilter.setOrder(new int[]{1, 2});
        tableChildren.setFilter(tableElementFilter);
        String string = tableElement.getDeclaringSchema().getDatabaseProductName();
        boolean bl2 = false;
        if (string != null) {
            boolean bl3 = bl2 = (string = string.toLowerCase()).indexOf("oracle") != -1 || string.indexOf("microsoft sql server") != -1;
        }
        if (tableElement.isTableOrView() || bl2) {
            tableChildren.add(new Node[]{new ElementCategoryNode(0, dBElementNodeFactory, tableElement, bl), new ElementCategoryNode(1, dBElementNodeFactory, tableElement, bl), new ElementCategoryNode(2, dBElementNodeFactory, tableElement, bl)});
        } else {
            tableChildren.add(new Node[]{new ElementCategoryNode(0, dBElementNodeFactory, tableElement, bl)});
        }
        return tableChildren;
    }

    public Node createWaitNode() {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF);
        abstractNode.setName(NbBundle.getMessage(DefaultDBFactory.class, (String)"Wait"));
        abstractNode.setIconBase(WAIT);
        return abstractNode;
    }

    public Node createErrorNode() {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF);
        abstractNode.setName(NbBundle.getMessage(DefaultDBFactory.class, (String)"Error"));
        abstractNode.setIconBase(ERROR);
        return abstractNode;
    }

    static class ElementCategoryNode
    extends AbstractNode {
        DBElement element;
        int newTypeIndex;

        ElementCategoryNode(int n, DBElementNodeFactory dBElementNodeFactory, TableElement tableElement, boolean bl) {
            this(n, new TableChildren(dBElementNodeFactory, tableElement));
            this.element = tableElement;
            this.newTypeIndex = bl ? n : -1;
            switch (n) {
                case 0: {
                    this.setName(NbBundle.getMessage(DefaultDBFactory.class, (String)"Columns"));
                    break;
                }
                case 1: {
                    this.setName(NbBundle.getMessage(DefaultDBFactory.class, (String)"Indexes"));
                    break;
                }
                case 2: {
                    this.setName(NbBundle.getMessage(DefaultDBFactory.class, (String)"FKs"));
                }
            }
        }

        ElementCategoryNode(int n, DBElementNodeFactory dBElementNodeFactory, SchemaElement schemaElement, boolean bl) {
            this(n, new SchemaChildren(dBElementNodeFactory, schemaElement));
            this.element = schemaElement;
            this.newTypeIndex = bl ? n : -1;
            this.setName(NbBundle.getMessage(DefaultDBFactory.class, (String)"Tables"));
        }

        private ElementCategoryNode(int n, TableChildren tableChildren) {
            super((Children)tableChildren);
            this.setDisplayName(NAMES[n]);
            this.systemActions = CATEGORY_ACTIONS;
            TableElementFilter tableElementFilter = new TableElementFilter();
            tableElementFilter.setOrder(FILTERS[n]);
            tableChildren.setFilter(tableElementFilter);
            this.setIconBase(CATEGORY_ICONS[n]);
        }

        private ElementCategoryNode(int n, SchemaChildren schemaChildren) {
            super((Children)schemaChildren);
            this.setDisplayName(NAMES[n]);
            this.systemActions = CATEGORY_ACTIONS;
            this.setIconBase(CATEGORY_ICONS[n]);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dbschema_ctxhelp_wizard");
        }
    }
}

