/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;
import org.netbeans.modules.dbschema.jdbcimpl.DDLBridge;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.DBSchemaWizardData;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.ProgressPanel;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.SortedListModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DBSchemaTablesPanel
extends JPanel
implements ListDataListener {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.dbschema.jdbcimpl.wizard");
    private static final boolean LOG = LOGGER.isLoggable(Level.INFO);
    private final ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.dbschema.jdbcimpl.resources.Bundle");
    private LinkedList<String> tables;
    private LinkedList<String> views;
    private ConnectionProvider cp;
    private String schema;
    private String driver;
    private DatabaseConnection dbconnOld;
    private Connection conn;
    private DBSchemaWizardData data;
    private int tablesCount;
    private ArrayList list;
    private JButton jButtonAdd;
    private JButton jButtonAddAll;
    private JButton jButtonRemove;
    private JButton jButtonRemoveAll;
    private JLabel jLabelAvailableTables;
    private JLabel jLabelNote;
    private JLabel jLabelSelectedTables;
    private JList jListAvailableTables;
    private JList jListSelectedTables;
    private JPanel jPanelButtons;
    private JScrollPane jScrollPaneAvailableTables;
    private JScrollPane jScrollPaneSelectedTables;

    public DBSchemaTablesPanel(DBSchemaWizardData dBSchemaWizardData, ArrayList arrayList) {
        this.list = arrayList;
        this.data = dBSchemaWizardData;
        this.tables = new LinkedList();
        this.views = new LinkedList();
        this.cp = null;
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(2));
        this.setName(this.bundle.getString("TablesChooser"));
        this.initComponents();
        this.initAccessibility();
        this.jListAvailableTables.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBSchemaTablesPanel.this.jListAvailableTables.requestFocus();
            }
        }, KeyStroke.getKeyStroke(84, 8), 2);
        this.jListSelectedTables.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBSchemaTablesPanel.this.jListSelectedTables.requestFocus();
            }
        }, KeyStroke.getKeyStroke(83, 8), 2);
        this.jListSelectedTables.getModel().addListDataListener(this);
        this.jListAvailableTables.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DBSchemaTablesPanel.this.jButtonAdd.setEnabled(DBSchemaTablesPanel.this.jListAvailableTables.getSelectedIndex() != -1);
            }
        });
        this.jListSelectedTables.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DBSchemaTablesPanel.this.jButtonRemove.setEnabled(DBSchemaTablesPanel.this.jListSelectedTables.getSelectedIndex() != -1);
            }
        });
    }

    protected boolean init() {
        ArrayList<Handler> arrayList = new ArrayList<Handler>();
        Parameters parameters = new Parameters();
        boolean bl = true;
        if (this.data.getConnectionProvider() != null) {
            if (this.data.getDatabaseConnection() == this.dbconnOld) {
                bl = false;
            }
            if (bl) {
                this.cp = this.data.getConnectionProvider();
                arrayList.add(new Handler(){

                    public void handle(Parameters parameters) {
                        DBSchemaTablesPanel.this.uninit();
                    }

                    public String getMessage() {
                        return NbBundle.getMessage(DBSchemaTablesPanel.class, (String)"MSG_ClosingPrevious");
                    }
                });
            }
        }
        if (!bl) {
            this.updateButtons();
            return true;
        }
        this.data.setConnected(false);
        if (!this.data.isExistingConn()) {
            return false;
        }
        final DatabaseConnection databaseConnection = this.data.getDatabaseConnection();
        this.conn = databaseConnection.getJDBCConnection();
        if (this.conn != null) {
            arrayList.add(new Handler(){

                public void handle(Parameters parameters) {
                    try {
                        DBSchemaTablesPanel.this.conn.getCatalog();
                    }
                    catch (SQLException sQLException) {
                        DBSchemaTablesPanel.this.conn = null;
                    }
                }

                public String getMessage() {
                    return NbBundle.getMessage(DBSchemaTablesPanel.class, (String)"MSG_CheckingExisting");
                }
            });
        }
        arrayList.add(new Handler(){

            public void handle(Parameters parameters) {
                ConnectionManager.getDefault().showConnectionDialog(databaseConnection);
                DBSchemaTablesPanel.this.conn = databaseConnection.getJDBCConnection();
                for (int i = 0; DBSchemaTablesPanel.this.conn == null && i < 10; ++i) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    DBSchemaTablesPanel.this.conn = databaseConnection.getJDBCConnection();
                }
            }

            public boolean getRunInEDT() {
                return true;
            }

            public boolean isRunnable() {
                return DBSchemaTablesPanel.this.conn == null;
            }
        });
        arrayList.add(new Handler(){

            public void handle(Parameters parameters) {
                int n;
                if (DBSchemaTablesPanel.this.conn != null) {
                    try {
                        DBSchemaTablesPanel.this.conn.getCatalog();
                    }
                    catch (SQLException sQLException) {
                        DBSchemaTablesPanel.this.conn = null;
                        DBSchemaTablesPanel.this.data.setConnected(false);
                        parameters.setResult(false);
                        return;
                    }
                }
                DBSchemaTablesPanel.this.data.setConnected(true);
                DBSchemaTablesPanel.this.schema = databaseConnection.getSchema();
                DBSchemaTablesPanel.this.driver = databaseConnection.getDriverClass();
                DBSchemaTablesPanel.this.dbconnOld = databaseConnection;
                try {
                    if (DBSchemaTablesPanel.this.conn == null) {
                        parameters.setResult(false);
                        return;
                    }
                    DBSchemaTablesPanel.this.cp = new ConnectionProvider(DBSchemaTablesPanel.this.conn, DBSchemaTablesPanel.this.driver);
                    DBSchemaTablesPanel.this.cp.setSchema(DBSchemaTablesPanel.this.schema);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                DBSchemaTablesPanel.this.data.setConnectionProvider(DBSchemaTablesPanel.this.cp);
                DBSchemaTablesPanel.this.tables.clear();
                DBSchemaTablesPanel.this.views.clear();
                try {
                    DDLBridge dDLBridge = new DDLBridge(DBSchemaTablesPanel.this.cp.getConnection(), DBSchemaTablesPanel.this.cp.getSchema(), DBSchemaTablesPanel.this.cp.getDatabaseMetaData());
                    dDLBridge.getDriverSpecification().getTables("%", new String[]{"TABLE"});
                    ResultSet resultSet = dDLBridge.getDriverSpecification().getResultSet();
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            DBSchemaTablesPanel.this.tables.add(resultSet.getString("TABLE_NAME").trim());
                        }
                        resultSet.close();
                    }
                    resultSet = null;
                    if (dDLBridge.getDriverSpecification().areViewsSupported()) {
                        dDLBridge.getDriverSpecification().getTables("%", new String[]{"VIEW"});
                        resultSet = dDLBridge.getDriverSpecification().getResultSet();
                    }
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            DBSchemaTablesPanel.this.views.add(resultSet.getString("TABLE_NAME").trim());
                        }
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    LOGGER.info(sQLException.getLocalizedMessage());
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DBSchemaTablesPanel.class, (String)"DBSchemaTablesPanel_SQLException", (Object)sQLException.getLocalizedMessage()), 2));
                }
                ((SortedListModel)DBSchemaTablesPanel.this.jListAvailableTables.getModel()).clear();
                ((SortedListModel)DBSchemaTablesPanel.this.jListSelectedTables.getModel()).clear();
                DBSchemaTablesPanel.this.tablesCount = DBSchemaTablesPanel.this.tables.size();
                for (n = 0; n < DBSchemaTablesPanel.this.tables.size(); ++n) {
                    ((SortedListModel)DBSchemaTablesPanel.this.jListAvailableTables.getModel()).add(DBSchemaTablesPanel.this.bundle.getString("TablePrefix") + " " + ((String)DBSchemaTablesPanel.this.tables.get(n)).toString());
                }
                for (n = 0; n < DBSchemaTablesPanel.this.views.size(); ++n) {
                    ((SortedListModel)DBSchemaTablesPanel.this.jListAvailableTables.getModel()).add(DBSchemaTablesPanel.this.bundle.getString("ViewPrefix") + " " + ((String)DBSchemaTablesPanel.this.views.get(n)).toString());
                }
                if (DBSchemaTablesPanel.this.jListAvailableTables.getModel().getSize() > 0) {
                    DBSchemaTablesPanel.this.jListAvailableTables.setSelectedIndex(0);
                }
                DBSchemaTablesPanel.this.tables.clear();
                DBSchemaTablesPanel.this.views.clear();
                parameters.setResult(true);
            }

            public String getMessage() {
                return NbBundle.getMessage(DBSchemaTablesPanel.class, (String)"MSG_RetrievingTables");
            }

            public boolean isRunnable() {
                return DBSchemaTablesPanel.this.conn != null;
            }
        });
        this.invokeHandlers(arrayList, parameters);
        this.updateButtons();
        return parameters.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeHandlers(final List list, final Parameters parameters) {
        final ProgressPanel progressPanel = new ProgressPanel();
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle(null);
        JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        progressHandle.start();
        progressHandle.switchToIndeterminate();
        final int[] nArray = new int[1];
        try {
            RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

                public void run() {
                    nArray[0] = DBSchemaTablesPanel.this.invokeHandlers(list, nArray[0], parameters, progressPanel);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            progressPanel.close();
                        }
                    });
                }
            });
            while (nArray[0] < list.size()) {
                nArray[0] = this.invokeHandlers(list, nArray[0], parameters, null);
                if (nArray[0] >= list.size()) continue;
                task.schedule(0);
                progressPanel.open(jComponent);
            }
        }
        finally {
            progressHandle.finish();
        }
    }

    private int invokeHandlers(List list, int n, Parameters parameters, final ProgressPanel progressPanel) {
        int n2;
        boolean bl = SwingUtilities.isEventDispatchThread();
        for (n2 = n; n2 < list.size(); ++n2) {
            String string;
            Handler handler = (Handler)list.get(n2);
            if (!handler.isRunnable()) {
                if (!LOG) continue;
                LOGGER.log(Level.FINE, "Skipping " + handler);
                continue;
            }
            if (handler.getRunInEDT() != bl) break;
            if (LOG) {
                LOGGER.log(Level.FINE, "Invoking " + handler);
            }
            if (progressPanel != null && (string = handler.getMessage()) != null) {
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        progressPanel.setText(string);
                    }
                });
            }
            handler.handle(parameters);
        }
        return n2;
    }

    public void uninit() {
        try {
            if (this.cp != null && this.data.isConnected()) {
                if (this.data.isExistingConn()) {
                    ConnectionManager.getDefault().disconnect(this.dbconnOld);
                } else if (this.dbconnOld.getJDBCConnection() != null) {
                    ConnectionManager.getDefault().disconnect(this.dbconnOld);
                } else {
                    this.cp.closeConnection();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_TablesPanelA11yDesc"));
        this.jLabelAvailableTables.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_AvailableTablesA11yDesc"));
        this.jListAvailableTables.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_AvailableTablesListA11yName"));
        this.jLabelSelectedTables.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_SelectedTablesA11yDesc"));
        this.jListSelectedTables.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_SelectedTablesListA11yName"));
        this.jLabelNote.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_FKReferenceNoteA11yDesc"));
    }

    private void initComponents() {
        this.jLabelAvailableTables = new JLabel();
        this.jScrollPaneAvailableTables = new JScrollPane();
        this.jListAvailableTables = new JList();
        this.jPanelButtons = new JPanel();
        this.jButtonAdd = new JButton();
        this.jButtonRemove = new JButton();
        this.jButtonAddAll = new JButton();
        this.jButtonRemoveAll = new JButton();
        this.jLabelSelectedTables = new JLabel();
        this.jScrollPaneSelectedTables = new JScrollPane();
        this.jListSelectedTables = new JList();
        this.jLabelNote = new JLabel();
        FormListener formListener = new FormListener();
        this.setPreferredSize(new Dimension(400, 199));
        this.setLayout(new GridBagLayout());
        this.jLabelAvailableTables.setLabelFor(this.jListAvailableTables);
        Mnemonics.setLocalizedText((JLabel)this.jLabelAvailableTables, (String)this.bundle.getString("AvailableTables"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jLabelAvailableTables, gridBagConstraints);
        this.jListAvailableTables.setToolTipText(this.bundle.getString("ACS_AvailableTablesListA11yDesc"));
        this.jListAvailableTables.setModel(new SortedListModel());
        this.jScrollPaneAvailableTables.setViewportView(this.jListAvailableTables);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.jScrollPaneAvailableTables, gridBagConstraints);
        this.jPanelButtons.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonAdd, (String)this.bundle.getString("AddButton"));
        this.jButtonAdd.setToolTipText(this.bundle.getString("ACS_AddButtonA11yDesc"));
        this.jButtonAdd.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.jPanelButtons.add((Component)this.jButtonAdd, gridBagConstraints);
        this.jButtonRemove.setToolTipText(this.bundle.getString("ACS_RemoveButtonA11yDesc"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonRemove, (String)this.bundle.getString("RemoveButton"));
        this.jButtonRemove.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanelButtons.add((Component)this.jButtonRemove, gridBagConstraints);
        this.jButtonAddAll.setToolTipText(this.bundle.getString("ACS_AddAllButtonA11yDesc"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonAddAll, (String)this.bundle.getString("AddAllButton"));
        this.jButtonAddAll.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 0, 0);
        this.jPanelButtons.add((Component)this.jButtonAddAll, gridBagConstraints);
        this.jButtonRemoveAll.setToolTipText(this.bundle.getString("ACS_RemoveAllButtonA11yDesc"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonRemoveAll, (String)this.bundle.getString("RemoveAllButton"));
        this.jButtonRemoveAll.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanelButtons.add((Component)this.jButtonRemoveAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(12, 11, 0, 11);
        this.add((Component)this.jPanelButtons, gridBagConstraints);
        this.jLabelSelectedTables.setLabelFor(this.jListSelectedTables);
        Mnemonics.setLocalizedText((JLabel)this.jLabelSelectedTables, (String)this.bundle.getString("SelectedTables"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 11);
        this.add((Component)this.jLabelSelectedTables, gridBagConstraints);
        this.jListSelectedTables.setModel(new SortedListModel());
        this.jListSelectedTables.setToolTipText(this.bundle.getString("ACS_SelectedTablesListA11yDesc"));
        this.jScrollPaneSelectedTables.setViewportView(this.jListSelectedTables);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 11);
        this.add((Component)this.jScrollPaneSelectedTables, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabelNote, (String)this.bundle.getString("FKReferenceNote"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        this.add((Component)this.jLabelNote, gridBagConstraints);
    }

    private void jButtonRemoveAllActionPerformed(ActionEvent actionEvent) {
        SortedListModel sortedListModel = (SortedListModel)this.jListAvailableTables.getModel();
        SortedListModel sortedListModel2 = (SortedListModel)this.jListSelectedTables.getModel();
        Object[] objectArray = sortedListModel2.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            sortedListModel.add(objectArray[i]);
            sortedListModel2.remove(objectArray[i]);
        }
        this.tables.clear();
        this.views.clear();
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = sortedListModel.indexOf(objectArray[i]);
        }
        this.jListAvailableTables.setSelectedIndices(nArray);
        this.setSelection();
        this.updateButtons();
    }

    private void jButtonAddAllActionPerformed(ActionEvent actionEvent) {
        SortedListModel sortedListModel = (SortedListModel)this.jListAvailableTables.getModel();
        SortedListModel sortedListModel2 = (SortedListModel)this.jListSelectedTables.getModel();
        Object[] objectArray = sortedListModel.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            sortedListModel2.add(objectArray[i]);
            sortedListModel.remove(objectArray[i]);
            String string = objectArray[i].toString();
            if (string.startsWith(this.bundle.getString("TablePrefix"))) {
                this.tables.add(string.substring(string.indexOf(" ") + 1));
                continue;
            }
            this.views.add(string.substring(string.indexOf(" ") + 1));
        }
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = sortedListModel2.indexOf(objectArray[i]);
        }
        this.jListSelectedTables.setSelectedIndices(nArray);
        this.setSelection();
        this.updateButtons();
    }

    private void jButtonRemoveActionPerformed(ActionEvent actionEvent) {
        SortedListModel sortedListModel = (SortedListModel)this.jListAvailableTables.getModel();
        SortedListModel sortedListModel2 = (SortedListModel)this.jListSelectedTables.getModel();
        Object[] objectArray = this.jListSelectedTables.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            sortedListModel.add(objectArray[i]);
            sortedListModel2.remove(objectArray[i]);
            String string = objectArray[i].toString();
            string = string.substring(string.indexOf(" ")).trim();
            if (this.tables.contains(string)) {
                this.tables.remove(string);
                continue;
            }
            this.views.remove(string);
        }
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = sortedListModel.indexOf(objectArray[i]);
        }
        this.jListAvailableTables.setSelectedIndices(nArray);
        this.setSelection();
        this.updateButtons();
    }

    private void jButtonAddActionPerformed(ActionEvent actionEvent) {
        SortedListModel sortedListModel = (SortedListModel)this.jListAvailableTables.getModel();
        SortedListModel sortedListModel2 = (SortedListModel)this.jListSelectedTables.getModel();
        Object[] objectArray = this.jListAvailableTables.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            sortedListModel2.add(objectArray[i]);
            sortedListModel.remove(objectArray[i]);
            String string = objectArray[i].toString();
            if (string.startsWith(this.bundle.getString("TablePrefix"))) {
                this.tables.add(string.substring(string.indexOf(" ") + 1));
                continue;
            }
            this.views.add(string.substring(string.indexOf(" ") + 1));
        }
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = sortedListModel2.indexOf(objectArray[i]);
        }
        this.jListSelectedTables.setSelectedIndices(nArray);
        this.setSelection();
        this.updateButtons();
    }

    private void setSelection() {
        this.data.setTables(this.tables);
        this.data.setViews(this.views);
        if (this.tablesCount == this.tables.size()) {
            this.data.setAllTables(true);
        } else {
            this.data.setAllTables(false);
        }
    }

    private void updateButtons() {
        this.jButtonAdd.setEnabled(this.jListAvailableTables.getSelectedIndex() != -1);
        this.jButtonAddAll.setEnabled(!((SortedListModel)this.jListAvailableTables.getModel()).isEmpty());
        this.jButtonRemove.setEnabled(this.jListSelectedTables.getSelectedIndex() != -1);
        this.jButtonRemoveAll.setEnabled(!((SortedListModel)this.jListSelectedTables.getModel()).isEmpty());
    }

    public boolean isInputValid() {
        return this.jListSelectedTables.getModel().getSize() > 0;
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.fireChange(this);
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.fireChange(this);
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.fireChange(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChange(Object object) {
        ArrayList arrayList;
        Serializable serializable = this;
        synchronized (serializable) {
            arrayList = (ArrayList)this.list.clone();
        }
        serializable = new ChangeEvent(object);
        for (int i = 0; i < arrayList.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)arrayList.get(i);
            changeListener.stateChanged((ChangeEvent)serializable);
        }
    }

    private static final class Parameters {
        private boolean result;

        private Parameters() {
        }

        public boolean getResult() {
            return this.result;
        }

        public void setResult(boolean bl) {
            this.result = bl;
        }
    }

    private static abstract class Handler {
        private Handler() {
        }

        public abstract void handle(Parameters var1);

        public String getMessage() {
            return null;
        }

        public boolean getRunInEDT() {
            return false;
        }

        public boolean isRunnable() {
            return true;
        }

        public String toString() {
            return "Handler[message='" + this.getMessage() + "',runInEDT=" + this.getRunInEDT() + ",runnable=" + this.isRunnable() + "]";
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DBSchemaTablesPanel.this.jButtonAdd) {
                DBSchemaTablesPanel.this.jButtonAddActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == DBSchemaTablesPanel.this.jButtonRemove) {
                DBSchemaTablesPanel.this.jButtonRemoveActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == DBSchemaTablesPanel.this.jButtonAddAll) {
                DBSchemaTablesPanel.this.jButtonAddAllActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == DBSchemaTablesPanel.this.jButtonRemoveAll) {
                DBSchemaTablesPanel.this.jButtonRemoveAllActionPerformed(actionEvent);
            }
        }
    }
}

