/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.project.ant.VariablesModel;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class VariablePanel
extends JPanel
implements DocumentListener {
    private VariablesModel model;
    private DialogDescriptor dd;
    private VariablesModel.Variable variableBeingEditted;
    private JButton browseButton;
    private JLabel errorLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField locationTextField;
    private JTextField nameTextField;

    public VariablePanel(VariablesModel variablesModel, VariablesModel.Variable variable) {
        this.model = variablesModel;
        this.variableBeingEditted = variable;
        this.initComponents();
        if (variable != null) {
            this.nameTextField.setText(variable.getName());
            this.nameTextField.setEditable(false);
            this.locationTextField.setText(variable.getValue().getAbsolutePath());
        }
        this.nameTextField.getDocument().addDocumentListener(this);
        this.locationTextField.getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.nameTextField = new JTextField();
        this.locationTextField = new JTextField();
        this.browseButton = new JButton();
        this.errorLabel = new JLabel();
        this.jLabel1.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(VariablePanel.class, (String)"VariablePanel.jLabel1.text"));
        this.jLabel2.setLabelFor(this.locationTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(VariablePanel.class, (String)"VariablePanel.jLabel2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(VariablePanel.class, (String)"VariablePanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VariablePanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.errorLabel.setForeground(Color.red);
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)" ");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.errorLabel, -1, 376, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.nameTextField, -1, 242, Short.MAX_VALUE).add((Component)this.locationTextField, -1, 242, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.browseButton))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.nameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.browseButton).add((Component)this.locationTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.errorLabel)));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariablePanel.class, (String)"ACSD_VariablePanel_NA"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariablePanel.class, (String)"ACSD_VariablePanel_NA"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariablePanel.class, (String)"ACSD_VariablePanel_NA"));
        this.locationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariablePanel.class, (String)"ACSD_VariablePanel_NA"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariablePanel.class, (String)"ACSD_VariablePanel_NA"));
        this.errorLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariablePanel.class, (String)"ACSD_VariablePanel_NA"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(VariablePanel.class, (String)"ACSD_VariablePanel_NA"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariablePanel.class, (String)"ACSD_VariablePanel_NA"));
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileHidingEnabled(false);
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setDialogTitle(NbBundle.getBundle(VariablePanel.class).getString("MSG_Choose_Folder"));
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            this.locationTextField.setText(file.getAbsolutePath());
        }
    }

    void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        assert (this.dd == null);
        this.dd = dialogDescriptor;
        this.checkValidity();
    }

    private void checkValidity() {
        String string = null;
        if (this.nameTextField.getText().length() == 0) {
            string = NbBundle.getBundle(VariablePanel.class).getString("MSG_Invalid_Name");
        } else if (this.variableBeingEditted == null && this.model.find(this.nameTextField.getText()) != null) {
            string = NbBundle.getBundle(VariablePanel.class).getString("MSG_Variable_Already_Exists");
        } else if (this.locationTextField.getText().length() == 0 || !this.getVariableLocation().exists()) {
            string = NbBundle.getBundle(VariablePanel.class).getString("MSG_Invalid_Location");
        } else if (this.variableBeingEditted == null && !PropertyUtils.isUsablePropertyName(this.nameTextField.getText())) {
            string = NbBundle.getBundle(VariablePanel.class).getString("MSG_Invalid_Name");
        }
        this.dd.setValid(string == null);
        this.errorLabel.setText(string == null ? " " : string);
    }

    public String getVariableName() {
        return this.nameTextField.getText();
    }

    public File getVariableLocation() {
        return FileUtil.normalizeFile((File)new File(this.locationTextField.getText()));
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkValidity();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkValidity();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkValidity();
    }
}

