/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import javax.swing.text.Utilities;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.jellytools.EditorWindowOperator;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.AbstractButtonOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JEditorPaneOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.Operator;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.CloneableEditor;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorOperator
extends TopComponentOperator {
    private static int WAIT_TIME = 60000;
    private JEditorPaneOperator _txtEditorPane;
    private JLabelOperator _lblRowColumn;
    private JLabelOperator _lblInputMode;
    private JLabelOperator _lblStatusBar;

    public EditorOperator(String string) {
        this(string, 0);
    }

    public EditorOperator(String string, int n) {
        super(EditorOperator.waitTopComponent(null, (String)string, (int)n, (ComponentChooser)new EditorSubchooser()));
        this.requestFocus();
    }

    public EditorOperator(ContainerOperator containerOperator, String string) {
        this(containerOperator, string, 0);
    }

    public EditorOperator(JComponent jComponent) {
        super(jComponent);
    }

    public EditorOperator(ContainerOperator containerOperator, String string, int n) {
        super(EditorOperator.waitTopComponent((ContainerOperator)containerOperator, (String)string, (int)n, (ComponentChooser)new EditorSubchooser()));
        this.copyEnvironment((Operator)containerOperator);
        this.requestFocus();
    }

    public static void closeDiscardAll() {
        Mode mode = (Mode)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("findMode"){

            public Object launch() {
                return WindowManager.getDefault().findMode("editor");
            }
        });
        EditorWindowOperator.closeDiscard(mode);
    }

    public void close(boolean bl) {
        if (bl) {
            super.save();
            this.close();
        } else {
            this.closeDiscard();
        }
    }

    static void close(final Object object, boolean bl) {
        Boolean bl2 = (Boolean)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("isOpened"){

            public Object launch() {
                return ((TopComponent)object).isOpened();
            }
        });
        if (bl2.booleanValue()) {
            TopComponentOperator topComponentOperator = new TopComponentOperator((JComponent)((TopComponent)object));
            if (bl) {
                topComponentOperator.save();
                topComponentOperator.close();
            } else {
                topComponentOperator.closeDiscard();
            }
        }
    }

    public JEditorPaneOperator txtEditorPane() {
        if (this._txtEditorPane == null) {
            this._txtEditorPane = new JEditorPaneOperator((ContainerOperator)this);
        }
        return this._txtEditorPane;
    }

    public JLabelOperator lblRowColumn() {
        if (this._lblRowColumn == null) {
            this._lblRowColumn = new JLabelOperator((ContainerOperator)this, 0);
        }
        return this._lblRowColumn;
    }

    public JLabelOperator lblInputMode() {
        if (this._lblInputMode == null) {
            this._lblInputMode = new JLabelOperator((ContainerOperator)this, 1);
        }
        return this._lblInputMode;
    }

    public JLabelOperator lblStatusBar() {
        if (this._lblStatusBar == null) {
            this._lblStatusBar = new JLabelOperator((ContainerOperator)this, 2);
        }
        return this._lblStatusBar;
    }

    public String getText() {
        return this.txtEditorPane().getText();
    }

    public String getText(int n) {
        return ((Line)this.getLine(n)).getText();
    }

    private Object getLine(int n) {
        Document document = this.txtEditorPane().getDocument();
        DataObject dataObject = (DataObject)document.getProperty("stream");
        Line.Set set = ((LineCookie)dataObject.getCookie(LineCookie.class)).getLineSet();
        try {
            return set.getCurrent(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new JemmyException("Index must be > 0", (Throwable)indexOutOfBoundsException);
        }
    }

    public boolean contains(String string) {
        return this.getText().indexOf(string) != -1;
    }

    public void select(int n) {
        int n2 = this.getLineOffset(n);
        this.setCaretPosition(n2);
        this.txtEditorPane().moveCaretPosition(n2 + this.getText(n).length());
    }

    public void select(int n, int n2) {
        this.setCaretPosition(this.getLineOffset(n));
        this.txtEditorPane().moveCaretPosition(this.getLineOffset(n2) + this.getText(n2).length());
    }

    public void select(int n, int n2, int n3) {
        int n4 = this.getLineOffset(n);
        this.setCaretPosition(n4 + n2 - 1);
        this.txtEditorPane().moveCaretPosition(n4 + n3);
    }

    public void select(String string, int n) {
        int n2 = this.txtEditorPane().getPositionByText(string, n);
        if (n2 == -1) {
            throw new JemmyException(n + "-th occurence of \"" + string + "\" not found.");
        }
        this.setCaretPosition(n2);
        this.txtEditorPane().moveCaretPosition(n2 + string.length());
    }

    public void select(String string) {
        this.select(string, 0);
    }

    public void replace(String string, String string2) {
        this.replace(string, string2, 0);
    }

    public void replace(String string, String string2, int n) {
        this.select(string, n);
        this.txtEditorPane().replaceSelection(string2);
    }

    public void insert(final String string) {
        final int n = this.txtEditorPane().getCaretPosition();
        this.runMapping(new Operator.MapVoidAction("insertString"){

            public void map() {
                try {
                    EditorOperator.this.txtEditorPane().getDocument().insertString(n, string, null);
                }
                catch (BadLocationException badLocationException) {
                    throw new JemmyException("Cannot insert \"" + string + "\" to position " + n + ".", (Throwable)badLocationException);
                }
            }
        });
    }

    public void insert(String string, int n, int n2) {
        this.setCaretPosition(n, n2);
        this.insert(string);
    }

    public void delete(final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("remove"){

            public void map() {
                try {
                    EditorOperator.this.txtEditorPane().getDocument().remove(n, n2);
                }
                catch (BadLocationException badLocationException) {
                    throw new JemmyException("Cannot delete " + n2 + " characters from position " + n + ".", (Throwable)badLocationException);
                }
            }
        });
    }

    public void delete(int n) {
        this.delete(this.txtEditorPane().getCaretPosition(), n);
    }

    public void deleteLine(int n) {
        this.delete(this.getLineOffset(n), this.getText(n).length());
    }

    public void delete(int n, int n2, int n3) {
        this.delete(this.getLineOffset(n) + n2 - 1, n3 - n2 + 1);
    }

    public int getLineNumber() {
        StyledDocument styledDocument = (StyledDocument)this.txtEditorPane().getDocument();
        int n = this.txtEditorPane().getCaretPosition();
        return NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n) + 1;
    }

    public void pushKey(int n) {
        this.requestFocus();
        this.txtEditorPane().pushKey(n);
    }

    public void pushHomeKey() {
        this.pushKey(36);
    }

    public void pushEndKey() {
        this.pushKey(35);
    }

    public void pushTabKey() {
        this.pushKey(9);
    }

    public void pushDownArrowKey() {
        this.pushKey(40);
    }

    public void pushUpArrowKey() {
        this.pushKey(38);
    }

    private int getLineOffset(int n) {
        try {
            StyledDocument styledDocument = (StyledDocument)this.txtEditorPane().getDocument();
            return NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n - 1));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new JemmyException("Invalid line number " + n, (Throwable)indexOutOfBoundsException);
        }
    }

    public void setCaretPositionRelative(int n) {
        this.setCaretPosition(this.txtEditorPane().getCaretPosition() + n);
    }

    public void setCaretPositionToLine(int n) {
        this.txtEditorPane().setCaretPosition(this.getLineOffset(n));
    }

    public void setCaretPositionToEndOfLine(int n) {
        this.txtEditorPane().setCaretPosition(this.getLineOffset(n) + this.getText(n).length() - 1);
    }

    public void setCaretPosition(int n, int n2) {
        this.setCaretPosition(this.getLineOffset(n) + n2 - 1);
    }

    public void setCaretPosition(int n) {
        if (n < 0 || n > this.getText().length()) {
            throw new JemmyException("Invalid caret position " + n);
        }
        this.txtEditorPane().setCaretPosition(n);
    }

    public void setCaretPosition(String string, int n, boolean bl) {
        this.setCaretPosition(this.txtEditorPane().getPositionByText(string, n) + (bl ? 0 : string.length()));
    }

    public void setCaretPosition(String string, boolean bl) {
        this.setCaretPosition(string, 0, bl);
    }

    public Object[] getAnnotations(final int n) {
        ArrayList arrayList = (ArrayList)this.getQueueTool().invokeSmoothly(new QueueTool.QueueAction("getAnnotations"){

            public Object launch() {
                ArrayList arrayList = new ArrayList();
                try {
                    Class<?> clazz = Class.forName("org.netbeans.editor.Annotations");
                    Method method = clazz.getDeclaredMethod("getLineAnnotations", Integer.TYPE);
                    method.setAccessible(true);
                    Object object = method.invoke(EditorOperator.this.getAnnotationsInstance(), n - 1);
                    if (object != null) {
                        arrayList = EditorOperator.this.getAnnotations(object);
                    }
                }
                catch (Exception exception) {
                    throw new JemmyException("getAnnotations failed.", (Throwable)exception);
                }
                return arrayList;
            }
        });
        return arrayList.toArray(new Annotation[arrayList.size()]);
    }

    public Object[] getAnnotations() {
        ArrayList arrayList = (ArrayList)this.getQueueTool().invokeSmoothly(new QueueTool.QueueAction("getAnnotations"){

            public Object launch() {
                ArrayList arrayList = new ArrayList();
                try {
                    Class<?> clazz = Class.forName("org.netbeans.editor.Annotations");
                    Field field = clazz.getDeclaredField("lineAnnotationsArray");
                    field.setAccessible(true);
                    ArrayList arrayList2 = (ArrayList)field.get(EditorOperator.this.getAnnotationsInstance());
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        arrayList.addAll(EditorOperator.this.getAnnotations(arrayList2.get(i)));
                    }
                }
                catch (Exception exception) {
                    throw new JemmyException("getAnnotations failed.", (Throwable)exception);
                }
                return arrayList;
            }
        });
        return arrayList.toArray(new Annotation[arrayList.size()]);
    }

    private Object getAnnotationsInstance() throws Exception {
        Class<?> clazz = Class.forName("org.netbeans.editor.BaseDocument");
        Method method = clazz.getDeclaredMethod("getAnnotations", null);
        method.setAccessible(true);
        return method.invoke((Object)this.txtEditorPane().getDocument(), (Object[])null);
    }

    private ArrayList<Object> getAnnotations(Object object) throws Exception {
        Class<?> clazz = Class.forName("org.netbeans.editor.Annotations$LineAnnotations");
        Class<?> clazz2 = Class.forName("org.netbeans.modules.editor.NbEditorDocument$AnnotationDescDelegate", true, Thread.currentThread().getContextClassLoader());
        Field field = clazz2.getDeclaredField("delegate");
        field.setAccessible(true);
        Method method = clazz.getDeclaredMethod("getAnnotations", null);
        method.setAccessible(true);
        Iterator iterator = (Iterator)method.invoke(object, (Object[])null);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            arrayList.add(field.get(iterator2.next()));
        }
        return arrayList;
    }

    public static String getAnnotationType(Object object) {
        return ((Annotation)object).getAnnotationType();
    }

    public static String getAnnotationShortDescription(Object object) {
        return ((Annotation)object).getShortDescription();
    }

    public AbstractButtonOperator getToolbarButton(String string) {
        ToolbarButtonChooser toolbarButtonChooser = new ToolbarButtonChooser(string, this.getComparator());
        return new AbstractButtonOperator(AbstractButtonOperator.waitAbstractButton((Container)((Container)this.getSource()), (ComponentChooser)toolbarButtonChooser));
    }

    public AbstractButtonOperator getToolbarButton(int n) {
        ComponentChooser componentChooser = new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component instanceof JToolBar;
            }

            public String getDescription() {
                return "javax.swing.JToolBar";
            }
        };
        Container container = (Container)EditorOperator.findComponent((Container)((Container)this.getSource()), (ComponentChooser)componentChooser);
        if (container == null) {
            throw new JemmyException("Toolbar not present.");
        }
        JComboBox jComboBox = JComboBoxOperator.findJComboBox((Container)container, (ComponentChooser)ComponentSearcher.getTrueChooser((String)"JComboBox"));
        if (jComboBox != null) {
            ++n;
        }
        return new AbstractButtonOperator(AbstractButtonOperator.waitAbstractButton((Container)container, (ComponentChooser)ComponentSearcher.getTrueChooser((String)"AbstractButton"), (int)n));
    }

    public void waitFolding() {
        JTextComponent jTextComponent = (JTextComponent)this.txtEditorPane().getSource();
        final AbstractDocument abstractDocument = (AbstractDocument)this.txtEditorPane().getDocument();
        final FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
        this.getOutput().printTrace("Wait folding is initialized.");
        this.waitState(new ComponentChooser(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean checkComponent(Component component) {
                abstractDocument.readLock();
                try {
                    boolean bl;
                    foldHierarchy.lock();
                    try {
                        bl = foldHierarchy.getRootFold().getFoldCount() > 0;
                    }
                    catch (Throwable throwable) {
                        foldHierarchy.unlock();
                        throw throwable;
                    }
                    foldHierarchy.unlock();
                    return bl;
                }
                finally {
                    abstractDocument.readUnlock();
                }
            }

            public String getDescription() {
                return "Folding initialized";
            }
        });
    }

    public void waitCollapsed() {
        this.getOutput().printTrace("Wait fold is collapsed at line " + this.getLineNumber());
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return EditorOperator.this.isCollapsed();
            }

            public String getDescription() {
                return "Fold collapsed";
            }
        });
    }

    public void waitExpanded() {
        this.getOutput().printTrace("Wait fold is expanded at line " + this.getLineNumber());
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return !EditorOperator.this.isCollapsed();
            }

            public String getDescription() {
                return "Fold expanded";
            }
        });
    }

    public void collapseFold() {
        this.getOutput().printTrace("Collapse fold at line " + this.getLineNumber());
        this.requestFocus();
        this.txtEditorPane().pushKey(109, 128);
        this.waitCollapsed();
    }

    public void collapseFold(int n) {
        this.setCaretPositionToLine(n);
        this.collapseFold();
    }

    public void expandFold() {
        this.getOutput().printTrace("Expand fold at line " + this.getLineNumber());
        this.requestFocus();
        this.txtEditorPane().pushKey(107, 128);
        this.waitExpanded();
    }

    public void expandFold(int n) {
        this.setCaretPositionToLine(n);
        this.expandFold();
    }

    public boolean isCollapsed() {
        return this.isCollapsed(this.getLineNumber());
    }

    public boolean isCollapsed(int n) {
        JTextComponent jTextComponent = (JTextComponent)this.txtEditorPane().getSource();
        FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
        int n2 = this.getLineOffset(n);
        foldHierarchy.lock();
        try {
            int n3 = Utilities.getRowStart(jTextComponent, n2);
            int n4 = Utilities.getRowEnd(jTextComponent, n2);
            Fold fold = EditorOperator.getLineFold(foldHierarchy, n2, n3, n4);
            if (fold != null) {
                boolean bl = fold.isCollapsed();
                return bl;
            }
            try {
                throw new JemmyException("No fold found at position " + n2 + ".");
            }
            catch (BadLocationException badLocationException) {
                throw new JemmyException("BadLocationException when seraching for fold.", (Throwable)badLocationException);
            }
        }
        finally {
            foldHierarchy.unlock();
        }
    }

    private static Fold getLineFold(FoldHierarchy foldHierarchy, int n, int n2, int n3) {
        Fold fold;
        Fold fold2 = FoldUtilities.findOffsetFold((FoldHierarchy)foldHierarchy, (int)n);
        Fold fold3 = FoldUtilities.findNearestFold((FoldHierarchy)foldHierarchy, (int)n2);
        while (fold3 != null && (fold3.getEndOffset() <= n || !fold3.isCollapsed() && fold3.getFoldCount() > 0 && fold3.getStartOffset() + 1 < n) && (fold = FoldUtilities.findNearestFold((FoldHierarchy)foldHierarchy, (int)(fold3.getFoldCount() > 0 ? fold3.getStartOffset() + 1 : fold3.getEndOffset()))) != null && fold.getStartOffset() < n3) {
            if (fold == fold3) {
                return fold3;
            }
            fold3 = fold;
        }
        if (fold3 == null || fold3.getStartOffset() > n3) {
            if (fold2 == null) {
                fold2 = FoldUtilities.findOffsetFold((FoldHierarchy)foldHierarchy, (int)n2);
            }
            return fold2;
        }
        if (fold2 == null) {
            return fold3;
        }
        if (fold2.isCollapsed()) {
            return fold2;
        }
        if (fold2.getEndOffset() > fold3.getEndOffset() && fold3.getEndOffset() > n) {
            return fold3;
        }
        if (fold3.getStartOffset() > fold2.getEndOffset()) {
            return fold2;
        }
        if (fold3.getEndOffset() < n) {
            return fold2;
        }
        return fold3;
    }

    public void waitModified(final boolean bl) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object object) {
                    return EditorOperator.this.isModified() == bl ? new Object() : null;
                }

                public String getDescription() {
                    return "Wait Modified State";
                }
            });
            Timeouts timeouts = this.getTimeouts().cloneThis();
            timeouts.setTimeout("Waiter.WaitingTime", timeouts.getTimeout("EditorOperator.WaitModifiedTimeout"));
            waiter.setTimeouts(timeouts);
            waiter.setOutput(this.getOutput());
            waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void save() {
        super.save();
        if (this.getVerification()) {
            this.waitModified(false);
        }
    }

    public void verify() {
        this.txtEditorPane();
    }

    static {
        Timeouts.initDefault((String)"EditorOperator.WaitModifiedTimeout", (long)WAIT_TIME);
    }

    public static final class EditorSubchooser
    implements ComponentChooser {
        public boolean checkComponent(Component component) {
            return component instanceof CloneableEditor;
        }

        public String getDescription() {
            return "org.openide.text.CloneableEditor";
        }
    }

    private static class ToolbarButtonChooser
    implements ComponentChooser {
        private String buttonTooltip;
        private Operator.StringComparator comparator;

        public ToolbarButtonChooser(String string, Operator.StringComparator stringComparator) {
            this.buttonTooltip = string;
            this.comparator = stringComparator;
        }

        public boolean checkComponent(Component component) {
            return this.comparator.equals(((JComponent)component).getToolTipText(), this.buttonTooltip);
        }

        public String getDescription() {
            return "Toolbar button with tooltip \"" + this.buttonTooltip + "\".";
        }
    }
}

