/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.inspector.common;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.vmd.api.inspector.InspectorFolder;
import org.netbeans.modules.vmd.api.inspector.InspectorFolderPath;
import org.netbeans.modules.vmd.api.inspector.InspectorOrderingController;
import org.netbeans.modules.vmd.api.inspector.InspectorOrderingPresenter;
import org.netbeans.modules.vmd.api.inspector.InspectorPositionController;
import org.netbeans.modules.vmd.api.inspector.InspectorPositionPresenter;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionsSupport;

public class DesignComponentInspectorFolder
extends InspectorFolder {
    private String displayName;
    private Image icon;
    private boolean canRename;
    private String name;
    private List<InspectorOrderingController> ocs;
    private DesignComponent component;

    public DesignComponentInspectorFolder(boolean bl, DesignComponent designComponent) {
        assert (designComponent != null);
        this.component = designComponent;
        this.canRename = bl;
    }

    public TypeID getTypeID() {
        return this.getComponent().getType();
    }

    public Long getComponentID() {
        return this.getComponent().getComponentID();
    }

    public Image getIcon() {
        this.getComponent().getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                InfoPresenter infoPresenter = (InfoPresenter)DesignComponentInspectorFolder.this.getComponent().getPresenter(InfoPresenter.class);
                if (infoPresenter == null) {
                    throw new IllegalStateException("No InfoPresenter for this component");
                }
                DesignComponentInspectorFolder.this.icon = infoPresenter.getIcon(InfoPresenter.IconType.COLOR_16x16);
            }
        });
        return this.icon;
    }

    public String getDisplayName() {
        this.getComponent().getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                if (DesignComponentInspectorFolder.this.getComponent().getParentComponent() != null) {
                    DesignComponentInspectorFolder.this.displayName = InfoPresenter.getDisplayName((DesignComponent)DesignComponentInspectorFolder.this.getComponent());
                } else if (DesignComponentInspectorFolder.this.getComponent() == DesignComponentInspectorFolder.this.getComponent().getDocument().getRootComponent()) {
                    DesignComponentInspectorFolder.this.displayName = InfoPresenter.getDisplayName((DesignComponent)DesignComponentInspectorFolder.this.getComponent());
                }
            }
        });
        return this.displayName;
    }

    public String getHtmlDisplayName() {
        this.getComponent().getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                if (DesignComponentInspectorFolder.this.getComponent().getParentComponent() != null) {
                    DesignComponentInspectorFolder.this.displayName = InfoPresenter.getHtmlDisplayName((DesignComponent)DesignComponentInspectorFolder.this.getComponent());
                } else if (DesignComponentInspectorFolder.this.getComponent() == DesignComponentInspectorFolder.this.getComponent().getDocument().getRootComponent()) {
                    DesignComponentInspectorFolder.this.displayName = InfoPresenter.getHtmlDisplayName((DesignComponent)DesignComponentInspectorFolder.this.getComponent());
                }
            }
        });
        return this.displayName;
    }

    public boolean isInside(InspectorFolderPath inspectorFolderPath, InspectorFolder inspectorFolder, DesignComponent designComponent) {
        for (InspectorPositionPresenter inspectorPositionPresenter : this.getComponent().getPresenters(InspectorPositionPresenter.class)) {
            for (InspectorPositionController inspectorPositionController : inspectorPositionPresenter.getFolderPositionControllers()) {
                if (inspectorPositionController == null || !inspectorPositionController.isInside(inspectorFolderPath, inspectorFolder, this.getComponent())) continue;
                return true;
            }
        }
        return false;
    }

    public Action[] getActions() {
        return ActionsSupport.createActionsArray((DesignComponent)this.getComponent());
    }

    public boolean canRename() {
        return this.canRename;
    }

    public String getName() {
        this.getComponent().getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                InfoPresenter infoPresenter = (InfoPresenter)DesignComponentInspectorFolder.this.getComponent().getPresenter(InfoPresenter.class);
                if (infoPresenter != null) {
                    if (infoPresenter.isEditable()) {
                        DesignComponentInspectorFolder.this.name = infoPresenter.getEditableName();
                    }
                } else {
                    Debug.warning((Object[])new Object[]{"No info presenter for component :" + DesignComponentInspectorFolder.this.getComponent()});
                }
            }
        });
        return this.name;
    }

    public InspectorOrderingController[] getOrderingControllers() {
        this.getComponent().getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                Collection collection = DesignComponentInspectorFolder.this.getComponent().getPresenters(InspectorOrderingPresenter.class);
                if (collection == null || collection.isEmpty()) {
                    DesignComponentInspectorFolder.this.ocs = null;
                    return;
                }
                DesignComponentInspectorFolder.this.ocs = new ArrayList();
                for (InspectorOrderingPresenter inspectorOrderingPresenter : collection) {
                    DesignComponentInspectorFolder.this.ocs.addAll(Arrays.asList(inspectorOrderingPresenter.getFolderOrderingControllers()));
                }
            }
        });
        if (this.ocs == null) {
            return null;
        }
        return this.ocs.toArray(new InspectorOrderingController[this.ocs.size()]);
    }

    protected DesignEventFilter getEventFilter() {
        return null;
    }

    protected DesignComponent getComponent() {
        return this.component;
    }
}

