/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjar.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbNodesFactory;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbContainerChildren
extends Children.Keys<Key>
implements PropertyChangeListener {
    private final EjbJar ejbModule;
    private final EjbNodesFactory nodeFactory;
    private final Project project;
    private final HashMap<Key, Node> nodesHash = new HashMap();

    public EjbContainerChildren(EjbJar ejbJar, EjbNodesFactory ejbNodesFactory, Project project) {
        this.ejbModule = ejbJar;
        this.nodeFactory = ejbNodesFactory;
        this.project = project;
        try {
            ejbJar.getMetadataModel().runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Void>(){

                public Void run(EjbJarMetadata ejbJarMetadata) {
                    EnterpriseBeans enterpriseBeans;
                    org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar = ejbJarMetadata.getRoot();
                    if (ejbJar != null && (enterpriseBeans = ejbJar.getEnterpriseBeans()) != null) {
                        enterpriseBeans.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)EjbContainerChildren.this, (Object)enterpriseBeans));
                    }
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    protected void addNotify() {
        super.addNotify();
        this.setKeys(new Key[]{Key.SCANNING});
        this.updateKeys();
    }

    private void updateKeys() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    Future future = EjbContainerChildren.this.ejbModule.getMetadataModel().runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, List<Key>>(){

                        public List<Key> run(EjbJarMetadata ejbJarMetadata) throws Exception {
                            EnterpriseBeans enterpriseBeans = ejbJarMetadata.getRoot().getEnterpriseBeans();
                            if (enterpriseBeans != null) {
                                Key[] keyArray = Key.createArray((Ejb[])enterpriseBeans.getSession());
                                Key[] keyArray2 = Key.createArray((Ejb[])enterpriseBeans.getEntity());
                                Key[] keyArray3 = Key.createArray((Ejb[])enterpriseBeans.getMessageDriven());
                                Comparator<Key> comparator = new Comparator<Key>(){

                                    @Override
                                    public int compare(Key key, Key key2) {
                                        return this.getEjbDisplayName(key).compareTo(this.getEjbDisplayName(key2));
                                    }

                                    private String getEjbDisplayName(Key key) {
                                        String string = key.defaultDisplayName;
                                        if (string == null) {
                                            string = key.ejbName;
                                        }
                                        if (string == null) {
                                            string = "";
                                        }
                                        return string;
                                    }
                                };
                                Arrays.sort(keyArray, comparator);
                                Arrays.sort(keyArray2, comparator);
                                Arrays.sort(keyArray3, comparator);
                                ArrayList<Key> arrayList = new ArrayList<Key>(keyArray.length + keyArray2.length + keyArray3.length);
                                arrayList.addAll(Arrays.asList(keyArray));
                                arrayList.addAll(Arrays.asList(keyArray3));
                                arrayList.addAll(Arrays.asList(keyArray2));
                                return arrayList;
                            }
                            return Collections.emptyList();
                        }
                    });
                    ArrayList arrayList = new ArrayList();
                    try {
                        arrayList.addAll((Collection)future.get());
                    }
                    catch (InterruptedException interruptedException) {
                        Exceptions.printStackTrace((Throwable)interruptedException);
                    }
                    catch (ExecutionException executionException) {
                        Exceptions.printStackTrace((Throwable)executionException);
                    }
                    EjbContainerChildren.this.createNodesForKeys(arrayList);
                    EjbContainerChildren.this.setKeys(arrayList);
                }
                catch (MetadataModelException metadataModelException) {
                    Exceptions.printStackTrace((Throwable)metadataModelException);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        });
    }

    private void createNodesForKeys(List<Key> list) {
        this.nodesHash.clear();
        for (Key key : list) {
            this.nodesHash.put(key, this.createNodes(key)[0]);
        }
    }

    protected void removeNotify() {
        this.setKeys(Collections.emptyList());
        this.nodesHash.clear();
        super.removeNotify();
    }

    protected Node[] createNodes(Key key) {
        Node[] nodeArray;
        Node node = this.nodesHash.get(key);
        if (node == null) {
            if (key.ejbType == Key.EjbType.SESSION && !key.isWebService && this.nodeFactory != null) {
                node = this.nodeFactory.createSessionNode(key.ejbClass, this.ejbModule, this.project);
            }
            if (key.ejbType == Key.EjbType.ENTITY && this.nodeFactory != null) {
                node = this.nodeFactory.createEntityNode(key.ejbClass, this.ejbModule, this.project);
            }
            if (key.ejbType == Key.EjbType.MESSAGE_DRIVEN && this.nodeFactory != null) {
                node = this.nodeFactory.createMessageNode(key.ejbClass, this.ejbModule, this.project);
            }
            if (key == Key.SCANNING) {
                node = new AbstractNode(Children.LEAF);
                node.setDisplayName(NbBundle.getMessage(EjbContainerChildren.class, (String)"MSG_Scanning_EJBs"));
                ((AbstractNode)node).setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbjar/project/ui/wait.gif");
            }
        }
        if (node == null) {
            nodeArray = new Node[1];
        } else {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = node;
        }
        return nodeArray;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateKeys();
    }

    static final class Key {
        public static final Key SCANNING = new Key(null, null, null, null, false);
        private final EjbType ejbType;
        private final String ejbClass;
        private final String defaultDisplayName;
        private final String ejbName;
        private final boolean isWebService;

        private Key(EjbType ejbType, String string, String string2, String string3, boolean bl) {
            this.ejbType = ejbType;
            this.ejbClass = string;
            this.defaultDisplayName = string2;
            this.ejbName = string3;
            this.isWebService = bl;
        }

        public static Key[] createArray(Ejb[] ejbArray) {
            Key[] keyArray = new Key[ejbArray.length];
            for (int i = 0; i < ejbArray.length; ++i) {
                Ejb ejb = ejbArray[i];
                EjbType ejbType = null;
                boolean bl = false;
                if (ejb instanceof Session) {
                    ejbType = EjbType.SESSION;
                    try {
                        bl = ((Session)ejb).getServiceEndpoint() != null;
                    }
                    catch (VersionNotSupportedException versionNotSupportedException) {}
                } else if (ejb instanceof Entity) {
                    ejbType = EjbType.ENTITY;
                } else if (ejb instanceof MessageDriven) {
                    ejbType = EjbType.MESSAGE_DRIVEN;
                }
                keyArray[i] = new Key(ejbType, ejb.getEjbClass(), ejb.getDefaultDisplayName(), ejb.getEjbName(), bl);
            }
            return keyArray;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Key key = (Key)object;
            return this.ejbClass == key.ejbClass || this.ejbClass != null && this.ejbClass.equals(key.ejbClass);
        }

        public int hashCode() {
            int n = 7;
            n = 79 * n + (this.ejbClass != null ? this.ejbClass.hashCode() : 0);
            return n;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum EjbType {
            SESSION,
            ENTITY,
            MESSAGE_DRIVEN;

        }
    }
}

