/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.api.ejbjar;

import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.ejbjar.CarAccessor;
import org.netbeans.modules.j2ee.spi.ejbjar.CarImplementation;
import org.netbeans.modules.j2ee.spi.ejbjar.CarImplementation2;
import org.netbeans.modules.j2ee.spi.ejbjar.CarProvider;
import org.netbeans.modules.j2ee.spi.ejbjar.CarsInProject;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class Car {
    private static final Lookup.Result<CarProvider> implementations = Lookup.getDefault().lookup(new Lookup.Template(CarProvider.class));
    private final CarImplementation impl;
    private final CarImplementation2 impl2;

    private Car(CarImplementation carImplementation, CarImplementation2 carImplementation2) {
        assert (carImplementation != null && carImplementation2 == null || carImplementation == null && carImplementation2 != null);
        this.impl = carImplementation;
        this.impl2 = carImplementation2;
    }

    public static Car getCar(FileObject fileObject) {
        if (fileObject == null) {
            throw new NullPointerException("Passed null to Car.getCar(FileObject)");
        }
        for (CarProvider carProvider : implementations.allInstances()) {
            Car car = carProvider.findCar(fileObject);
            if (car == null) continue;
            return car;
        }
        return null;
    }

    public static Car[] getCars(Project project) {
        Car[] carArray;
        CarsInProject carsInProject = (CarsInProject)project.getLookup().lookup(CarsInProject.class);
        if (carsInProject != null && (carArray = carsInProject.getCars()) != null) {
            return carArray;
        }
        return new Car[0];
    }

    public String getJ2eePlatformVersion() {
        if (this.impl2 != null) {
            return this.impl2.getJ2eeProfile().toPropertiesString();
        }
        return this.impl.getJ2eePlatformVersion();
    }

    public Profile getJ2eeProfile() {
        if (this.impl2 != null) {
            return this.impl2.getJ2eeProfile();
        }
        return Profile.fromPropertiesString((String)this.impl.getJ2eePlatformVersion());
    }

    public FileObject getDeploymentDescriptor() {
        if (this.impl2 != null) {
            return this.impl2.getDeploymentDescriptor();
        }
        return this.impl.getDeploymentDescriptor();
    }

    public FileObject[] getJavaSources() {
        if (this.impl2 != null) {
            return this.impl2.getJavaSources();
        }
        return this.impl.getJavaSources();
    }

    public FileObject getMetaInf() {
        if (this.impl2 != null) {
            return this.impl2.getMetaInf();
        }
        return this.impl.getMetaInf();
    }

    static {
        CarAccessor.DEFAULT = new CarAccessor(){

            public Car createCar(CarImplementation carImplementation) {
                return new Car(carImplementation, null);
            }

            public Car createCar(CarImplementation2 carImplementation2) {
                return new Car(null, carImplementation2);
            }
        };
    }
}

