/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.spi;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping25;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebModuleProvider;
import org.netbeans.modules.websvc.rest.model.api.RestApplication;
import org.netbeans.modules.websvc.rest.model.api.RestApplicationModel;
import org.netbeans.modules.websvc.rest.model.api.RestApplications;
import org.netbeans.modules.websvc.rest.spi.ApplicationConfigPanel;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebRestSupport
extends RestSupport {
    public static final String PROP_REST_RESOURCES_PATH = "rest.resources.path";
    public static final String PROP_REST_CONFIG_TYPE = "rest.config.type";
    public static final String CONFIG_TYPE_IDE = "ide";
    public static final String CONFIG_TYPE_USER = "user";
    public static final String CONFIG_TYPE_DD = "dd";
    public static final String REST_CONFIG_TARGET = "generate-rest-config";

    public WebRestSupport(Project project) {
        super(project);
    }

    @Override
    public FileObject getPersistenceXml() {
        PersistenceScope persistenceScope = PersistenceScope.getPersistenceScope((FileObject)this.getProject().getProjectDirectory());
        if (persistenceScope != null) {
            return persistenceScope.getPersistenceXml();
        }
        return null;
    }

    public WebApp getWebApp() throws IOException {
        FileObject fileObject = this.getWebXml();
        if (fileObject != null) {
            return DDProvider.getDefault().getDDRoot(fileObject);
        }
        return null;
    }

    protected WebApp findWebApp() throws IOException {
        FileObject fileObject;
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null && (fileObject = webModule.getDeploymentDescriptor()) != null) {
            return DDProvider.getDefault().getDDRoot(fileObject);
        }
        return null;
    }

    public String getApplicationPathFromDD() throws IOException {
        ServletMapping servletMapping;
        WebApp webApp = this.findWebApp();
        if (webApp != null && (servletMapping = this.getRestServletMapping(webApp)) != null) {
            String string = null;
            if (servletMapping instanceof ServletMapping25) {
                String[] stringArray = ((ServletMapping25)servletMapping).getUrlPatterns();
                if (stringArray.length > 0) {
                    string = stringArray[0];
                }
            } else {
                string = servletMapping.getUrlPattern();
            }
            if (string != null) {
                if (string.endsWith("*")) {
                    string = string.substring(0, string.length() - 1);
                }
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                return string;
            }
        }
        return null;
    }

    protected FileObject getDeploymentDescriptor() {
        WebModuleProvider webModuleProvider = (WebModuleProvider)this.project.getLookup().lookup(WebModuleProvider.class);
        if (webModuleProvider != null) {
            return webModuleProvider.findWebModule(this.project.getProjectDirectory()).getDeploymentDescriptor();
        }
        return null;
    }

    public FileObject getWebXml() throws IOException {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null) {
            FileObject fileObject = webModule.getDeploymentDescriptor();
            if (fileObject == null) {
                FileObject fileObject2;
                FileObject fileObject3 = webModule.getWebInf();
                if (fileObject3 == null && (fileObject2 = webModule.getDocumentBase()) != null) {
                    fileObject3 = fileObject2.createFolder("WEB-INF");
                }
                if (fileObject3 != null) {
                    fileObject = DDHelper.createWebXml((Profile)webModule.getJ2eeProfile(), (FileObject)fileObject3);
                }
            }
            return fileObject;
        }
        return null;
    }

    public ServletMapping getRestServletMapping(WebApp webApp) {
        String string = null;
        for (Servlet servlet : webApp.getServlet()) {
            String string2 = servlet.getServletClass();
            if (!"com.sun.jersey.spi.container.servlet.ServletContainer".equals(string2) && !"com.sun.jersey.spi.spring.container.servlet.SpringServlet".equals(string2)) continue;
            string = servlet.getServletName();
            break;
        }
        if (string != null) {
            for (Servlet servlet : webApp.getServletMapping()) {
                if (!string.equals(servlet.getServletName())) continue;
                return servlet;
            }
        }
        return null;
    }

    protected boolean hasRestServletAdaptor() {
        try {
            return this.getRestServletAdaptor(this.getWebApp()) != null;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    protected Servlet getRestServletAdaptor(WebApp webApp) {
        if (webApp != null) {
            for (Servlet servlet : webApp.getServlet()) {
                String string = servlet.getServletClass();
                if (!"com.sun.jersey.spi.container.servlet.ServletContainer".equals(string) && !"com.sun.jersey.spi.spring.container.servlet.SpringServlet".equals(string) && !"com.sun.ws.rest.impl.container.servlet.ServletAdaptor".equals(string)) continue;
                return servlet;
            }
        }
        return null;
    }

    protected Servlet getRestServletAdaptorByName(WebApp webApp, String string) {
        if (webApp != null) {
            for (Servlet servlet : webApp.getServlet()) {
                if (!string.equals(servlet.getServletName())) continue;
                return servlet;
            }
        }
        return null;
    }

    public void addResourceConfigToWebApp(String string) throws IOException {
        FileObject fileObject = this.getWebXml();
        WebApp webApp = this.getWebApp();
        if (webApp == null) {
            return;
        }
        boolean bl = false;
        try {
            Servlet servlet = this.getRestServletAdaptor(webApp);
            if (servlet == null) {
                servlet = (Servlet)webApp.createBean("Servlet");
                servlet.setServletName("ServletAdaptor");
                servlet.setServletClass(this.getServletAdapterClass());
                servlet.setLoadOnStartup(BigInteger.valueOf(1L));
                webApp.addServlet(servlet);
                bl = true;
            }
            String string2 = string;
            if (!string.startsWith("/")) {
                string2 = "/" + string;
            }
            if (string2.endsWith("/")) {
                string2 = string2 + "*";
            } else if (!string2.endsWith("*")) {
                string2 = string2 + "/*";
            }
            ServletMapping servletMapping = this.getRestServletMapping(webApp);
            if (servletMapping == null) {
                servletMapping = (ServletMapping)webApp.createBean("ServletMapping");
                servletMapping.setServletName(servlet.getServletName());
                if (servletMapping instanceof ServletMapping25) {
                    ((ServletMapping25)servletMapping).addUrlPattern(string2);
                } else {
                    servletMapping.setUrlPattern(string2);
                }
                webApp.addServletMapping(servletMapping);
                bl = true;
            } else {
                String[] stringArray;
                boolean bl2 = false;
                if (servletMapping instanceof ServletMapping25) {
                    stringArray = ((ServletMapping25)servletMapping).getUrlPatterns();
                    if (stringArray.length == 0 || !string2.equals(stringArray[0])) {
                        bl2 = true;
                    }
                } else if (!string2.equals(servletMapping.getUrlPattern())) {
                    bl2 = true;
                }
                if (bl2) {
                    if (servletMapping instanceof ServletMapping25) {
                        stringArray = ((ServletMapping25)servletMapping).getUrlPatterns();
                        if (stringArray.length > 0) {
                            ((ServletMapping25)servletMapping).setUrlPattern(0, string2);
                        } else {
                            ((ServletMapping25)servletMapping).addUrlPattern(string2);
                        }
                    } else {
                        servletMapping.setUrlPattern(string2);
                    }
                    bl = true;
                }
            }
            if (bl) {
                webApp.write(fileObject);
                this.logResourceCreation(this.project);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(classNotFoundException);
        }
    }

    protected void removeResourceConfigFromWebApp() throws IOException {
        FileObject fileObject = this.getWebXml();
        WebApp webApp = this.getWebApp();
        if (webApp == null) {
            return;
        }
        boolean bl = false;
        Servlet servlet = this.getRestServletAdaptorByName(webApp, "ServletAdaptor");
        if (servlet != null) {
            webApp.removeServlet(servlet);
            bl = true;
        }
        for (ServletMapping servletMapping : webApp.getServletMapping()) {
            if (!"ServletAdaptor".equals(servletMapping.getServletName())) continue;
            webApp.removeServletMapping(servletMapping);
            bl = true;
            break;
        }
        if (bl) {
            webApp.write(fileObject);
        }
    }

    protected void logResourceCreation(Project project) {
    }

    public List<RestApplication> getRestApplications() {
        RestApplicationModel restApplicationModel = this.getRestApplicationsModel();
        if (restApplicationModel != null) {
            try {
                return (List)restApplicationModel.runReadAction((MetadataModelAction)new MetadataModelAction<RestApplications, List<RestApplication>>(){

                    public List<RestApplication> run(RestApplications restApplications) throws IOException {
                        return restApplications.getRestApplications();
                    }
                });
            }
            catch (IOException iOException) {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    protected String setApplicationConfigProperty(boolean bl) {
        ApplicationConfigPanel applicationConfigPanel = new ApplicationConfigPanel(bl);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)applicationConfigPanel, NbBundle.getMessage(WebRestSupport.class, (String)"TTL_ApplicationConfigPanel"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (NotifyDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            String string = applicationConfigPanel.getConfigType();
            this.setProjectProperty(PROP_REST_CONFIG_TYPE, string);
            if (CONFIG_TYPE_IDE.equals(string)) {
                String string2 = applicationConfigPanel.getApplicationPath();
                if (string2.startsWith("/")) {
                    string2 = string2.substring(1);
                }
                this.setProjectProperty(PROP_REST_RESOURCES_PATH, string2);
            } else if (CONFIG_TYPE_DD.equals(string)) {
                return applicationConfigPanel.getApplicationPath();
            }
        }
        return null;
    }
}

