/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.target.iterator.api;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.target.iterator.api.BrowseFolders;
import org.netbeans.modules.target.iterator.api.TargetChooserPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TargetChooserPanelGUI<T>
extends JPanel
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = -1977566644151991912L;
    private JButton browseButton;
    private JPanel customPanel;
    private JTextField documentNameTextField;
    private JTextField fileTextField;
    private JPanel fillerPanel;
    private JLabel folderLabel;
    private JTextField folderTextField;
    private JComboBox locationCB;
    private JLabel locationLabel;
    private JLabel nameLabel;
    private JLabel pathLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JSeparator targetSeparator;
    private TargetChooserPanel<T> myWizardPanel;

    public TargetChooserPanelGUI(TargetChooserPanel<T> targetChooserPanel) {
        this.myWizardPanel = targetChooserPanel;
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_TargetPanel", (Object)targetChooserPanel.getProvider().getUIManager().getAccessibleDescription()));
        targetChooserPanel.getProvider().getUIManager().initComponents(this.customPanel, targetChooserPanel, this);
        this.browseButton.addActionListener(this);
        this.documentNameTextField.getDocument().addDocumentListener(this);
        this.folderTextField.getDocument().addDocumentListener(this);
        this.setName(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"TITLE_name_location"));
    }

    public String getDocumentName() {
        return this.documentNameTextField.getText().trim();
    }

    public String getFolder() {
        return this.folderTextField.getText();
    }

    public void setFile(String string) {
        this.fileTextField.setText(string);
    }

    public String getFile() {
        return this.fileTextField.getText();
    }

    public void setNameLabel(String string) {
        this.nameLabel.setText(string);
    }

    public void addLocationListener(ActionListener actionListener) {
        this.locationCB.addActionListener(actionListener);
    }

    public String getSelectedFolder() {
        return this.getLocationRoot().getName();
    }

    public void initValues() {
        FileObject fileObject;
        String string;
        String string2;
        this.getPanel().getProvider().getUIManager().initValues(this.getPanel(), this);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.getPanel().getProject()).getDisplayName());
        if (this.getPanel().getSourceGroups() != null && this.getPanel().getSourceGroups().length > 0) {
            this.locationCB.setModel(new DefaultComboBoxModel<Object>(this.getLocations(this.getPanel().getSourceGroups())));
        } else {
            this.locationCB.setModel(new DefaultComboBoxModel<Object>(new Object[]{new LocationItem(this.getPanel().getProject().getProjectDirectory())}));
        }
        String string3 = null;
        FileObject fileObject2 = Templates.getTargetFolder((WizardDescriptor)this.getPanel().getTemplateWizard());
        if (fileObject2 != null) {
            for (int i = 0; string3 == null && i < this.locationCB.getModel().getSize(); ++i) {
                string2 = ((LocationItem)this.locationCB.getModel().getElementAt(i)).getFileObject();
                if (!fileObject2.equals(string2) && !FileUtil.isParentOf((FileObject)string2, (FileObject)fileObject2)) continue;
                string3 = FileUtil.getRelativePath((FileObject)string2, (FileObject)fileObject2);
                this.locationCB.getModel().setSelectedItem(this.locationCB.getModel().getElementAt(i));
                break;
            }
        }
        this.getPanel().getProvider().getUIManager().initFolderValue(this.getPanel(), string3, this.folderTextField);
        string2 = string = this.getPanel().getProvider().getNewFileName();
        File file = this.getFileCreationRoot();
        if (file != null && (fileObject = FileUtil.toFileObject((File)file)) != null) {
            FileObject fileObject3;
            int n = 0;
            while ((fileObject3 = fileObject.getFileObject(string, this.getPanel().getProvider().getExpectedExtension(this.getPanel()))) != null) {
                string = string2 + ++n;
            }
        }
        this.documentNameTextField.setText(string);
    }

    private Object[] getLocations(SourceGroup[] sourceGroupArray) {
        Object[] objectArray = new Object[sourceGroupArray.length];
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            objectArray[i] = new LocationItem(sourceGroupArray[i]);
        }
        return objectArray;
    }

    private String getRelativeSourcesFolder() {
        FileObject fileObject = ((LocationItem)this.locationCB.getModel().getSelectedItem()).getFileObject();
        String string = this.getPanel().getProvider().getRelativeSourcesFolder(this.getPanel(), fileObject);
        if (string == null) {
            string = "";
        }
        return string.length() == 0 ? "" : string + '/';
    }

    public String getRelativeTargetFolder() {
        return this.getRelativeSourcesFolder() + this.getNormalizedFolder();
    }

    public String getNormalizedFolder() {
        int n;
        String string = this.folderTextField.getText().trim();
        if (string.length() == 0) {
            return "";
        }
        string = string.replace('\\', '/');
        for (n = 0; n < string.length() && string.charAt(n) == '/'; ++n) {
        }
        if (n == string.length()) {
            return "";
        }
        string = string.substring(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        StringBuilder stringBuilder = new StringBuilder(stringTokenizer.nextToken());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() <= 0) continue;
            stringBuilder.append('/');
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public String getTargetFolder() {
        return this.getTargetFile().getPath();
    }

    public File getTargetFile() {
        String string = this.getRelativeTargetFolder();
        return this.getPanel().getProvider().getTargetFile(this.getPanel(), this.getLocationRoot(), string);
    }

    public String getTargetName() {
        String string = this.documentNameTextField.getText().trim();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.browseButton == actionEvent.getSource()) {
            Sources sources;
            FileObject fileObject = null;
            if (this.getPanel().getSourceGroups() != null) {
                fileObject = BrowseFolders.showDialog(this.getPanel().getSourceGroups(), DataFolder.class, this.folderTextField.getText().replace(File.separatorChar, '/'));
            } else {
                sources = ProjectUtils.getSources((Project)this.getPanel().getProject());
                fileObject = BrowseFolders.showDialog(sources.getSourceGroups("generic"), DataFolder.class, this.folderTextField.getText().replace(File.separatorChar, '/'));
            }
            if (fileObject != null && fileObject.isFolder()) {
                sources = ((LocationItem)this.locationCB.getSelectedItem()).getFileObject();
                this.folderTextField.setText(FileUtil.getRelativePath((FileObject)sources, (FileObject)fileObject));
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        File file = FileUtil.toFile((FileObject)((LocationItem)this.locationCB.getSelectedItem()).getFileObject());
        if (file != null) {
            String string = this.documentNameTextField.getText().trim();
            if (string.length() == 0) {
                this.fileTextField.setText("");
            } else {
                StringBuilder stringBuilder = new StringBuilder(string);
                String string2 = this.getPanel().getProvider().getResultExtension(this.getPanel());
                if (string2 != null && string2.length() > 0) {
                    stringBuilder.append('.');
                    stringBuilder.append(string2);
                }
                File file2 = new File(new File(file, this.folderTextField.getText().replace('/', File.separatorChar)), stringBuilder.toString());
                this.fileTextField.setText(file2.getAbsolutePath());
            }
        } else {
            this.fileTextField.setText("");
        }
        this.getPanel().getProvider().getUIManager().changeUpdate(documentEvent, this.getPanel());
        this.myWizardPanel.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    String getErrorMessage() {
        return this.getPanel().getProvider().getUIManager().getErrorMessage(this.getPanel());
    }

    boolean isPanelValid() {
        return this.getPanel().getProvider().getUIManager().isPanelValid();
    }

    FileObject getLocationRoot() {
        return ((LocationItem)this.locationCB.getModel().getSelectedItem()).getFileObject();
    }

    String getCreatedFilePath() {
        return this.fileTextField.getText();
    }

    private File getFileCreationRoot() {
        File file = FileUtil.toFile((FileObject)((LocationItem)this.locationCB.getSelectedItem()).getFileObject());
        if (file != null) {
            return new File(file, this.folderTextField.getText().replace('/', File.separatorChar));
        }
        return null;
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.documentNameTextField = new JTextField();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationCB = new JComboBox();
        this.folderLabel = new JLabel();
        this.folderTextField = new JTextField();
        this.browseButton = new JButton();
        this.pathLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.targetSeparator = new JSeparator();
        this.customPanel = new JPanel();
        this.fillerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.nameLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_FileName_mnem").charAt(0));
        this.nameLabel.setLabelFor(this.documentNameTextField);
        this.nameLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_JspName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.documentNameTextField, gridBagConstraints);
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_FileName"));
        this.projectLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_Project_mnem").charAt(0));
        this.projectLabel.setLabelFor(this.projectTextField);
        this.projectLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.projectLabel, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_Project"));
        this.locationLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_Location_mnem").charAt(0));
        this.locationLabel.setLabelFor(this.locationCB);
        this.locationLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.locationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.locationCB, gridBagConstraints);
        this.locationCB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_Location"));
        this.folderLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_Folder_mnem").charAt(0));
        this.folderLabel.setLabelFor(this.folderTextField);
        this.folderLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Folder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.folderLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.folderTextField, gridBagConstraints);
        this.folderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_Folder"));
        this.browseButton.setMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Browse_Mnemonic").charAt(0));
        this.browseButton.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Browse"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"ACSD_Browse"));
        this.pathLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_CreatedFile_mnem").charAt(0));
        this.pathLabel.setLabelFor(this.fileTextField);
        this.pathLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_CreatedFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.pathLabel, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_CreatedFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.customPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.customPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillerPanel, gridBagConstraints);
    }

    private TargetChooserPanel<T> getPanel() {
        return this.myWizardPanel;
    }

    public static class LocationItem {
        FileObject myFileObject;
        SourceGroup myGroup;

        public LocationItem(FileObject fileObject) {
            this.myFileObject = fileObject;
        }

        public LocationItem(SourceGroup sourceGroup) {
            this.myFileObject = sourceGroup.getRootFolder();
            this.myGroup = sourceGroup;
        }

        public FileObject getFileObject() {
            return this.myFileObject;
        }

        public String toString() {
            return this.myGroup == null ? this.myFileObject.getName() : this.myGroup.getDisplayName();
        }
    }
}

