/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.hints;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.groovy.editor.actions.FixImportsHelper;
import org.netbeans.modules.groovy.editor.api.GroovyCompilerErrorID;
import org.netbeans.modules.groovy.editor.api.parser.GroovyError;
import org.netbeans.modules.groovy.editor.hints.infrastructure.GroovyErrorRule;
import org.netbeans.modules.groovy.editor.hints.infrastructure.GroovyRuleContext;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNotFoundRule
extends GroovyErrorRule {
    public static final Logger LOG = Logger.getLogger(ClassNotFoundRule.class.getName());
    private final String DESC = NbBundle.getMessage(ClassNotFoundRule.class, (String)"FixImportsHintDescription");
    private final FixImportsHelper helper = new FixImportsHelper();

    @Override
    public Set<GroovyCompilerErrorID> getCodes() {
        LOG.log(Level.FINEST, "getCodes()");
        HashSet<GroovyCompilerErrorID> hashSet = new HashSet<GroovyCompilerErrorID>();
        hashSet.add(GroovyCompilerErrorID.CLASS_NOT_FOUND);
        return hashSet;
    }

    @Override
    public void run(GroovyRuleContext groovyRuleContext, GroovyError groovyError, List<Hint> list) {
        LOG.log(Level.FINEST, "run()");
        String string = groovyError.getDescription();
        if (string == null) {
            LOG.log(Level.FINEST, "desc == null");
            return;
        }
        LOG.log(Level.FINEST, "Processing : {0}", string);
        String string2 = FixImportsHelper.getMissingClassName(string);
        if (string2 == null) {
            return;
        }
        FileObject fileObject = groovyRuleContext.parserResult.getSnapshot().getSource().getFileObject();
        List<FixImportsHelper.ImportCandidate> list2 = this.helper.getImportCandidate(fileObject, string2);
        if (list2.isEmpty()) {
            return;
        }
        int n = 292;
        int n2 = 0;
        int n3 = 0;
        try {
            n2 = Utilities.getRowStart((BaseDocument)groovyRuleContext.doc, (int)groovyError.getStartPosition());
            n3 = Utilities.getRowEnd((BaseDocument)groovyRuleContext.doc, (int)groovyError.getEndPosition());
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.FINEST, "Processing : {0}", badLocationException);
            return;
        }
        OffsetRange offsetRange = new OffsetRange(n2, n3);
        for (FixImportsHelper.ImportCandidate importCandidate : list2) {
            ArrayList<AddImportFix> arrayList = new ArrayList<AddImportFix>(1);
            String string3 = importCandidate.getFqnName();
            AddImportFix addImportFix = new AddImportFix(fileObject, string3);
            arrayList.add(addImportFix);
            Hint hint = new Hint((Rule)this, addImportFix.getDescription(), fileObject, offsetRange, arrayList, n);
            list.add(hint);
        }
    }

    public boolean appliesTo(RuleContext ruleContext) {
        return true;
    }

    public String getDisplayName() {
        return this.DESC;
    }

    public boolean showInTasklist() {
        return false;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.ERROR;
    }

    private class AddImportFix
    implements HintFix {
        String HINT_PREFIX = NbBundle.getMessage(ClassNotFoundRule.class, (String)"ClassNotFoundRuleHintDescription");
        FileObject fo;
        String fqn;

        public AddImportFix(FileObject fileObject, String string) {
            this.fo = fileObject;
            this.fqn = string;
        }

        public String getDescription() {
            return this.HINT_PREFIX + " " + this.fqn;
        }

        public void implement() throws Exception {
            ClassNotFoundRule.this.helper.doImport(this.fo, this.fqn);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

