/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableFinderVisitor
extends ClassCodeVisitorSupport {
    private final SourceUnit sourceUnit;
    private final AstPath path;
    private final BaseDocument doc;
    private final int cursorOffset;
    private Set<ASTNode> blocks = new HashSet<ASTNode>();
    private Map<String, Variable> variables = new HashMap<String, Variable>();

    public VariableFinderVisitor(SourceUnit sourceUnit, AstPath astPath, BaseDocument baseDocument, int n) {
        this.sourceUnit = sourceUnit;
        this.path = astPath;
        this.doc = baseDocument;
        this.cursorOffset = n;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public Collection<Variable> getVariables() {
        return this.variables.values();
    }

    public void collect() {
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getPositionedSequence(this.doc, this.cursorOffset);
        if (tokenSequence == null) {
            return;
        }
        Token token = tokenSequence.token();
        if (token == null) {
            return;
        }
        ASTNode aSTNode = null;
        this.blocks.clear();
        this.variables.clear();
        for (ASTNode aSTNode2 : this.path) {
            if (!(aSTNode2 instanceof ClosureExpression) && !(aSTNode2 instanceof MethodNode) && !(aSTNode2 instanceof ConstructorNode) && !(aSTNode2 instanceof ForStatement) && !(aSTNode2 instanceof BlockStatement) && !(aSTNode2 instanceof ClosureListExpression) && !(aSTNode2 instanceof CatchStatement)) continue;
            aSTNode = aSTNode2;
            this.blocks.add(aSTNode2);
            if (!(aSTNode2 instanceof ForStatement) || !(((ForStatement)aSTNode2).getCollectionExpression() instanceof ClosureListExpression)) continue;
            this.blocks.add(((ForStatement)aSTNode2).getCollectionExpression());
        }
        if (aSTNode instanceof ClosureExpression) {
            this.visitClosureExpression((ClosureExpression)aSTNode);
        } else if (aSTNode instanceof MethodNode) {
            this.visitMethod((MethodNode)aSTNode);
        } else if (aSTNode instanceof ConstructorNode) {
            this.visitConstructor((ConstructorNode)aSTNode);
        } else if (aSTNode instanceof ForStatement) {
            this.visitForLoop((ForStatement)aSTNode);
        } else if (aSTNode instanceof BlockStatement) {
            this.visitBlockStatement((BlockStatement)aSTNode);
        } else if (aSTNode instanceof ClosureListExpression) {
            this.visitClosureListExpression((ClosureListExpression)aSTNode);
        } else if (aSTNode instanceof CatchStatement) {
            this.visitCatchStatement((CatchStatement)aSTNode);
        }
    }

    @Override
    public void visitDeclarationExpression(DeclarationExpression declarationExpression) {
        if (this.blocks.isEmpty() && declarationExpression.getLineNumber() >= 0 && declarationExpression.getColumnNumber() >= 0 && this.path.getLineNumber() >= 0 && this.path.getColumnNumber() >= 0 && (declarationExpression.getLineNumber() > this.path.getLineNumber() || declarationExpression.getLineNumber() == this.path.getLineNumber() && declarationExpression.getColumnNumber() >= this.path.getColumnNumber())) {
            return;
        }
        VariableExpression variableExpression = declarationExpression.getVariableExpression();
        if (variableExpression.getAccessedVariable() != null) {
            String string = variableExpression.getAccessedVariable().getName();
            this.variables.put(string, variableExpression.getAccessedVariable());
        }
        super.visitDeclarationExpression(declarationExpression);
    }

    @Override
    public void visitBinaryExpression(BinaryExpression binaryExpression) {
        String string;
        VariableExpression variableExpression;
        if (this.blocks.isEmpty() && binaryExpression.getLineNumber() >= 0 && binaryExpression.getColumnNumber() >= 0 && this.path.getLineNumber() >= 0 && this.path.getColumnNumber() >= 0 && (binaryExpression.getLineNumber() > this.path.getLineNumber() || binaryExpression.getLineNumber() == this.path.getLineNumber() && binaryExpression.getColumnNumber() >= this.path.getColumnNumber())) {
            return;
        }
        Expression expression = binaryExpression.getLeftExpression();
        if (expression instanceof VariableExpression && binaryExpression.getOperation().isA(100) && (variableExpression = (VariableExpression)expression).getAccessedVariable() != null && !this.variables.containsKey(string = variableExpression.getAccessedVariable().getName())) {
            this.variables.put(string, variableExpression.getAccessedVariable());
        }
        super.visitBinaryExpression(binaryExpression);
    }

    @Override
    public void visitMethod(MethodNode methodNode) {
        if (!this.blocks.remove(methodNode)) {
            return;
        }
        for (Parameter parameter : methodNode.getParameters()) {
            this.variables.put(parameter.getName(), parameter);
        }
        super.visitMethod(methodNode);
    }

    @Override
    public void visitCatchStatement(CatchStatement catchStatement) {
        if (!this.blocks.remove(catchStatement)) {
            return;
        }
        if (catchStatement.getVariable() != null) {
            String string = catchStatement.getVariable().getName();
            this.variables.put(string, catchStatement.getVariable());
        }
        super.visitCatchStatement(catchStatement);
    }

    @Override
    public void visitClosureExpression(ClosureExpression closureExpression) {
        if (!this.blocks.remove(closureExpression)) {
            return;
        }
        if (closureExpression.isParameterSpecified()) {
            for (Parameter parameter : closureExpression.getParameters()) {
                this.variables.put(parameter.getName(), parameter);
            }
        } else {
            this.variables.put("it", new VariableExpression("it"));
        }
        super.visitClosureExpression(closureExpression);
    }

    @Override
    public void visitConstructor(ConstructorNode constructorNode) {
        if (!this.blocks.remove(constructorNode)) {
            return;
        }
        for (Parameter parameter : constructorNode.getParameters()) {
            this.variables.put(parameter.getName(), parameter);
        }
        super.visitConstructor(constructorNode);
    }

    @Override
    public void visitForLoop(ForStatement forStatement) {
        if (!this.blocks.remove(forStatement)) {
            return;
        }
        Parameter parameter = forStatement.getVariable();
        if (parameter != ForStatement.FOR_LOOP_DUMMY) {
            this.variables.put(parameter.getName(), parameter);
        }
        super.visitForLoop(forStatement);
    }

    @Override
    public void visitBlockStatement(BlockStatement blockStatement) {
        if (!this.blocks.remove(blockStatement)) {
            return;
        }
        super.visitBlockStatement(blockStatement);
    }

    @Override
    public void visitClosureListExpression(ClosureListExpression closureListExpression) {
        if (!this.blocks.remove(closureListExpression)) {
            return;
        }
        super.visitClosureListExpression(closureListExpression);
    }
}

