/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.groovy.editor.api.AstUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticAnalysisVisitor
extends ClassCodeVisitorSupport {
    private final ModuleNode root;
    private final BaseDocument doc;
    private final Map<OffsetRange, Set<ColoringAttributes>> highlights;

    public SemanticAnalysisVisitor(ModuleNode moduleNode, BaseDocument baseDocument) {
        this.root = moduleNode;
        this.doc = baseDocument;
        this.highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>();
    }

    public Map<OffsetRange, Set<ColoringAttributes>> annotate() {
        this.highlights.clear();
        for (Object e : this.root.getClasses()) {
            this.visitClass((ClassNode)e);
        }
        for (Object e : this.root.getMethods()) {
            this.visitMethod((MethodNode)e);
        }
        this.visitBlockStatement(this.root.getStatementBlock());
        return this.highlights;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.root.getContext();
    }

    @Override
    public void visitField(FieldNode fieldNode) {
        if (fieldNode.getLineNumber() > 0) {
            OffsetRange offsetRange = AstUtilities.getRange(fieldNode, this.doc);
            EnumSet<ColoringAttributes> enumSet = EnumSet.of(ColoringAttributes.FIELD);
            if (fieldNode.isStatic()) {
                enumSet.add(ColoringAttributes.STATIC);
            }
            this.highlights.put(offsetRange, enumSet);
        }
        super.visitField(fieldNode);
    }

    @Override
    public void visitConstructor(ConstructorNode constructorNode) {
        if (constructorNode.getLineNumber() > 0) {
            OffsetRange offsetRange = AstUtilities.getRange(constructorNode, this.doc);
            this.highlights.put(offsetRange, ColoringAttributes.CONSTRUCTOR_SET);
        }
        super.visitConstructor(constructorNode);
    }

    @Override
    public void visitMethod(MethodNode methodNode) {
        if (methodNode.getLineNumber() > 0) {
            OffsetRange offsetRange = AstUtilities.getRange(methodNode, this.doc);
            EnumSet<ColoringAttributes> enumSet = EnumSet.of(ColoringAttributes.METHOD);
            if (methodNode.isStatic()) {
                enumSet.add(ColoringAttributes.STATIC);
            }
            this.highlights.put(offsetRange, enumSet);
        }
        super.visitMethod(methodNode);
    }

    @Override
    public void visitPropertyExpression(PropertyExpression propertyExpression) {
        super.visitPropertyExpression(propertyExpression);
    }

    @Override
    public void visitClass(ClassNode classNode) {
        if (classNode.getLineNumber() > 0) {
            OffsetRange offsetRange = AstUtilities.getRange(classNode, this.doc);
            this.highlights.put(offsetRange, ColoringAttributes.CLASS_SET);
        }
        super.visitClass(classNode);
    }

    @Override
    public void visitVariableExpression(VariableExpression variableExpression) {
        Variable variable = variableExpression.getAccessedVariable();
        if (variable instanceof FieldNode && variableExpression.getLineNumber() > 0) {
            OffsetRange offsetRange = AstUtilities.getRange(variableExpression, this.doc);
            this.highlights.put(offsetRange, ColoringAttributes.FIELD_SET);
        }
        super.visitVariableExpression(variableExpression);
    }
}

