/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.actions;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.groovy.editor.api.NbUtilities;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixImportsHelper {
    private final Logger LOG = Logger.getLogger(FixImportsHelper.class.getName());

    public List<ImportCandidate> getImportCandidate(FileObject fileObject, String string) {
        this.LOG.log(Level.FINEST, "Looking for class: " + string);
        ArrayList<ImportCandidate> arrayList = new ArrayList<ImportCandidate>();
        ClasspathInfo classpathInfo = NbUtilities.getClasspathInfoForFileObject(fileObject);
        if (classpathInfo == null) {
            this.LOG.log(Level.FINEST, "Problem getting ClasspathInfo");
            return arrayList;
        }
        Set set = classpathInfo.getClassIndex().getDeclaredTypes(string, ClassIndex.NameKind.SIMPLE_NAME, EnumSet.allOf(ClassIndex.SearchScope.class));
        for (ElementHandle elementHandle : set) {
            ElementKind elementKind = elementHandle.getKind();
            if (elementKind != ElementKind.CLASS && elementKind != ElementKind.INTERFACE) continue;
            String string2 = elementHandle.getQualifiedName();
            this.LOG.log(Level.FINEST, "Found     : " + string2);
            Icon icon = ElementIcons.getElementIcon((ElementKind)elementKind, null);
            int n = FixImportsHelper.getImportanceLevel(string2);
            ImportCandidate importCandidate = new ImportCandidate(string, string2, icon, n);
            arrayList.add(importCandidate);
        }
        return arrayList;
    }

    public static int getImportanceLevel(String string) {
        int n = 50;
        if (string.startsWith("java.lang") || string.startsWith("java.util")) {
            n -= 10;
        } else if (string.startsWith("org.omg") || string.startsWith("org.apache")) {
            n += 10;
        } else if (string.startsWith("com.sun") || string.startsWith("com.ibm") || string.startsWith("com.apple")) {
            n += 20;
        } else if (string.startsWith("sun") || string.startsWith("sunw") || string.startsWith("netscape")) {
            n += 30;
        }
        return n;
    }

    public static String getMissingClassName(String string) {
        int n;
        String string2 = "unable to resolve class ";
        String string3 = null;
        if (string.startsWith(string2) && (n = (string3 = string.substring(string2.length())).indexOf(" ")) != -1) {
            return string3.substring(0, n);
        }
        return string3;
    }

    int getImportPosition(BaseDocument baseDocument) {
        int n;
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(baseDocument, 1);
        int n2 = -1;
        int n3 = -1;
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            n = tokenSequence.offset();
            if (token.id() == GroovyTokenId.LITERAL_import) {
                this.LOG.log(Level.FINEST, "GroovyTokenId.LITERAL_import found");
                n2 = n;
                continue;
            }
            if (token.id() != GroovyTokenId.LITERAL_package) continue;
            this.LOG.log(Level.FINEST, "GroovyTokenId.LITERAL_package found");
            n3 = n;
        }
        int n4 = 0;
        if (n2 != -1 && n3 > n2) {
            this.LOG.log(Level.FINEST, "packageOffset > importEnd");
            return -1;
        }
        if (n2 == -1 && n3 == -1) {
            this.LOG.log(Level.FINEST, "importEnd == -1 && packageOffset == -1");
            return 0;
        }
        if (n2 == -1 && n3 != -1) {
            this.LOG.log(Level.FINEST, "importEnd == -1 && packageOffset != -1");
            n4 = n3;
        } else if (n2 != -1 && n3 == -1) {
            this.LOG.log(Level.FINEST, "importEnd != -1 && packageOffset == -1");
            n4 = n2;
        } else if (n2 != -1 && n3 != -1) {
            this.LOG.log(Level.FINEST, "importEnd != -1 && packageOffset != -1");
            n4 = n2;
        }
        n = 0;
        try {
            n = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n4);
        }
        catch (BadLocationException badLocationException) {
            this.LOG.log(Level.FINEST, "BadLocationException for offset : {0}", n4);
            this.LOG.log(Level.FINEST, "BadLocationException : {0}", badLocationException.getMessage());
            return -1;
        }
        return Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(n + 1));
    }

    public void doImport(FileObject fileObject, String string) throws MissingResourceException {
        int n = 0;
        BaseDocument baseDocument = LexUtilities.getDocument(fileObject, true);
        n = this.getImportPosition(baseDocument);
        if (n != -1) {
            if (baseDocument == null) {
                return;
            }
            EditList editList = new EditList(baseDocument);
            this.LOG.log(Level.FINEST, "Importing here: " + n);
            editList.replace(n, 0, "import " + string + "\n", false, 0);
            editList.apply();
        }
    }

    public static class ImportCandidate {
        String name;
        String fqnName;
        Icon icon;
        int importantsLevel;

        public ImportCandidate(String string, String string2, Icon icon, int n) {
            this.name = string;
            this.fqnName = string2;
            this.icon = icon;
            this.importantsLevel = n;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getFqnName() {
            return this.fqnName;
        }

        public void setFqnName(String string) {
            this.fqnName = string;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public int getImportantsLevel() {
            return this.importantsLevel;
        }

        public void setImportantsLevel(int n) {
            this.importantsLevel = n;
        }
    }
}

