/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.explorer.node.SchemaNode;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaNodeProvider
extends NodeProvider {
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private final MetadataElementHandle<Catalog> catalogHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private SchemaNodeProvider(Lookup lookup) {
        super(lookup, new SchemaComparator());
    }

    @Override
    protected synchronized void initialize() {
        final ArrayList<Node> arrayList = new ArrayList<Node>();
        boolean bl = !this.connection.getConnector().isDisconnected();
        MetadataModel metadataModel = this.connection.getMetadataModel();
        if (bl && metadataModel != null) {
            try {
                metadataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        Catalog catalog = (Catalog)SchemaNodeProvider.this.catalogHandle.resolve(metadata);
                        if (catalog != null) {
                            Schema schema = catalog.getSyntheticSchema();
                            if (schema != null) {
                                SchemaNodeProvider.this.updateNode(arrayList, schema);
                            } else {
                                Collection collection = catalog.getSchemas();
                                for (Schema schema2 : collection) {
                                    SchemaNodeProvider.this.updateNode(arrayList, schema2);
                                }
                            }
                            if (schema != null) {
                                SchemaNodeProvider.this.setProxyNodes(arrayList);
                            } else {
                                SchemaNodeProvider.this.setNodes(arrayList);
                            }
                        }
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, metadataModelException, true);
            }
        } else {
            this.setNodes(arrayList);
        }
    }

    private void updateNode(List<Node> list, Schema schema) {
        MetadataElementHandle metadataElementHandle = MetadataElementHandle.create((MetadataElement)schema);
        Collection<Node> collection = this.getNodes(metadataElementHandle);
        if (collection.size() > 0) {
            list.addAll(collection);
        } else {
            NodeDataLookup nodeDataLookup = new NodeDataLookup();
            nodeDataLookup.add(this.connection);
            nodeDataLookup.add(metadataElementHandle);
            list.add((Node)SchemaNode.create(nodeDataLookup, this));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SchemaComparator
    implements Comparator<Node> {
        SchemaComparator() {
        }

        @Override
        public int compare(Node node, Node node2) {
            return node.getDisplayName().compareToIgnoreCase(node2.getDisplayName());
        }
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            public SchemaNodeProvider createInstance(Lookup lookup) {
                SchemaNodeProvider schemaNodeProvider = new SchemaNodeProvider(lookup);
                return schemaNodeProvider;
            }
        };

        private FactoryHolder() {
        }
    }
}

