/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.explorer.node.DriverNode;
import org.netbeans.modules.db.util.DriverListUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddDriverDialog
extends JPanel {
    private DefaultListModel dlm;
    private List<URL> drvs = new LinkedList<URL>();
    private boolean customizer = false;
    private ProgressHandle progressHandle;
    private JComponent progressComponent;
    private DialogDescriptor descriptor;
    private static final Logger LOGGER = Logger.getLogger(AddDriverDialog.class.getName());
    private JButton browseButton;
    private JComboBox drvClassComboBox;
    private JLabel drvClassLabel;
    private JList drvList;
    private JLabel drvListLabel;
    private JScrollPane drvListScrollPane;
    private JButton findButton;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JPanel progressContainerPanel;
    private JLabel progressMessageLabel;
    private JButton removeButton;

    private AddDriverDialog(DriverNode driverNode) {
        this.initComponents();
        this.initAccessibility();
        this.dlm = (DefaultListModel)this.drvList.getModel();
        if (driverNode != null) {
            this.setDriver(driverNode.getDatabaseDriver().getJDBCDriver());
        }
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                AddDriverDialog.this.updateState();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                AddDriverDialog.this.updateState();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                AddDriverDialog.this.updateState();
            }
        };
        this.nameTextField.getDocument().addDocumentListener(documentListener);
        this.drvList.getModel().addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                AddDriverDialog.this.updateState();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                AddDriverDialog.this.updateState();
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                AddDriverDialog.this.updateState();
            }
        });
        Component component = this.drvClassComboBox.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).getDocument().addDocumentListener(documentListener);
        }
    }

    private void setDriver(JDBCDriver jDBCDriver) {
        this.customizer = true;
        String string = null;
        URL[] uRLArray = jDBCDriver.getURLs();
        for (int i = 0; i < uRLArray.length; ++i) {
            Serializable serializable;
            FileObject fileObject;
            Serializable serializable2 = uRLArray[i];
            if ("nbinst".equals(((URL)serializable2).getProtocol()) && (fileObject = URLMapper.findFileObject((URL)serializable2)) != null && (serializable = URLMapper.findURL((FileObject)fileObject, (int)1)) != null) {
                serializable2 = serializable;
            }
            if ((fileObject = URLMapper.findFileObject((URL)serializable2)) != null) {
                serializable = FileUtil.toFile((FileObject)fileObject);
                if (serializable != null) {
                    string = ((File)serializable).getAbsolutePath();
                }
            } else if (((URL)serializable2).getProtocol().equals("file")) {
                try {
                    string = new File(new URI(((URL)serializable2).toExternalForm())).getAbsolutePath();
                }
                catch (URISyntaxException uRISyntaxException) {
                    Exceptions.printStackTrace((Throwable)uRISyntaxException);
                    string = null;
                }
            }
            if (string == null) continue;
            this.dlm.addElement(string);
            this.drvs.add(uRLArray[i]);
        }
        this.drvClassComboBox.addItem(jDBCDriver.getClassName());
        this.drvClassComboBox.setSelectedItem(jDBCDriver.getClassName());
        this.nameTextField.setText(jDBCDriver.getDisplayName());
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverDialogA11yDesc"));
        this.drvListLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverDriverFileA11yDesc"));
        this.drvList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverDriverFileListA11yName"));
        this.drvClassLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverDriverDriverClassA11yDesc"));
        this.drvClassComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverDriverDriverClassComboBoxA11yName"));
        this.nameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverDriverNameA11yDesc"));
        this.nameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverDriverNameTextFieldA11yName"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverAddButtonA11yDesc"));
        this.findButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverRemoveButtonA11yDesc"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverFindButtonA11yDesc"));
        this.progressContainerPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverProgressBarA11yName"));
        this.progressContainerPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDriverDialog.class, (String)"ACS_AddDriverProgressBarA11yDesc"));
    }

    private void initComponents() {
        this.drvListLabel = new JLabel();
        this.drvListScrollPane = new JScrollPane();
        this.drvList = new JList();
        this.browseButton = new JButton();
        this.removeButton = new JButton();
        this.drvClassLabel = new JLabel();
        this.drvClassComboBox = new JComboBox();
        this.findButton = new JButton();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.progressMessageLabel = new JLabel();
        this.progressContainerPanel = new JPanel();
        FormListener formListener = new FormListener();
        this.setLayout(new GridBagLayout());
        this.drvListLabel.setLabelFor(this.drvList);
        Mnemonics.setLocalizedText((JLabel)this.drvListLabel, (String)NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverDriverFile"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.drvListLabel, gridBagConstraints);
        this.drvList.setModel(new DefaultListModel());
        this.drvList.addListSelectionListener(formListener);
        this.drvListScrollPane.setViewportView(this.drvList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 11);
        this.add((Component)this.drvListScrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverDriverAdd"));
        this.browseButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(11, 0, 0, 11);
        this.add((Component)this.browseButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverDriverRemove"));
        this.removeButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(11, 0, 0, 11);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.drvClassLabel.setLabelFor(this.drvClassComboBox);
        Mnemonics.setLocalizedText((JLabel)this.drvClassLabel, (String)NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverDriverClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 12, 0, 12);
        this.add((Component)this.drvClassLabel, gridBagConstraints);
        this.drvClassComboBox.setEditable(true);
        this.drvClassComboBox.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 0, 0, 12);
        this.add((Component)this.drvClassComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.findButton, (String)NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverDriverFind"));
        this.findButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 0, 0, 11);
        this.add((Component)this.findButton, gridBagConstraints);
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverDriverName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 12, 0, 12);
        this.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 12);
        this.add((Component)this.nameTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.progressMessageLabel, (String)" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 0, 12);
        this.add((Component)this.progressMessageLabel, gridBagConstraints);
        this.progressContainerPanel.setMinimumSize(new Dimension(20, 20));
        this.progressContainerPanel.setPreferredSize(new Dimension(20, 20));
        this.progressContainerPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        this.add((Component)this.progressContainerPanel, gridBagConstraints);
    }

    private void drvClassComboBoxActionPerformed(ActionEvent actionEvent) {
        if (!this.customizer) {
            this.nameTextField.setText(DriverListUtil.findFreeName(DriverListUtil.getName((String)this.drvClassComboBox.getSelectedItem())));
        }
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        this.stopProgress();
        ListSelectionModel listSelectionModel = this.drvList.getSelectionModel();
        int n = this.dlm.getSize();
        int n2 = 0;
        if (n < 1) {
            return;
        }
        do {
            if (listSelectionModel.isSelectedIndex(n2)) {
                this.dlm.remove(n2);
                this.drvs.remove(n2);
                --n;
                continue;
            }
            ++n2;
        } while (n != n2);
        this.findDriverClass();
    }

    private void findButtonActionPerformed(ActionEvent actionEvent) {
        this.findDriverClassByInspection();
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        this.stopProgress();
        FileChooserBuilder fileChooserBuilder = new FileChooserBuilder(AddDriverDialog.class);
        fileChooserBuilder.setTitle(NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriver_Chooser_Title"));
        fileChooserBuilder.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".jar") || file.getName().endsWith(".zip");
            }

            public String getDescription() {
                return NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriver_Chooser_Filter");
            }
        });
        File[] fileArray = fileChooserBuilder.showMultiOpenDialog();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (!file.isFile()) continue;
                if (this.dlm.contains(file.toString())) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverDuplicateFile", (Object)file.toString()));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    continue;
                }
                this.dlm.addElement(file.toString());
                try {
                    this.drvs.add(file.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    LOGGER.log(Level.WARNING, "Unable to add driver jar file " + file.getAbsolutePath() + ": can not convert to URL", malformedURLException);
                }
            }
            this.findDriverClass();
        }
    }

    private void drvListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateState();
    }

    private boolean isDriverClass(URLClassLoader uRLClassLoader, String string) {
        Class<?> clazz;
        try {
            clazz = uRLClassLoader.loadClass(string);
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.FINE, null, throwable);
            LOGGER.log(Level.INFO, "Got an exception trying to load class " + string + " during search for JDBC drivers in " + " driver jar(s): " + throwable.getClass().getName() + ": " + throwable.getMessage() + ".  Skipping this class...");
            return false;
        }
        return Driver.class.isAssignableFrom(clazz);
    }

    public String getDisplayName() {
        return this.nameTextField.getText();
    }

    public List<URL> getDriverLocation() {
        return this.drvs;
    }

    public String getDriverClass() {
        return (String)this.drvClassComboBox.getSelectedItem();
    }

    private void findDriverClass() {
        String[] stringArray = DriverListUtil.getDrivers().toArray(new String[DriverListUtil.getDrivers().size()]);
        this.drvClassComboBox.removeAllItems();
        for (int i = 0; i < this.drvs.size(); ++i) {
            try {
                URL uRL;
                Object object;
                URL uRL2 = this.drvs.get(i);
                if ("nbinst".equals(uRL2.getProtocol()) && (object = URLMapper.findFileObject((URL)uRL2)) != null && (uRL = URLMapper.findURL((FileObject)object, (int)1)) != null) {
                    uRL2 = uRL;
                }
                object = new File(new URI(uRL2.toExternalForm()));
                JarFile jarFile = new JarFile((File)object);
                for (int j = 0; j < stringArray.length; ++j) {
                    if (jarFile.getEntry(stringArray[j].replace('.', '/') + ".class") == null) continue;
                    this.addDriverClass(stringArray[j]);
                }
                jarFile.close();
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private void findDriverClassByInspection() {
        this.drvClassComboBox.removeAllItems();
        this.findButton.setEnabled(false);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AddDriverDialog.this.startProgress();
                URLClassLoader uRLClassLoader = new URLClassLoader(AddDriverDialog.this.drvs.toArray(new URL[AddDriverDialog.this.drvs.size()]), this.getClass().getClassLoader());
                for (int i = 0; i < AddDriverDialog.this.dlm.size(); ++i) {
                    try {
                        String string = (String)AddDriverDialog.this.dlm.get(i);
                        JarFile jarFile = new JarFile(string);
                        try {
                            Enumeration<JarEntry> enumeration = jarFile.entries();
                            while (enumeration.hasMoreElements()) {
                                JarEntry jarEntry = enumeration.nextElement();
                                String string2 = jarEntry.getName();
                                if (!string2.endsWith(".class")) continue;
                                string2 = string2.replace('/', '.');
                                if (!AddDriverDialog.this.isDriverClass(uRLClassLoader, string2 = string2.substring(0, string2.length() - 6))) continue;
                                if (AddDriverDialog.this.progressHandle != null) {
                                    AddDriverDialog.this.addDriverClass(string2);
                                    continue;
                                }
                                AddDriverDialog.this.updateState();
                                return;
                            }
                            continue;
                        }
                        finally {
                            jarFile.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                AddDriverDialog.this.stopProgress();
                AddDriverDialog.this.updateState();
            }
        }, 0);
    }

    private void addDriverClass(String string) {
        if (((DefaultComboBoxModel)this.drvClassComboBox.getModel()).getIndexOf(string) < 0) {
            this.drvClassComboBox.addItem(string);
        }
    }

    private void startProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AddDriverDialog.this.progressHandle = ProgressHandleFactory.createHandle(null);
                AddDriverDialog.this.progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)AddDriverDialog.this.progressHandle);
                AddDriverDialog.this.progressContainerPanel.add((Component)AddDriverDialog.this.progressComponent, "Center");
                AddDriverDialog.this.progressHandle.start();
                AddDriverDialog.this.progressMessageLabel.setText(NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverProgressStart"));
            }
        });
    }

    private void stopProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (AddDriverDialog.this.progressHandle != null) {
                    AddDriverDialog.this.progressHandle.finish();
                    AddDriverDialog.this.progressHandle = null;
                    AddDriverDialog.this.progressMessageLabel.setText(" ");
                    AddDriverDialog.this.progressContainerPanel.remove(AddDriverDialog.this.progressComponent);
                    AddDriverDialog.this.repaint();
                }
            }
        });
    }

    private void setDescriptor(DialogDescriptor dialogDescriptor) {
        this.descriptor = dialogDescriptor;
        this.updateState();
    }

    private void updateState() {
        this.removeButton.setEnabled(this.drvList.getSelectedIndices().length > 0);
        this.findButton.setEnabled(this.progressHandle == null && this.drvList.getModel().getSize() > 0);
        String string = null;
        if (this.drvList.getModel().getSize() == 0) {
            string = NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverMissingFile");
        } else if (this.drvClassComboBox.getEditor().getItem().toString().length() == 0) {
            string = NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverMissingClass");
        } else if (this.nameTextField.getText().length() == 0) {
            string = NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverMissingName");
        } else if (!this.customizer && this.nameTextField.getText().length() > 0) {
            String string2 = this.nameTextField.getText();
            for (JDBCDriver jDBCDriver : JDBCDriverManager.getDefault().getDrivers()) {
                if (!jDBCDriver.getDisplayName().equalsIgnoreCase(string2)) continue;
                string = NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverDuplicateName");
                break;
            }
        }
        if (string != null) {
            this.descriptor.getNotificationLineSupport().setInformationMessage(string);
            this.descriptor.setValid(false);
        } else {
            this.descriptor.getNotificationLineSupport().clearMessages();
            this.descriptor.setValid(true);
        }
    }

    public static JDBCDriver showDialog(DriverNode driverNode) {
        AddDriverDialog addDriverDialog = new AddDriverDialog(driverNode);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addDriverDialog, NbBundle.getMessage(AddDriverDialog.class, (String)"AddDriverDialogTitle"));
        dialogDescriptor.createNotificationLineSupport();
        addDriverDialog.setDescriptor(dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        JDBCDriver jDBCDriver = null;
        if (DialogDescriptor.OK_OPTION == dialogDescriptor.getValue()) {
            String string;
            List<URL> list = addDriverDialog.getDriverLocation();
            String string2 = addDriverDialog.getDriverClass();
            String string3 = string = addDriverDialog.getDisplayName();
            try {
                if (driverNode != null) {
                    string3 = driverNode.getDatabaseDriver().getJDBCDriver().getName();
                    driverNode.destroy();
                }
                jDBCDriver = JDBCDriver.create(string3, string, string2, list.toArray(new URL[0]));
                JDBCDriverManager.getDefault().addDriver(jDBCDriver);
            }
            catch (DatabaseException databaseException) {
                Exceptions.printStackTrace((Throwable)databaseException);
            }
        }
        return jDBCDriver;
    }

    public static JDBCDriver showDialog() {
        return AddDriverDialog.showDialog(null);
    }

    private class FormListener
    implements ActionListener,
    ListSelectionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == AddDriverDialog.this.browseButton) {
                AddDriverDialog.this.browseButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == AddDriverDialog.this.removeButton) {
                AddDriverDialog.this.removeButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == AddDriverDialog.this.drvClassComboBox) {
                AddDriverDialog.this.drvClassComboBoxActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == AddDriverDialog.this.findButton) {
                AddDriverDialog.this.findButtonActionPerformed(actionEvent);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource() == AddDriverDialog.this.drvList) {
                AddDriverDialog.this.drvListValueChanged(listSelectionEvent);
            }
        }
    }
}

