/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionRegistry
implements ChangeListener {
    private static final Logger LOGGER = Logger.getLogger(ActionRegistry.class.getName());
    private static final String PATH = "Databases/Explorer/";
    private static final String ACTIONS = "/Actions";
    private final ChangeSupport changeSupport;
    private final List<Action> actions = new CopyOnWriteArrayList<Action>();
    private Lookup.Result lookupResult;

    public ActionRegistry(String string) {
        this.changeSupport = new ChangeSupport((Object)this);
        this.loadActions(string);
    }

    private void loadActions(String string) {
        Lookup lookup = Lookups.forPath((String)(PATH + string + ACTIONS));
        this.lookupResult = lookup.lookupResult(Object.class);
        this.initActions();
        this.lookupResult.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                ActionRegistry.this.initActions();
                ActionRegistry.this.changeSupport.fireChange();
            }
        });
    }

    private void initActions() {
        this.actions.clear();
        Collection collection = this.lookupResult.allInstances();
        for (Object e : collection) {
            if (e instanceof Action) {
                this.actions.add((Action)e);
                continue;
            }
            if (e instanceof JSeparator) {
                this.actions.add(null);
                continue;
            }
            LOGGER.log(Level.INFO, "Cannot use " + e.getClass() + " instance as DB Explorer Action");
        }
    }

    public Collection<Action> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.changeSupport.fireChange();
    }
}

